/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaRecorder;
import org.webrtc.Logging;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;

public interface CameraVideoCapturer
extends VideoCapturer {
    public void switchCamera(CameraSwitchHandler var1);

    @Deprecated
    default public void addMediaRecorderToCamera(MediaRecorder mediaRecorder, MediaRecorderHandler mediaRecorderHandler) {
        throw new UnsupportedOperationException("Deprecated and not implemented.");
    }

    @Deprecated
    default public void removeMediaRecorderFromCamera(MediaRecorderHandler mediaRecorderHandler) {
        throw new UnsupportedOperationException("Deprecated and not implemented.");
    }

    public static class CameraStatistics {
        public static final String TAG = "CameraStatistics";
        public static final int CAMERA_OBSERVER_PERIOD_MS = 2000;
        public static final int CAMERA_FREEZE_REPORT_TIMOUT_MS = 4000;
        public final SurfaceTextureHelper surfaceTextureHelper;
        public final CameraEventsHandler eventsHandler;
        public int frameCount;
        public int freezePeriodCount;
        public final Runnable cameraObserver = new Runnable(){

            @Override
            public void run() {
                1 v02 = this;
                Logging.d(CameraStatistics.TAG, "Camera fps: " + Math.round((float)frameCount * 1000.0f / 2000.0f) + ".");
                if (frameCount == 0) {
                    1 v12 = this;
                    ++freezePeriodCount;
                    if (freezePeriodCount * 2000 >= 4000 && eventsHandler != null) {
                        Logging.e(CameraStatistics.TAG, "Camera freezed.");
                        if (surfaceTextureHelper.isTextureInUse()) {
                            eventsHandler.onCameraFreezed("Camera failure. Client must return video buffers.");
                        } else {
                            eventsHandler.onCameraFreezed("Camera failure.");
                        }
                        return;
                    }
                } else {
                    CameraStatistics.access$102(this, 0);
                }
                1 v22 = this;
                CameraStatistics.access$002(v22.this, 0);
                surfaceTextureHelper.getHandler().postDelayed((Runnable)this, 2000L);
            }
        };

        public CameraStatistics(SurfaceTextureHelper surfaceTextureHelper, CameraEventsHandler cameraEventsHandler) {
            if (surfaceTextureHelper != null) {
                CameraStatistics cameraStatistics = this;
                this.surfaceTextureHelper = surfaceTextureHelper;
                cameraStatistics.eventsHandler = cameraEventsHandler;
                cameraStatistics.frameCount = 0;
                cameraStatistics.freezePeriodCount = 0;
                surfaceTextureHelper.getHandler().postDelayed(this.cameraObserver, 2000L);
                return;
            }
            throw new IllegalArgumentException("SurfaceTextureHelper is null");
        }

        private void checkThread() {
            if (Thread.currentThread() == this.surfaceTextureHelper.getHandler().getLooper().getThread()) {
                return;
            }
            throw new IllegalStateException("Wrong thread");
        }

        public static /* synthetic */ int access$102(CameraStatistics cameraStatistics, int n3) {
            cameraStatistics.freezePeriodCount = n3;
            return n3;
        }

        public static /* synthetic */ int access$002(CameraStatistics cameraStatistics, int n3) {
            cameraStatistics.frameCount = n3;
            return n3;
        }

        public void addFrame() {
            CameraStatistics cameraStatistics = this;
            cameraStatistics.checkThread();
            ++cameraStatistics.frameCount;
        }

        public void release() {
            this.surfaceTextureHelper.getHandler().removeCallbacks(this.cameraObserver);
        }
    }

    @Deprecated
    public static interface MediaRecorderHandler {
        public void onMediaRecorderSuccess();

        public void onMediaRecorderError(String var1);
    }

    public static interface CameraSwitchHandler {
        public void onCameraSwitchDone(boolean var1);

        public void onCameraSwitchError(String var1);
    }

    public static interface CameraEventsHandler {
        public void onCameraError(String var1);

        public void onCameraDisconnected();

        public void onCameraFreezed(String var1);

        public void onCameraOpening(String var1);

        public void onFirstFrameAvailable();

        public void onCameraClosed();
    }
}

