/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.graphics.Matrix;
import android.view.WindowManager;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;

public interface CameraSession {
    public static int getDeviceOrientation(Context context) {
        int n3 = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation();
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 3) {
                    return 0;
                }
                return 270;
            }
            return 180;
        }
        return 90;
    }

    public static VideoFrame.TextureBuffer createTextureBufferWithModifiedTransformMatrix(TextureBufferImpl textureBufferImpl, boolean bl, int n3) {
        Matrix matrix;
        Matrix matrix2 = matrix;
        new Matrix().preTranslate(0.5f, 0.5f);
        if (bl) {
            matrix2.preScale(-1.0f, 1.0f);
        }
        Matrix matrix3 = matrix2;
        matrix3.preRotate((float)n3);
        matrix3.preTranslate(-0.5f, -0.5f);
        return textureBufferImpl.applyTransformMatrix(matrix2, textureBufferImpl.getWidth(), textureBufferImpl.getHeight());
    }

    public void stop();

    public static interface Events {
        public void onCameraOpening();

        public void onCameraError(CameraSession var1, String var2);

        public void onCameraDisconnected(CameraSession var1);

        public void onCameraClosed(CameraSession var1);

        public void onFrameCaptured(CameraSession var1, VideoFrame var2);
    }

    public static interface CreateSessionCallback {
        public void onDone(CameraSession var1);

        public void onFailure(FailureType var1, String var2);
    }

    public static enum FailureType {
        ERROR,
        DISCONNECTED;

    }
}

