/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.graphics.ImageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.webrtc.Histogram;
import org.webrtc.Size;

public class CameraEnumerationAndroid {
    public static final String TAG = "CameraEnumerationAndroid";
    public static final ArrayList<Size> COMMON_RESOLUTIONS;

    public static CaptureFormat.FramerateRange getClosestSupportedFramerateRange(List<CaptureFormat.FramerateRange> list, final int n3) {
        return Collections.min(list, new ClosestComparator<CaptureFormat.FramerateRange>(){
            public static final int MAX_FPS_DIFF_THRESHOLD = 5000;
            public static final int MAX_FPS_LOW_DIFF_WEIGHT = 1;
            public static final int MAX_FPS_HIGH_DIFF_WEIGHT = 3;
            public static final int MIN_FPS_THRESHOLD = 8000;
            public static final int MIN_FPS_LOW_VALUE_WEIGHT = 1;
            public static final int MIN_FPS_HIGH_VALUE_WEIGHT = 4;

            private int progressivePenalty(int n32, int n4, int n5, int n6) {
                int n7;
                if (n32 < n4) {
                    n7 = n32 * n5;
                } else {
                    int n8 = n4;
                    int n9 = n8 * n5;
                    n7 = (n32 - n8) * n6 + n9;
                }
                return n7;
            }

            @Override
            public int diff(CaptureFormat.FramerateRange framerateRange) {
                1 v02 = this;
                return this.progressivePenalty(framerateRange.min, 8000, 1, 4) + v02.progressivePenalty(Math.abs(v02.n3 * 1000 - framerateRange.max), 5000, 1, 3);
            }
        });
    }

    public static Size getClosestSupportedSize(List<Size> list, final int n3, final int n4) {
        return Collections.min(list, new ClosestComparator<Size>(){

            @Override
            public int diff(Size size) {
                2 v02 = this;
                int n32 = Math.abs(v02.n3 - size.width);
                return Math.abs(v02.n4 - size.height) + n32;
            }
        });
    }

    public static void reportCameraResolution(Histogram histogram, Size size) {
        histogram.addSample(COMMON_RESOLUTIONS.indexOf(size) + 1);
    }

    static {
        Size size;
        Size size2;
        Size size3;
        Size size4;
        Size size5;
        Size size6;
        Size size7;
        Size size8;
        Size size9;
        Size size10;
        Size size11;
        Size size12;
        Size size13;
        Size size14;
        Size size15;
        Size size16;
        Size size17;
        Size size18;
        Size size19;
        Size size20;
        Size[] sizeArray = new Size[20];
        Size size21 = size20;
        size20 = new Size(160, 120);
        sizeArray[0] = size21;
        size21 = size19;
        size19 = new Size(240, 160);
        sizeArray[1] = size21;
        size21 = size18;
        size18 = new Size(320, 240);
        sizeArray[2] = size21;
        size21 = size17;
        size17 = new Size(400, 240);
        sizeArray[3] = size21;
        size21 = size16;
        size16 = new Size(480, 320);
        sizeArray[4] = size21;
        size21 = size15;
        size15 = new Size(640, 360);
        sizeArray[5] = size21;
        size21 = size14;
        size14 = new Size(640, 480);
        sizeArray[6] = size21;
        size21 = size13;
        size13 = new Size(768, 480);
        sizeArray[7] = size21;
        size21 = size12;
        size12 = new Size(854, 480);
        sizeArray[8] = size21;
        size21 = size11;
        size11 = new Size(800, 600);
        sizeArray[9] = size21;
        size21 = size10;
        size10 = new Size(960, 540);
        sizeArray[10] = size21;
        size21 = size9;
        size9 = new Size(960, 640);
        sizeArray[11] = size21;
        size21 = size8;
        size8 = new Size(1024, 576);
        sizeArray[12] = size21;
        size21 = size7;
        size7 = new Size(1024, 600);
        sizeArray[13] = size21;
        size21 = size6;
        size6 = new Size(1280, 720);
        sizeArray[14] = size21;
        size21 = size5;
        size5 = new Size(1280, 1024);
        sizeArray[15] = size21;
        size21 = size4;
        size4 = new Size(1920, 1080);
        sizeArray[16] = size21;
        size21 = size3;
        size3 = new Size(1920, 1440);
        sizeArray[17] = size21;
        size21 = size2;
        size2 = new Size(2560, 1440);
        sizeArray[18] = size21;
        size21 = size;
        size = new Size(3840, 2160);
        sizeArray[19] = size21;
        COMMON_RESOLUTIONS = new ArrayList<Size>(Arrays.asList(sizeArray));
    }

    public static abstract class ClosestComparator<T>
    implements Comparator<T> {
        public ClosestComparator() {
        }

        public /* synthetic */ ClosestComparator(1 var1_1) {
            this();
        }

        public abstract int diff(T var1);

        @Override
        public int compare(T t3, T t4) {
            return this.diff(t3) - this.diff(t4);
        }
    }

    public static class CaptureFormat {
        public final int width;
        public final int height;
        public final FramerateRange framerate;
        public final int imageFormat;

        public CaptureFormat(int n3, int n4, int n5, int n6) {
            CaptureFormat captureFormat = this;
            this.imageFormat = 17;
            this.width = n3;
            captureFormat.height = n4;
            captureFormat.framerate = new FramerateRange(n5, n6);
        }

        public CaptureFormat(int n3, int n4, FramerateRange framerateRange) {
            this.imageFormat = 17;
            this.width = n3;
            this.height = n4;
            this.framerate = framerateRange;
        }

        public static int frameSize(int n3, int n4, int n5) {
            if (n5 == 17) {
                return ImageFormat.getBitsPerPixel((int)n5) * (n3 *= n4) / 8;
            }
            throw new UnsupportedOperationException("Don't know how to calculate the frame size of non-NV21 image formats.");
        }

        public int frameSize() {
            return CaptureFormat.frameSize(this.width, this.height, 17);
        }

        public String toString() {
            return this.width + "x" + this.height + "@" + this.framerate;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CaptureFormat)) {
                return false;
            }
            object = (CaptureFormat)object;
            return this.width == ((CaptureFormat)object).width && this.height == ((CaptureFormat)object).height && this.framerate.equals(((CaptureFormat)object).framerate);
        }

        public int hashCode() {
            CaptureFormat captureFormat = this;
            int n3 = (captureFormat.width * 65497 + this.height) * 251 + 1;
            return captureFormat.framerate.hashCode() + n3;
        }

        public static class FramerateRange {
            public int min;
            public int max;

            public FramerateRange(int n3, int n4) {
                this.min = n3;
                this.max = n4;
            }

            public String toString() {
                return a.a("[").append((float)this.min / 1000.0f).append(":").append((float)this.max / 1000.0f).append("]").toString();
            }

            public boolean equals(Object object) {
                if (!(object instanceof FramerateRange)) {
                    return false;
                }
                object = (FramerateRange)object;
                return this.min == ((FramerateRange)object).min && this.max == ((FramerateRange)object).max;
            }

            public int hashCode() {
                return this.min * 65537 + 1 + this.max;
            }
        }
    }
}

