/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import java.util.Arrays;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraSession;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.CapturerObserver;
import org.webrtc.Logging;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoFrame;

public abstract class CameraCapturer
implements CameraVideoCapturer {
    public static final String TAG = "CameraCapturer";
    public static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    public static final int OPEN_CAMERA_DELAY_MS = 500;
    public static final int OPEN_CAMERA_TIMEOUT = 10000;
    public final CameraEnumerator cameraEnumerator;
    @Nullable
    public final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    public final Handler uiThreadHandler;
    @Nullable
    public final CameraSession.CreateSessionCallback createSessionCallback = new CameraSession.CreateSessionCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void onDone(CameraSession var1_1) {
            v0 = this;
            CameraCapturer.access$000(v0.CameraCapturer.this);
            Logging.d("CameraCapturer", "Create session done. Switch state: " + (Object)CameraCapturer.access$100(CameraCapturer.this));
            CameraCapturer.access$300(v0.CameraCapturer.this).removeCallbacks(CameraCapturer.access$200(CameraCapturer.this));
            var2_2 = CameraCapturer.access$400(v0.CameraCapturer.this);
            synchronized (var2_2) {
                block14: {
                    CameraCapturer.access$500(v0.CameraCapturer.this).onCapturerStarted(true);
                    CameraCapturer.access$602(v0.CameraCapturer.this, false);
                    CameraCapturer.access$702(v0.CameraCapturer.this, var1_1);
                    CameraCapturer.access$802(v0.CameraCapturer.this, new CameraVideoCapturer.CameraStatistics(CameraCapturer.access$900(CameraCapturer.this), CameraCapturer.access$1000(CameraCapturer.this)));
                    CameraCapturer.access$1102(v0.CameraCapturer.this, false);
                    CameraCapturer.access$400(v0.CameraCapturer.this).notifyAll();
                    if (CameraCapturer.access$100(v0.CameraCapturer.this) != SwitchState.IN_PROGRESS) break block14;
                    v2 = this;
                    v3 = v2;
                    CameraCapturer.access$102(v2.CameraCapturer.this, SwitchState.IDLE);
                    ** if (CameraCapturer.access$1200((CameraCapturer)v3.CameraCapturer.this) == null) goto lbl37
lbl-1000:
                    // 1 sources

                    {
                        v4 = this;
                        CameraCapturer.access$1200(v4.CameraCapturer.this).onCameraSwitchDone(CameraCapturer.access$1400(CameraCapturer.this).isFrontFacing(CameraCapturer.access$1300(CameraCapturer.this)));
                        CameraCapturer.access$1202(v4.CameraCapturer.this, null);
                    }
lbl37:
                    // 2 sources

                    ** GOTO lbl48
                }
                if (CameraCapturer.access$100(CameraCapturer.this) != SwitchState.PENDING) ** GOTO lbl48
                v5 = this;
                v6 = v5;
                CameraCapturer.access$102(v5.CameraCapturer.this, SwitchState.IDLE);
                CameraCapturer.access$1500(v6.CameraCapturer.this, CameraCapturer.access$1200(CameraCapturer.this));
lbl48:
                // 3 sources

                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void onFailure(CameraSession.FailureType var1_1, String var2_2) {
            v0 = this;
            CameraCapturer.access$000(v0.CameraCapturer.this);
            CameraCapturer.access$300(v0.CameraCapturer.this).removeCallbacks(CameraCapturer.access$200(CameraCapturer.this));
            var3_3 = CameraCapturer.access$400(v0.CameraCapturer.this);
            synchronized (var3_3) {
                block12: {
                    block13: {
                        block14: {
                            CameraCapturer.access$500(v0.CameraCapturer.this).onCapturerStarted(false);
                            CameraCapturer.access$1610(v0.CameraCapturer.this);
                            if (CameraCapturer.access$1600(v0.CameraCapturer.this) > 0) break block12;
                            v2 = this;
                            Logging.w("CameraCapturer", "Opening camera failed, passing: " + var2_2);
                            CameraCapturer.access$602(v2.CameraCapturer.this, false);
                            CameraCapturer.access$400(v2.CameraCapturer.this).notifyAll();
                            if (CameraCapturer.access$100(v2.CameraCapturer.this) == SwitchState.IDLE) break block13;
                            if (CameraCapturer.access$1200(CameraCapturer.this) == null) break block14;
                            v3 = this;
                            CameraCapturer.access$1200(v3.CameraCapturer.this).onCameraSwitchError(var2_2);
                            CameraCapturer.access$1202(v3.CameraCapturer.this, null);
                        }
                        CameraCapturer.access$102(CameraCapturer.this, SwitchState.IDLE);
                    }
                    if (var1_1 != CameraSession.FailureType.DISCONNECTED) ** GOTO lbl39
                    CameraCapturer.access$1000(CameraCapturer.this).onCameraDisconnected();
                    ** GOTO lbl45
lbl39:
                    // 1 sources

                    CameraCapturer.access$1000(CameraCapturer.this).onCameraError(var2_2);
                    ** GOTO lbl45
                }
                Logging.w("CameraCapturer", "Opening camera failed, retry: " + var2_2);
                CameraCapturer.access$1700(CameraCapturer.this, 500);
lbl45:
                // 3 sources

                return;
            }
        }
    };
    @Nullable
    public final CameraSession.Events cameraSessionEventsHandler = new CameraSession.Events(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onCameraOpening() {
            2 v02 = this;
            v02.CameraCapturer.this.checkIsOnCameraThread();
            Object object = v02.CameraCapturer.this.stateLock;
            synchronized (object) {
                if (v02.CameraCapturer.this.currentSession != null) {
                    Logging.w(CameraCapturer.TAG, "onCameraOpening while session was open.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraOpening(CameraCapturer.this.cameraName);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onCameraError(CameraSession object, String string2) {
            Object object2 = object;
            2 v12 = this;
            v12.CameraCapturer.this.checkIsOnCameraThread();
            object = v12.CameraCapturer.this.stateLock;
            synchronized (object) {
                if (object2 != v12.CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraError from another session: " + string2);
                    return;
                }
                2 v22 = this;
                v22.CameraCapturer.this.eventsHandler.onCameraError(string2);
                v22.CameraCapturer.this.stopCapture();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onCameraDisconnected(CameraSession object) {
            Object object2 = object;
            2 v12 = this;
            v12.CameraCapturer.this.checkIsOnCameraThread();
            object = v12.CameraCapturer.this.stateLock;
            synchronized (object) {
                if (object2 != v12.CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraDisconnected from another session.");
                    return;
                }
                2 v22 = this;
                v22.CameraCapturer.this.eventsHandler.onCameraDisconnected();
                v22.CameraCapturer.this.stopCapture();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onCameraClosed(CameraSession object) {
            Object object2 = object;
            2 v12 = this;
            v12.CameraCapturer.this.checkIsOnCameraThread();
            object = v12.CameraCapturer.this.stateLock;
            synchronized (object) {
                if (object2 != v12.CameraCapturer.this.currentSession && CameraCapturer.this.currentSession != null) {
                    Logging.d(CameraCapturer.TAG, "onCameraClosed from another session.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraClosed();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onFrameCaptured(CameraSession object, VideoFrame videoFrame) {
            Object object2 = object;
            2 v12 = this;
            v12.CameraCapturer.this.checkIsOnCameraThread();
            object = v12.CameraCapturer.this.stateLock;
            synchronized (object) {
                block6: {
                    if (object2 != v12.CameraCapturer.this.currentSession) {
                        Logging.w(CameraCapturer.TAG, "onFrameCaptured from another session.");
                        return;
                    }
                    if (CameraCapturer.this.firstFrameObserved) break block6;
                    2 v22 = this;
                    v22.CameraCapturer.this.eventsHandler.onFirstFrameAvailable();
                    CameraCapturer.access$1102(v22.CameraCapturer.this, true);
                }
                2 v4 = this;
                v4.CameraCapturer.this.cameraStatistics.addFrame();
                v4.CameraCapturer.this.capturerObserver.onFrameCaptured(videoFrame);
                return;
            }
        }
    };
    public final Runnable openCameraTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            CameraCapturer.this.eventsHandler.onCameraError("Camera failed to start within timeout.");
        }
    };
    @Nullable
    public Handler cameraThreadHandler;
    public Context applicationContext;
    public CapturerObserver capturerObserver;
    @Nullable
    public SurfaceTextureHelper surfaceHelper;
    public final Object stateLock = new Object();
    public boolean sessionOpening;
    @Nullable
    public CameraSession currentSession;
    public String cameraName;
    public int width;
    public int height;
    public int framerate;
    public int openAttemptsRemaining;
    public SwitchState switchState = SwitchState.IDLE;
    @Nullable
    public CameraVideoCapturer.CameraSwitchHandler switchEventsHandler;
    @Nullable
    public CameraVideoCapturer.CameraStatistics cameraStatistics;
    public boolean firstFrameObserved;

    public CameraCapturer(String stringArray, @Nullable CameraVideoCapturer.CameraEventsHandler cameraEventsHandler, CameraEnumerator cameraEnumerator) {
        if (cameraEventsHandler == null) {
            CameraVideoCapturer.CameraEventsHandler cameraEventsHandler2;
            cameraEventsHandler = cameraEventsHandler2;
            cameraEventsHandler2 = new CameraVideoCapturer.CameraEventsHandler(){

                @Override
                public void onCameraError(String string2) {
                }

                @Override
                public void onCameraDisconnected() {
                }

                @Override
                public void onCameraFreezed(String string2) {
                }

                @Override
                public void onCameraOpening(String string2) {
                }

                @Override
                public void onFirstFrameAvailable() {
                }

                @Override
                public void onCameraClosed() {
                }
            };
        }
        CameraCapturer cameraCapturer = this;
        this.eventsHandler = cameraEventsHandler;
        this.cameraEnumerator = cameraEnumerator;
        cameraCapturer.cameraName = stringArray;
        cameraCapturer.uiThreadHandler = new Handler(Looper.getMainLooper());
        stringArray = cameraEnumerator.getDeviceNames();
        if (stringArray.length != 0) {
            if (Arrays.asList(stringArray).contains(this.cameraName)) {
                return;
            }
            throw new IllegalArgumentException(a.a("Camera name ").append(this.cameraName).append(" does not match any known camera device.").toString());
        }
        throw new RuntimeException("No cameras attached.");
    }

    private void createSessionInternal(int n3) {
        CameraCapturer cameraCapturer = this;
        cameraCapturer.uiThreadHandler.postDelayed(this.openCameraTimeoutRunnable, (long)(n3 + 10000));
        cameraCapturer.cameraThreadHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CameraCapturer cameraCapturer = CameraCapturer.this;
                cameraCapturer.createCameraSession(cameraCapturer.createSessionCallback, CameraCapturer.this.cameraSessionEventsHandler, CameraCapturer.this.applicationContext, CameraCapturer.this.surfaceHelper, CameraCapturer.this.cameraName, CameraCapturer.this.width, CameraCapturer.this.height, CameraCapturer.this.framerate);
            }
        }, (long)n3);
    }

    private void reportCameraSwitchError(String string2, @Nullable CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        Logging.e(TAG, string2);
        if (cameraSwitchHandler != null) {
            cameraSwitchHandler.onCameraSwitchError(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void switchCameraInternal(@Nullable CameraVideoCapturer.CameraSwitchHandler object) {
        Logging.d(TAG, "switchCamera internal");
        String[] stringArray = this.cameraEnumerator.getDeviceNames();
        if (stringArray.length < 2) {
            if (object != null) {
                object.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        CameraCapturer cameraCapturer = this;
        Object object2 = cameraCapturer.stateLock;
        synchronized (object2) {
            if (cameraCapturer.switchState != SwitchState.IDLE) {
                this.reportCameraSwitchError("Camera switch already in progress.", (CameraVideoCapturer.CameraSwitchHandler)object);
                return;
            }
            if (!this.sessionOpening && this.currentSession == null) {
                this.reportCameraSwitchError("switchCamera: camera is not running.", (CameraVideoCapturer.CameraSwitchHandler)object);
                return;
            }
            this.switchEventsHandler = object;
            if (this.sessionOpening) {
                this.switchState = SwitchState.PENDING;
                return;
            }
            Object object3 = object2;
            CameraCapturer cameraCapturer2 = this;
            CameraCapturer cameraCapturer3 = cameraCapturer2;
            CameraCapturer cameraCapturer4 = cameraCapturer2;
            CameraCapturer cameraCapturer5 = cameraCapturer2;
            CameraCapturer cameraCapturer6 = cameraCapturer2;
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            CameraCapturer cameraCapturer7 = this;
            CameraCapturer cameraCapturer8 = cameraCapturer7;
            cameraCapturer7.switchState = SwitchState.IN_PROGRESS;
            Logging.d(TAG, "switchCamera: Stopping session");
            cameraCapturer7.cameraStatistics.release();
            cameraCapturer7.cameraStatistics = null;
            object = cameraCapturer7.currentSession;
            cameraCapturer7.cameraThreadHandler.post(new Runnable((CameraSession)object){
                public final /* synthetic */ CameraSession val$oldSession;
                {
                    this.val$oldSession = cameraSession;
                }

                @Override
                public void run() {
                    this.val$oldSession.stop();
                }
            });
            cameraCapturer8.currentSession = null;
            cameraCapturer3.cameraName = stringArray3[(Arrays.asList(stringArray2).indexOf(this.cameraName) + 1) % stringArray.length];
            cameraCapturer4.sessionOpening = true;
            cameraCapturer5.openAttemptsRemaining = 1;
            cameraCapturer6.createSessionInternal(0);
            // ** MonitorExit[v1] (shouldn't be in output)
            Logging.d(TAG, "switchCamera done");
            return;
        }
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() == this.cameraThreadHandler.getLooper().getThread()) {
            return;
        }
        Logging.e(TAG, "Check is on camera thread failed.");
        throw new RuntimeException("Not on camera thread.");
    }

    public static /* synthetic */ SwitchState access$100(CameraCapturer cameraCapturer) {
        return cameraCapturer.switchState;
    }

    public static /* synthetic */ Runnable access$200(CameraCapturer cameraCapturer) {
        return cameraCapturer.openCameraTimeoutRunnable;
    }

    public static /* synthetic */ Handler access$300(CameraCapturer cameraCapturer) {
        return cameraCapturer.uiThreadHandler;
    }

    public static /* synthetic */ boolean access$602(CameraCapturer cameraCapturer, boolean bl) {
        cameraCapturer.sessionOpening = bl;
        return bl;
    }

    public static /* synthetic */ CameraSession access$702(CameraCapturer cameraCapturer, CameraSession cameraSession) {
        cameraCapturer.currentSession = cameraSession;
        return cameraSession;
    }

    public static /* synthetic */ CameraVideoCapturer.CameraStatistics access$802(CameraCapturer cameraCapturer, CameraVideoCapturer.CameraStatistics cameraStatistics) {
        cameraCapturer.cameraStatistics = cameraStatistics;
        return cameraStatistics;
    }

    public static /* synthetic */ boolean access$1102(CameraCapturer cameraCapturer, boolean bl) {
        cameraCapturer.firstFrameObserved = bl;
        return bl;
    }

    public static /* synthetic */ SwitchState access$102(CameraCapturer cameraCapturer, SwitchState switchState) {
        cameraCapturer.switchState = switchState;
        return switchState;
    }

    public static /* synthetic */ CameraVideoCapturer.CameraSwitchHandler access$1200(CameraCapturer cameraCapturer) {
        return cameraCapturer.switchEventsHandler;
    }

    public static /* synthetic */ CameraEnumerator access$1400(CameraCapturer cameraCapturer) {
        return cameraCapturer.cameraEnumerator;
    }

    public static /* synthetic */ CameraVideoCapturer.CameraSwitchHandler access$1202(CameraCapturer cameraCapturer, CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        cameraCapturer.switchEventsHandler = cameraSwitchHandler;
        return cameraSwitchHandler;
    }

    public static /* synthetic */ int access$1610(CameraCapturer cameraCapturer) {
        return cameraCapturer.openAttemptsRemaining--;
    }

    public static /* synthetic */ int access$1600(CameraCapturer cameraCapturer) {
        return cameraCapturer.openAttemptsRemaining;
    }

    public static /* synthetic */ void access$1700(CameraCapturer cameraCapturer, int n3) {
        cameraCapturer.createSessionInternal(n3);
    }

    @Override
    public void initialize(@Nullable SurfaceTextureHelper surfaceTextureHelper, Context context, CapturerObserver capturerObserver) {
        this.applicationContext = context;
        this.capturerObserver = capturerObserver;
        this.surfaceHelper = surfaceTextureHelper;
        surfaceTextureHelper = surfaceTextureHelper == null ? null : surfaceTextureHelper.getHandler();
        this.cameraThreadHandler = surfaceTextureHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startCapture(int n3, int n4, int n5) {
        Logging.d(TAG, "startCapture: " + n3 + "x" + n4 + "@" + n5);
        if (this.applicationContext == null) {
            throw new RuntimeException("CameraCapturer must be initialized before calling startCapture.");
        }
        CameraCapturer cameraCapturer = this;
        Object object = cameraCapturer.stateLock;
        synchronized (object) {
            if (!cameraCapturer.sessionOpening && this.currentSession == null) {
                this.width = n3;
                this.height = n4;
                this.framerate = n5;
                this.sessionOpening = true;
                this.openAttemptsRemaining = 3;
                this.createSessionInternal(0);
                return;
            }
            Logging.w(TAG, "Session already open");
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void stopCapture() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeCaptureFormat(int n3, int n4, int n5) {
        Logging.d(TAG, "changeCaptureFormat: " + n3 + "x" + n4 + "@" + n5);
        Object object = this.stateLock;
        synchronized (object) {
            this.stopCapture();
            this.startCapture(n3, n4, n5);
            return;
        }
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "dispose");
        this.stopCapture();
    }

    @Override
    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        Logging.d(TAG, "switchCamera");
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                CameraCapturer.this.switchCameraInternal(cameraSwitchHandler);
            }
        });
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    public void printStackTrace() {
        CameraCapturer cameraCapturer = stackTraceElementArray;
        StackTraceElement[] stackTraceElementArray = null;
        Handler handler = cameraCapturer.cameraThreadHandler;
        if (handler != null) {
            stackTraceElementArray = handler.getLooper().getThread();
        }
        if (stackTraceElementArray != null && (stackTraceElementArray = stackTraceElementArray.getStackTrace()).length > 0) {
            Logging.d(TAG, "CameraCapturer stack trace:");
            int n3 = stackTraceElementArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Logging.d(TAG, stackTraceElementArray[i3].toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCameraName() {
        CameraCapturer cameraCapturer = object;
        Object object = cameraCapturer.stateLock;
        synchronized (object) {
            return cameraCapturer.cameraName;
        }
    }

    public abstract void createCameraSession(CameraSession.CreateSessionCallback var1, CameraSession.Events var2, Context var3, SurfaceTextureHelper var4, String var5, int var6, int var7, int var8);

    public static enum SwitchState {
        IDLE,
        PENDING,
        IN_PROGRESS;

    }
}

