/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.Range;
import android.view.Surface;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraSession;
import org.webrtc.Histogram;
import org.webrtc.Logging;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;

@TargetApi(value=21)
public class Camera2Session
implements CameraSession {
    public static final String TAG = "Camera2Session";
    public static final Histogram camera2StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StartTimeMs", 1, 10000, 50);
    public static final Histogram camera2StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StopTimeMs", 1, 10000, 50);
    public static final Histogram camera2ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera2.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    public final Handler cameraThreadHandler;
    public final CameraSession.CreateSessionCallback callback;
    public final CameraSession.Events events;
    public final Context applicationContext;
    public final CameraManager cameraManager;
    public final SurfaceTextureHelper surfaceTextureHelper;
    public final String cameraId;
    public final int width;
    public final int height;
    public final int framerate;
    public CameraCharacteristics cameraCharacteristics;
    public int cameraOrientation;
    public boolean isCameraFrontFacing;
    public int fpsUnitFactor;
    public CameraEnumerationAndroid.CaptureFormat captureFormat;
    @Nullable
    public CameraDevice cameraDevice;
    @Nullable
    public Surface surface;
    @Nullable
    public CameraCaptureSession captureSession;
    public SessionState state = SessionState.RUNNING;
    public boolean firstFrameReported;
    public final long constructionTimeNs;

    public static void create(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String string2, int n3, int n4, int n5) {
        new Camera2Session(createSessionCallback, events, context, cameraManager, surfaceTextureHelper, string2, n3, n4, n5);
    }

    public Camera2Session(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context context, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String string2, int n3, int n4, int n5) {
        Logging.d(TAG, "Create new camera2 session on camera " + string2);
        this.constructionTimeNs = System.nanoTime();
        this.cameraThreadHandler = new Handler();
        this.callback = createSessionCallback;
        this.events = events;
        this.applicationContext = context;
        this.cameraManager = cameraManager;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = string2;
        this.width = n3;
        this.height = n4;
        this.framerate = n5;
        this.start();
    }

    private void start() {
        Camera2Session camera2Session = this;
        camera2Session.checkIsOnCameraThread();
        Logging.d(TAG, "start");
        try {
            camera2Session.cameraCharacteristics = camera2Session.cameraManager.getCameraCharacteristics(this.cameraId);
            camera2Session.cameraOrientation = (Integer)camera2Session.cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
            boolean bl = (Integer)camera2Session.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
            Camera2Session camera2Session2 = this;
            camera2Session2.isCameraFrontFacing = bl;
            camera2Session2.findCaptureFormat();
            camera2Session2.openCamera();
            return;
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError(a.a("getCameraCharacteristics(): ").append(cameraAccessException.getMessage()).toString());
            return;
        }
    }

    private void findCaptureFormat() {
        Camera2Session camera2Session = this;
        camera2Session.checkIsOnCameraThread();
        Object object = (Range[])camera2Session.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        this.fpsUnitFactor = Camera2Enumerator.getFpsUnitFactor(object);
        object = Camera2Enumerator.convertFramerates(object, this.fpsUnitFactor);
        Object object2 = Camera2Enumerator.getSupportedSizes(this.cameraCharacteristics);
        Logging.d(TAG, "Available preview sizes: " + object2);
        Logging.d(TAG, "Available fps ranges: " + object);
        if (!object.isEmpty() && !object2.isEmpty()) {
            object = CameraEnumerationAndroid.getClosestSupportedFramerateRange((List<CameraEnumerationAndroid.CaptureFormat.FramerateRange>)object, this.framerate);
            object2 = CameraEnumerationAndroid.getClosestSupportedSize(object2, this.width, this.height);
            CameraEnumerationAndroid.reportCameraResolution(camera2ResolutionHistogram, (Size)object2);
            this.captureFormat = new CameraEnumerationAndroid.CaptureFormat(((Size)object2).width, ((Size)object2).height, (CameraEnumerationAndroid.CaptureFormat.FramerateRange)object);
            Logging.d(TAG, a.a("Using capture format: ").append(this.captureFormat).toString());
            return;
        }
        this.reportError("No supported capture formats.");
    }

    private void openCamera() {
        String string2;
        CameraManager cameraManager;
        Camera2Session camera2Session = this;
        camera2Session.checkIsOnCameraThread();
        Logging.d(TAG, a.a("Opening camera ").append(this.cameraId).toString());
        camera2Session.events.onCameraOpening();
        try {
            cameraManager = camera2Session.cameraManager;
            string2 = this.cameraId;
        }
        catch (CameraAccessException cameraAccessException) {
            this.reportError("Failed to open camera: " + (Object)((Object)cameraAccessException));
            return;
        }
        cameraManager.openCamera(string2, (CameraDevice.StateCallback)new CameraStateCallback(null), this.cameraThreadHandler);
    }

    private void stopInternal() {
        Camera2Session camera2Session = this;
        Logging.d(TAG, "Stop internal");
        camera2Session.checkIsOnCameraThread();
        camera2Session.surfaceTextureHelper.stopListening();
        CameraCaptureSession cameraCaptureSession = camera2Session.captureSession;
        if (cameraCaptureSession != null) {
            cameraCaptureSession.close();
            this.captureSession = null;
        }
        if ((cameraCaptureSession = this.surface) != null) {
            cameraCaptureSession.release();
            this.surface = null;
        }
        if ((cameraCaptureSession = this.cameraDevice) != null) {
            cameraCaptureSession.close();
            this.cameraDevice = null;
        }
        Logging.d(TAG, "Stop done");
    }

    private void reportError(String string2) {
        Camera2Session camera2Session = this;
        camera2Session.checkIsOnCameraThread();
        Logging.e(TAG, "Error: " + string2);
        boolean bl = camera2Session.captureSession == null && this.state != SessionState.STOPPED;
        this.state = SessionState.STOPPED;
        this.stopInternal();
        if (bl) {
            this.callback.onFailure(CameraSession.FailureType.ERROR, string2);
        } else {
            this.events.onCameraError(this, string2);
        }
    }

    private int getFrameOrientation() {
        Camera2Session camera2Session = this;
        int n3 = CameraSession.getDeviceOrientation(camera2Session.applicationContext);
        if (!camera2Session.isCameraFrontFacing) {
            n3 = 360 - n3;
        }
        return (this.cameraOrientation + n3) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() == this.cameraThreadHandler.getLooper().getThread()) {
            return;
        }
        throw new IllegalStateException("Wrong thread");
    }

    public static /* synthetic */ SessionState access$202(Camera2Session camera2Session, SessionState sessionState) {
        camera2Session.state = sessionState;
        return sessionState;
    }

    public static /* synthetic */ CameraDevice access$702(Camera2Session camera2Session, CameraDevice cameraDevice) {
        camera2Session.cameraDevice = cameraDevice;
        return cameraDevice;
    }

    public static /* synthetic */ Surface access$1002(Camera2Session camera2Session, Surface surface) {
        camera2Session.surface = surface;
        return surface;
    }

    public static /* synthetic */ CameraCaptureSession access$102(Camera2Session camera2Session, CameraCaptureSession cameraCaptureSession) {
        camera2Session.captureSession = cameraCaptureSession;
        return cameraCaptureSession;
    }

    public static /* synthetic */ boolean access$1602(Camera2Session camera2Session, boolean bl) {
        camera2Session.firstFrameReported = bl;
        return bl;
    }

    @Override
    public void stop() {
        Camera2Session camera2Session = this;
        Logging.d(TAG, a.a("Stop camera2 session on camera ").append(this.cameraId).toString());
        camera2Session.checkIsOnCameraThread();
        if (camera2Session.state != SessionState.STOPPED) {
            long l3 = System.nanoTime();
            this.state = SessionState.STOPPED;
            this.stopInternal();
            camera2StopTimeMsHistogram.addSample((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l3));
        }
    }

    public static class CameraCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        public CameraCaptureCallback() {
        }

        public /* synthetic */ CameraCaptureCallback(1 var1_1) {
            this();
        }

        public void onCaptureFailed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            Logging.d(Camera2Session.TAG, "Capture failed: " + captureFailure);
        }
    }

    public class CaptureSessionCallback
    extends CameraCaptureSession.StateCallback {
        public CaptureSessionCallback() {
        }

        private void chooseStabilizationMode(CaptureRequest.Builder builder) {
            int n3;
            int[] nArray = (int[])object.Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
            if (nArray != null) {
                n3 = nArray.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (nArray[i3] != 1) continue;
                    CaptureRequest.Builder builder2 = builder;
                    builder2.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                    builder2.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                    Logging.d(Camera2Session.TAG, "Using optical stabilization.");
                    return;
                }
            }
            int[] nArray2 = (int[])object.Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
            Object object = nArray2;
            int n4 = nArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (object[n3] != true) continue;
                CaptureRequest.Builder builder3 = builder;
                builder3.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                builder3.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                Logging.d(Camera2Session.TAG, "Using video stabilization.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Stabilization not available.");
        }

        private void chooseFocusMode(CaptureRequest.Builder builder) {
            int[] nArray = (int[])object.Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
            Object object = nArray;
            int n3 = nArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (object[i3] != 3) continue;
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                Logging.d(Camera2Session.TAG, "Using continuous video auto-focus.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Auto-focus is not available.");
        }

        public /* synthetic */ CaptureSessionCallback(1 var2_2) {
            this();
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            Camera2Session.this.checkIsOnCameraThread();
            cameraCaptureSession.close();
            Camera2Session.this.reportError("Failed to configure capture session.");
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            CaptureSessionCallback captureSessionCallback = this;
            CameraCaptureSession cameraCaptureSession2 = cameraCaptureSession;
            CaptureSessionCallback captureSessionCallback2 = this;
            captureSessionCallback2.Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera capture session configured.");
            Camera2Session.access$102(captureSessionCallback2.Camera2Session.this, cameraCaptureSession);
            try {
                cameraCaptureSession = captureSessionCallback2.Camera2Session.this.cameraDevice.createCaptureRequest(3);
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.this.reportError("Failed to start capture request. " + (Object)((Object)cameraAccessException));
                return;
            }
            CaptureSessionCallback captureSessionCallback3 = this;
            CameraCaptureSession cameraCaptureSession3 = cameraCaptureSession;
            cameraCaptureSession3.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.min / Camera2Session.this.fpsUnitFactor), (Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.max / Camera2Session.this.fpsUnitFactor)));
            cameraCaptureSession3.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            cameraCaptureSession3.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
            this.chooseStabilizationMode((CaptureRequest.Builder)cameraCaptureSession3);
            captureSessionCallback3.chooseFocusMode((CaptureRequest.Builder)cameraCaptureSession);
            cameraCaptureSession.addTarget(captureSessionCallback3.Camera2Session.this.surface);
            CaptureRequest captureRequest = cameraCaptureSession.build();
            cameraCaptureSession2.setRepeatingRequest(captureRequest, (CameraCaptureSession.CaptureCallback)new CameraCaptureCallback(null), Camera2Session.this.cameraThreadHandler);
            captureSessionCallback.Camera2Session.this.surfaceTextureHelper.startListening(videoFrame -> {
                VideoFrame videoFrame2;
                CaptureSessionCallback captureSessionCallback = this;
                captureSessionCallback.Camera2Session.this.checkIsOnCameraThread();
                if (captureSessionCallback.Camera2Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera2Session.TAG, "Texture frame captured but camera is no longer running.");
                    return;
                }
                if (!Camera2Session.this.firstFrameReported) {
                    Camera2Session.access$1602(Camera2Session.this, true);
                    camera2StartTimeMsHistogram.addSample((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera2Session.this.constructionTimeNs));
                }
                VideoFrame videoFrame3 = videoFrame2;
                videoFrame3(CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)videoFrame.getBuffer(), Camera2Session.this.isCameraFrontFacing, -Camera2Session.this.cameraOrientation), Camera2Session.this.getFrameOrientation(), videoFrame.getTimestampNs());
                Camera2Session.this.events.onFrameCaptured(Camera2Session.this, videoFrame3);
                videoFrame2.release();
            });
            Logging.d(Camera2Session.TAG, "Camera device successfully started.");
            captureSessionCallback.Camera2Session.this.callback.onDone(Camera2Session.this);
        }
    }

    public class CameraStateCallback
    extends CameraDevice.StateCallback {
        public CameraStateCallback() {
        }

        private String getErrorDescription(int n3) {
            switch (n3) {
                default: {
                    return "Unknown camera error: " + n3;
                }
                case 5: {
                    return "Camera service has encountered a fatal error.";
                }
                case 4: {
                    return "Camera device has encountered a fatal error.";
                }
                case 3: {
                    return "Camera device could not be opened due to a device policy.";
                }
                case 2: {
                    return "Camera device could not be opened because there are too many other open camera devices.";
                }
                case 1: 
            }
            return "Camera device is in use already.";
        }

        public /* synthetic */ CameraStateCallback(1 var2_2) {
            this();
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            CameraStateCallback cameraStateCallback = this;
            cameraStateCallback.Camera2Session.this.checkIsOnCameraThread();
            boolean bl = cameraStateCallback.Camera2Session.this.captureSession == null && Camera2Session.this.state != SessionState.STOPPED;
            CameraStateCallback cameraStateCallback2 = this;
            Camera2Session.access$202(cameraStateCallback2.Camera2Session.this, SessionState.STOPPED);
            cameraStateCallback2.Camera2Session.this.stopInternal();
            if (bl) {
                Camera2Session.this.callback.onFailure(CameraSession.FailureType.DISCONNECTED, "Camera disconnected / evicted.");
            } else {
                Camera2Session.this.events.onCameraDisconnected(Camera2Session.this);
            }
        }

        public void onError(CameraDevice cameraDevice, int n3) {
            CameraStateCallback cameraStateCallback = this;
            cameraStateCallback.Camera2Session.this.checkIsOnCameraThread();
            cameraStateCallback.Camera2Session.this.reportError(this.getErrorDescription(n3));
        }

        public void onOpened(CameraDevice object) {
            Surface[] surfaceArray;
            CameraDevice cameraDevice = object;
            CameraStateCallback cameraStateCallback = this;
            cameraStateCallback.Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera opened.");
            Camera2Session.access$702(cameraStateCallback.Camera2Session.this, object);
            cameraStateCallback.Camera2Session.this.surfaceTextureHelper.setTextureSize(((Camera2Session)Camera2Session.this).captureFormat.width, ((Camera2Session)Camera2Session.this).captureFormat.height);
            object = cameraStateCallback.Camera2Session.this;
            Camera2Session.access$1002((Camera2Session)object, new Surface(((Camera2Session)object).surfaceTextureHelper.getSurfaceTexture()));
            try {
                surfaceArray = new Surface[1];
            }
            catch (CameraAccessException cameraAccessException) {
                Camera2Session.this.reportError("Failed to create capture session. " + (Object)((Object)cameraAccessException));
                return;
            }
            surfaceArray[0] = Camera2Session.this.surface;
            List<Surface> list = Arrays.asList(surfaceArray);
            cameraDevice.createCaptureSession(list, (CameraCaptureSession.StateCallback)new CaptureSessionCallback(null), Camera2Session.this.cameraThreadHandler);
        }

        public void onClosed(CameraDevice cameraDevice) {
            CameraStateCallback cameraStateCallback = this;
            cameraStateCallback.Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera device closed.");
            cameraStateCallback.Camera2Session.this.events.onCameraClosed(Camera2Session.this);
        }
    }

    public static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

