/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AndroidException;
import android.util.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.webrtc.Camera2Capturer;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.Logging;
import org.webrtc.Size;

@TargetApi(value=21)
public class Camera2Enumerator
implements CameraEnumerator {
    public static final String TAG = "Camera2Enumerator";
    public static final double NANO_SECONDS_PER_SECOND = 1.0E9;
    public static final Map<String, List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats = new HashMap<String, List<CameraEnumerationAndroid.CaptureFormat>>();
    public final Context context;
    @Nullable
    public final CameraManager cameraManager;

    public Camera2Enumerator(Context context) {
        this.context = context;
        this.cameraManager = (CameraManager)context.getSystemService("camera");
    }

    @Nullable
    private CameraCharacteristics getCameraCharacteristics(String string2) {
        try {
            return this.cameraManager.getCameraCharacteristics(string2);
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: " + (Object)((Object)androidException));
            return null;
        }
    }

    public static boolean isSupported(Context context) {
        int n3;
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        context = (CameraManager)context.getSystemService("camera");
        String[] stringArray = context.getCameraIdList();
        try {
            n3 = stringArray.length;
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: " + (Object)((Object)androidException));
            return false;
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            if ((Integer)context.getCameraCharacteristics(stringArray[i3]).get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) != 2) continue;
            return false;
        }
        return true;
    }

    public static int getFpsUnitFactor(Range<Integer>[] rangeArray) {
        if (rangeArray.length == 0) {
            return 1000;
        }
        return (Integer)rangeArray[0].getUpper() < 1000 ? 1000 : 1;
    }

    public static List<Size> getSupportedSizes(CameraCharacteristics cameraCharacteristics) {
        int n3 = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        Object object = Camera2Enumerator.convertSizes(((StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputSizes(SurfaceTexture.class));
        if (Build.VERSION.SDK_INT < 22 && n3 == 2) {
            ArrayList<Size> arrayList;
            cameraCharacteristics = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            ArrayList<Size> arrayList2 = arrayList;
            arrayList = new ArrayList<Size>();
            object = object.iterator();
            while (object.hasNext()) {
                Size size = (Size)object.next();
                if (cameraCharacteristics.width() * size.height != cameraCharacteristics.height() * size.width) continue;
                arrayList2.add(size);
            }
            return arrayList2;
        }
        return object;
    }

    public static List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(Context context, String string2) {
        return Camera2Enumerator.getSupportedFormats((CameraManager)context.getSystemService("camera"), string2);
    }

    /*
     * Exception decompiling
     */
    public static List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(CameraManager var0, String var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[UNCONDITIONALDOLOOP]], but top level block is 16[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<Size> convertSizes(android.util.Size[] sizeArray) {
        ArrayList<Size> arrayList;
        ArrayList<Size> arrayList2 = arrayList;
        arrayList = new ArrayList<Size>();
        for (android.util.Size size : sizeArray) {
            arrayList2.add(new Size(size.getWidth(), size.getHeight()));
        }
        return arrayList2;
    }

    public static List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> convertFramerates(Range<Integer>[] rangeArray, int n3) {
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList;
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList2 = arrayList;
        arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        for (Range<Integer> range : rangeArray) {
            arrayList2.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange((Integer)range.getLower() * n3, (Integer)range.getUpper() * n3));
        }
        return arrayList2;
    }

    @Override
    public String[] getDeviceNames() {
        try {
            return this.cameraManager.getCameraIdList();
        }
        catch (AndroidException androidException) {
            Logging.e(TAG, "Camera access exception: " + (Object)((Object)androidException));
            return new String[0];
        }
    }

    @Override
    public boolean isFrontFacing(String string2) {
        return (this = this.getCameraCharacteristics(string2)) != null && (Integer)this.get(CameraCharacteristics.LENS_FACING) == 0;
    }

    @Override
    public boolean isBackFacing(String string2) {
        return (this = this.getCameraCharacteristics(string2)) != null && (Integer)this.get(CameraCharacteristics.LENS_FACING) == 1;
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(String string2) {
        return Camera2Enumerator.getSupportedFormats(this.context, string2);
    }

    @Override
    public CameraVideoCapturer createCapturer(String string2, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler) {
        return new Camera2Capturer(this.context, string2, cameraEventsHandler);
    }
}

