/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.os.SystemClock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.webrtc.Camera1Enumerator;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraSession;
import org.webrtc.Histogram;
import org.webrtc.Logging;
import org.webrtc.NV21Buffer;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;

public class Camera1Session
implements CameraSession {
    public static final String TAG = "Camera1Session";
    public static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    public static final Histogram camera1StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StartTimeMs", 1, 10000, 50);
    public static final Histogram camera1StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StopTimeMs", 1, 10000, 50);
    public static final Histogram camera1ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera1.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    public final Handler cameraThreadHandler;
    public final CameraSession.Events events;
    public final boolean captureToTexture;
    public final Context applicationContext;
    public final SurfaceTextureHelper surfaceTextureHelper;
    public final int cameraId;
    public final Camera camera;
    public final Camera.CameraInfo info;
    public final CameraEnumerationAndroid.CaptureFormat captureFormat;
    public final long constructionTimeNs;
    public SessionState state;
    public boolean firstFrameReported;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void create(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, boolean bl, Context context, SurfaceTextureHelper surfaceTextureHelper, int n3, int n4, int n5, int n6) {
        void var1_5;
        Camera camera;
        block12: {
            CameraEnumerationAndroid.CaptureFormat captureFormat;
            Camera.Parameters parameters;
            Camera.CameraInfo cameraInfo;
            int n7;
            Camera camera2;
            Camera camera3;
            boolean bl2;
            long l3;
            block11: {
                l3 = System.nanoTime();
                Logging.d(TAG, "Open camera " + n3);
                events.onCameraOpening();
                try {
                    camera = Camera.open((int)n3);
                    if (camera != null) break block11;
                }
                catch (RuntimeException runtimeException) {
                    createSessionCallback.onFailure(CameraSession.FailureType.ERROR, runtimeException.getMessage());
                    return;
                }
                createSessionCallback.onFailure(CameraSession.FailureType.ERROR, "android.hardware.Camera.open returned null for camera id = " + n3);
                return;
            }
            try {
                bl2 = bl;
                Camera camera4 = camera;
                camera3 = camera4;
                camera2 = camera4;
                n7 = n3;
                camera.setPreviewTexture(surfaceTextureHelper.getSurfaceTexture());
            }
            catch (RuntimeException runtimeException) {
                break block12;
            }
            catch (IOException iOException) {
                // empty catch block
                break block12;
            }
            Camera.CameraInfo cameraInfo2 = cameraInfo;
            Camera.getCameraInfo((int)n7, (Camera.CameraInfo)new Camera.CameraInfo());
            try {
                parameters = camera3.getParameters();
            }
            catch (RuntimeException runtimeException) {
                camera.release();
                createSessionCallback.onFailure(CameraSession.FailureType.ERROR, runtimeException.getMessage());
                return;
            }
            {
                captureFormat = Camera1Session.findClosestCaptureFormat(parameters, n4, n5, n6);
            }
            {
                Camera1Session.updateCameraParameters(camera2, parameters, captureFormat, Camera1Session.findClosestPictureSize(parameters, n4, n5), bl);
            }
            if (!bl2) {
                n4 = captureFormat.frameSize();
                for (n5 = 0; n5 < 3; ++n5) {
                    camera.addCallbackBuffer(ByteBuffer.allocateDirect(n4).array());
                }
            }
            camera.setDisplayOrientation(0);
            createSessionCallback.onDone(new Camera1Session(events, bl, context, surfaceTextureHelper, n3, camera, cameraInfo2, captureFormat, l3));
            return;
        }
        camera.release();
        createSessionCallback.onFailure(CameraSession.FailureType.ERROR, var1_5.getMessage());
    }

    public static void updateCameraParameters(Camera camera, Camera.Parameters parameters, CameraEnumerationAndroid.CaptureFormat captureFormat, Size size, boolean bl) {
        List list = parameters.getSupportedFocusModes();
        CameraEnumerationAndroid.CaptureFormat.FramerateRange framerateRange = captureFormat.framerate;
        parameters.setPreviewFpsRange(framerateRange.min, framerateRange.max);
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        parameters.setPictureSize(size.width, size.height);
        if (!bl) {
            parameters.setPreviewFormat(17);
        }
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (list.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
    }

    public static CameraEnumerationAndroid.CaptureFormat findClosestCaptureFormat(Camera.Parameters object, int n3, int n4, int n5) {
        Camera.Parameters parameters = object;
        object = Camera1Enumerator.convertFramerates(parameters.getSupportedPreviewFpsRange());
        Logging.d(TAG, "Available fps ranges: " + object);
        object = CameraEnumerationAndroid.getClosestSupportedFramerateRange(object, n5);
        Size size = CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPreviewSizes()), n3, n4);
        CameraEnumerationAndroid.reportCameraResolution(camera1ResolutionHistogram, size);
        return new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, (CameraEnumerationAndroid.CaptureFormat.FramerateRange)object);
    }

    public static Size findClosestPictureSize(Camera.Parameters parameters, int n3, int n4) {
        return CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), n3, n4);
    }

    public Camera1Session(CameraSession.Events events, boolean bl, Context context, SurfaceTextureHelper surfaceTextureHelper, int n3, Camera camera, Camera.CameraInfo cameraInfo, CameraEnumerationAndroid.CaptureFormat captureFormat, long l3) {
        Logging.d(TAG, "Create new camera1 session on camera " + n3);
        this.cameraThreadHandler = new Handler();
        this.events = events;
        this.captureToTexture = bl;
        this.applicationContext = context;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = n3;
        this.camera = camera;
        this.info = cameraInfo;
        this.captureFormat = captureFormat;
        this.constructionTimeNs = l3;
        surfaceTextureHelper.setTextureSize(captureFormat.width, captureFormat.height);
        this.startCapturing();
    }

    private void startCapturing() {
        Camera1Session camera1Session = this;
        Logging.d(TAG, "Start capturing");
        camera1Session.checkIsOnCameraThread();
        camera1Session.state = SessionState.RUNNING;
        camera1Session.camera.setErrorCallback(new Camera.ErrorCallback(){

            public void onError(int n3, Camera object) {
                object = n3 == 100 ? "Camera server died!" : "Camera error: " + n3;
                Logging.e(Camera1Session.TAG, (String)object);
                Camera1Session.this.stopInternal();
                if (n3 == 2) {
                    Camera1Session.this.events.onCameraDisconnected(Camera1Session.this);
                } else {
                    Camera1Session.this.events.onCameraError(Camera1Session.this, (String)object);
                }
            }
        });
        if (camera1Session.captureToTexture) {
            this.listenForTextureFrames();
        } else {
            this.listenForBytebufferFrames();
        }
        try {
            this.camera.startPreview();
        }
        catch (RuntimeException runtimeException) {
            Camera1Session camera1Session2 = this;
            camera1Session2.stopInternal();
            camera1Session2.events.onCameraError(this, runtimeException.getMessage());
        }
    }

    private void stopInternal() {
        Camera1Session camera1Session = this;
        Logging.d(TAG, "Stop internal");
        camera1Session.checkIsOnCameraThread();
        SessionState sessionState = SessionState.STOPPED;
        if (camera1Session.state == sessionState) {
            Logging.d(TAG, "Camera is already stopped");
            return;
        }
        Camera1Session camera1Session2 = this;
        camera1Session2.state = sessionState;
        camera1Session2.surfaceTextureHelper.stopListening();
        camera1Session2.camera.stopPreview();
        camera1Session2.camera.release();
        camera1Session2.events.onCameraClosed(this);
        Logging.d(TAG, "Stop done");
    }

    private void listenForTextureFrames() {
        this.surfaceTextureHelper.startListening(videoFrame -> {
            Camera1Session camera1Session = this;
            camera1Session.checkIsOnCameraThread();
            if (camera1Session.state != SessionState.RUNNING) {
                Logging.d(TAG, "Texture frame captured but camera is no longer running.");
                return;
            }
            if (!this.firstFrameReported) {
                camera1StartTimeMsHistogram.addSample((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.constructionTimeNs));
                this.firstFrameReported = true;
            }
            TextureBufferImpl textureBufferImpl = (TextureBufferImpl)videoFrame.getBuffer();
            boolean bl = this.info.facing == 1;
            VideoFrame videoFrame2 = new VideoFrame(CameraSession.createTextureBufferWithModifiedTransformMatrix(textureBufferImpl, bl, 0), this.getFrameOrientation(), videoFrame.getTimestampNs());
            this.events.onFrameCaptured(this, videoFrame2);
            videoFrame2.release();
        });
    }

    private void listenForBytebufferFrames() {
        this.camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            private /* synthetic */ void b(byte[] byArray) {
                Camera1Session.this.cameraThreadHandler.post(() -> {
                    if (Camera1Session.this.state == SessionState.RUNNING) {
                        Camera1Session.this.camera.addCallbackBuffer(byArray);
                    }
                });
            }

            public void onPreviewFrame(byte[] object, Camera object2) {
                VideoFrame videoFrame;
                NV21Buffer nV21Buffer;
                2 v02 = this;
                v02.Camera1Session.this.checkIsOnCameraThread();
                if (object2 != v02.Camera1Session.this.camera) {
                    Logging.e(Camera1Session.TAG, "Callback from a different camera. This should never happen.");
                    return;
                }
                if (Camera1Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera1Session.TAG, "Bytebuffer frame captured but camera is no longer running.");
                    return;
                }
                long l3 = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                if (!Camera1Session.this.firstFrameReported) {
                    camera1StartTimeMsHistogram.addSample((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera1Session.this.constructionTimeNs));
                    Camera1Session.access$502(Camera1Session.this, true);
                }
                object2 = nV21Buffer;
                nV21Buffer = new NV21Buffer((byte[])object, ((Camera1Session)Camera1Session.this).captureFormat.width, ((Camera1Session)Camera1Session.this).captureFormat.height, () -> this.b((byte[])object));
                object = videoFrame;
                object((VideoFrame.Buffer)object2, Camera1Session.this.getFrameOrientation(), l3);
                Camera1Session.this.events.onFrameCaptured(Camera1Session.this, (VideoFrame)object);
                videoFrame.release();
            }
        });
    }

    private int getFrameOrientation() {
        Camera1Session camera1Session = this;
        int n3 = CameraSession.getDeviceOrientation(camera1Session.applicationContext);
        if (camera1Session.info.facing == 0) {
            n3 = 360 - n3;
        }
        return (this.info.orientation + n3) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() == this.cameraThreadHandler.getLooper().getThread()) {
            return;
        }
        throw new IllegalStateException("Wrong thread");
    }

    public static /* synthetic */ boolean access$502(Camera1Session camera1Session, boolean bl) {
        camera1Session.firstFrameReported = bl;
        return bl;
    }

    @Override
    public void stop() {
        Camera1Session camera1Session = this;
        Logging.d(TAG, a.a("Stop camera1 session on camera ").append(this.cameraId).toString());
        camera1Session.checkIsOnCameraThread();
        if (camera1Session.state != SessionState.STOPPED) {
            long l3 = System.nanoTime();
            this.stopInternal();
            camera1StopTimeMsHistogram.addSample((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l3));
        }
    }

    public static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

