/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.hardware.Camera;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.webrtc.Camera1Capturer;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.Logging;
import org.webrtc.Size;

public class Camera1Enumerator
implements CameraEnumerator {
    public static final String TAG = "Camera1Enumerator";
    public static List<List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats;
    public final boolean captureToTexture;

    public Camera1Enumerator() {
        this(true);
    }

    public Camera1Enumerator(boolean bl) {
        this.captureToTexture = bl;
    }

    @Nullable
    public static Camera.CameraInfo getCameraInfo(int n3) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)n3, (Camera.CameraInfo)cameraInfo);
            return cameraInfo;
        }
        catch (Exception exception) {
            Logging.e(TAG, "getCameraInfo failed on index " + n3, exception);
            return null;
        }
    }

    public static synchronized List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int n3) {
        if (cachedSupportedFormats == null) {
            cachedSupportedFormats = new ArrayList<List<CameraEnumerationAndroid.CaptureFormat>>();
            for (int i3 = 0; i3 < Camera.getNumberOfCameras(); ++i3) {
                cachedSupportedFormats.add(Camera1Enumerator.enumerateFormats(i3));
            }
        }
        return cachedSupportedFormats.get(n3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<CameraEnumerationAndroid.CaptureFormat> enumerateFormats(int n3) {
        Throwable throwable222222;
        Object object;
        long l3;
        block13: {
            List list322;
            ArrayList arrayList;
            Logging.d(TAG, "Get supported formats for camera index " + n3 + ".");
            l3 = SystemClock.elapsedRealtime();
            object = null;
            Logging.d(TAG, "Opening camera with index " + n3);
            object = Camera.open((int)n3);
            Object object2 = object.getParameters();
            object.release();
            object = arrayList;
            arrayList = new ArrayList();
            int n4 = 0;
            int n5 = 0;
            try {
                list322 = object2.getSupportedPreviewFpsRange();
                if (list322 != null) {
                    List list2 = list322;
                    int[] nArray = (int[])list2.get(list2.size() - 1);
                    n4 = nArray[0];
                    n5 = nArray[1];
                }
                object2 = object2.getSupportedPreviewSizes().iterator();
            }
            catch (Exception exception) {
                Logging.e(TAG, "getSupportedFormats() failed on camera index " + n3, exception);
                break block13;
            }
            while (object2.hasNext()) {
                list322 = (Camera.Size)object2.next();
                object.add(new CameraEnumerationAndroid.CaptureFormat(((Camera.Size)list322).width, ((Camera.Size)list322).height, n4, n5));
            }
        }
        long l4 = SystemClock.elapsedRealtime();
        Logging.d(TAG, "Get supported formats for camera index " + n3 + " done. Time spent: " + (l4 - l3) + " ms.");
        return object;
        {
            ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList2;
            block14: {
                ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList2;
                catch (Throwable throwable222222) {
                }
                catch (RuntimeException runtimeException) {}
                {
                    Logging.e(TAG, "Open camera failed on camera index " + n3, runtimeException);
                }
                arrayList2 = arrayList2;
                {
                    arrayList2 = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
                    if (object == null) break block14;
                }
                object.release();
            }
            return arrayList2;
        }
        if (object != null) {
            object.release();
        }
        throw throwable222222;
    }

    public static List<Size> convertSizes(List<Camera.Size> arrayList) {
        ArrayList<Size> arrayList2;
        ArrayList<Size> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<Size>();
        for (Camera.Size size : arrayList3) {
            arrayList.add(new Size(size.width, size.height));
        }
        return arrayList;
    }

    public static List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> convertFramerates(List<int[]> arrayList) {
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList2;
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        for (int[] nArray : arrayList3) {
            arrayList.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange(nArray[0], nArray[1]));
        }
        return arrayList;
    }

    public static int getCameraIndex(String string2) {
        Logging.d(TAG, "getCameraIndex: " + string2);
        for (int i3 = 0; i3 < Camera.getNumberOfCameras(); ++i3) {
            if (!string2.equals(Camera1Enumerator.getDeviceName(i3))) continue;
            return i3;
        }
        throw new IllegalArgumentException("No such camera: " + string2);
    }

    @Nullable
    public static String getDeviceName(int n3) {
        Camera.CameraInfo cameraInfo = Camera1Enumerator.getCameraInfo(n3);
        if (cameraInfo == null) {
            return null;
        }
        String string2 = cameraInfo.facing == 1 ? "front" : "back";
        return "Camera " + n3 + ", Facing " + string2 + ", Orientation " + cameraInfo.orientation;
    }

    @Override
    public String[] getDeviceNames() {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (int i3 = 0; i3 < Camera.getNumberOfCameras(); ++i3) {
            String string2 = Camera1Enumerator.getDeviceName(i3);
            if (string2 != null) {
                arrayList2.add(string2);
                Logging.d(TAG, "Index: " + i3 + ". " + string2);
                continue;
            }
            Logging.e(TAG, "Index: " + i3 + ". Failed to query camera name.");
        }
        ArrayList arrayList3 = arrayList2;
        return arrayList3.toArray(new String[arrayList3.size()]);
    }

    @Override
    public boolean isFrontFacing(String string2) {
        Camera1Enumerator camera1Enumerator = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(string2));
        return camera1Enumerator != null && ((Camera.CameraInfo)camera1Enumerator).facing == 1;
    }

    @Override
    public boolean isBackFacing(String string2) {
        Camera1Enumerator camera1Enumerator = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(string2));
        return camera1Enumerator != null && ((Camera.CameraInfo)camera1Enumerator).facing == 0;
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(String string2) {
        return Camera1Enumerator.getSupportedFormats(Camera1Enumerator.getCameraIndex(string2));
    }

    @Override
    public CameraVideoCapturer createCapturer(String string2, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler) {
        return new Camera1Capturer(string2, cameraEventsHandler, this.captureToTexture);
    }
}

