/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.webrtc.EglBase;
import org.webrtc.EncodedImage;
import org.webrtc.JavaI420Buffer;
import org.webrtc.Logging;
import org.webrtc.MediaCodecUtils;
import org.webrtc.MediaCodecWrapper;
import org.webrtc.MediaCodecWrapperFactory;
import org.webrtc.NV12Buffer;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.YuvHelper;

public class AndroidVideoDecoder
implements VideoDecoder,
VideoSink {
    public static final String TAG = "AndroidVideoDecoder";
    public static final String MEDIA_FORMAT_KEY_STRIDE = "stride";
    public static final String MEDIA_FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    public static final String MEDIA_FORMAT_KEY_CROP_LEFT = "crop-left";
    public static final String MEDIA_FORMAT_KEY_CROP_RIGHT = "crop-right";
    public static final String MEDIA_FORMAT_KEY_CROP_TOP = "crop-top";
    public static final String MEDIA_FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    public static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    public static final int DEQUEUE_INPUT_TIMEOUT_US = 500000;
    public static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    public final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    public final String codecName;
    public final VideoCodecType codecType;
    public final BlockingDeque<FrameInfo> frameInfos;
    public int colorFormat;
    @Nullable
    public Thread outputThread;
    public ThreadUtils.ThreadChecker outputThreadChecker;
    public ThreadUtils.ThreadChecker decoderThreadChecker;
    public volatile boolean running;
    @Nullable
    public volatile Exception shutdownException;
    public final Object dimensionLock = new Object();
    public int width;
    public int height;
    public int stride;
    public int sliceHeight;
    public boolean hasDecodedFirstFrame;
    public boolean keyFrameRequired;
    @Nullable
    public final EglBase.Context sharedContext;
    @Nullable
    public SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    public Surface surface;
    public final Object renderedTextureMetadataLock = new Object();
    @Nullable
    public DecodedTextureMetadata renderedTextureMetadata;
    @Nullable
    public VideoDecoder.Callback callback;
    @Nullable
    public MediaCodecWrapper codec;

    public AndroidVideoDecoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String string2, VideoCodecType videoCodecType, int n3, @Nullable EglBase.Context context) {
        if (this.isSupportedColorFormat(n3)) {
            AndroidVideoDecoder androidVideoDecoder = this;
            Logging.d(TAG, "ctor name: " + string2 + " type: " + (Object)((Object)videoCodecType) + " color format: " + n3 + " context: " + context);
            this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
            this.codecName = string2;
            this.codecType = videoCodecType;
            this.colorFormat = n3;
            androidVideoDecoder.sharedContext = context;
            androidVideoDecoder.frameInfos = new LinkedBlockingDeque<FrameInfo>();
            return;
        }
        throw new IllegalArgumentException("Unsupported color format: " + n3);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VideoCodecStatus initDecodeInternal(int n3, int n4) {
        block7: {
            AndroidVideoDecoder androidVideoDecoder = this;
            androidVideoDecoder.decoderThreadChecker.checkIsOnValidThread();
            Logging.d(TAG, "initDecodeInternal name: " + this.codecName + " type: " + (Object)((Object)this.codecType) + " width: " + n3 + " height: " + n4);
            if (androidVideoDecoder.outputThread != null) {
                Logging.e(TAG, "initDecodeInternal called while the codec is already running");
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            AndroidVideoDecoder androidVideoDecoder2 = this;
            this.width = n3;
            this.height = n4;
            this.stride = n3;
            androidVideoDecoder2.sliceHeight = n4;
            androidVideoDecoder2.hasDecodedFirstFrame = false;
            androidVideoDecoder2.keyFrameRequired = true;
            androidVideoDecoder2.codec = androidVideoDecoder2.mediaCodecWrapperFactory.createByCodecName(this.codecName);
            try {
                MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)androidVideoDecoder2.codecType.mimeType(), (int)n3, (int)n4);
                if (androidVideoDecoder2.sharedContext == null) {
                    mediaFormat.setInteger("color-format", this.colorFormat);
                }
                AndroidVideoDecoder androidVideoDecoder3 = this;
                androidVideoDecoder3.codec.configure(mediaFormat, this.surface, null, 0);
                androidVideoDecoder3.codec.start();
                androidVideoDecoder3.running = true;
                androidVideoDecoder3.outputThread = androidVideoDecoder3.createOutputThread();
                androidVideoDecoder3.outputThread.start();
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "initDecode failed", illegalStateException);
                this.release();
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            Logging.d(TAG, "initDecodeInternal done");
            return VideoCodecStatus.OK;
            catch (IllegalArgumentException illegalArgumentException) {
                break block7;
            }
            catch (IOException iOException) {}
        }
        Logging.e(TAG, a.a("Cannot create media decoder ").append(this.codecName).toString());
        return VideoCodecStatus.FALLBACK_SOFTWARE;
    }

    private VideoCodecStatus releaseInternal() {
        block7: {
            block6: {
                if (!this.running) {
                    Logging.d(TAG, "release: Decoder is not running.");
                    return VideoCodecStatus.OK;
                }
                try {
                    this.running = false;
                    if (ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) break block6;
                }
                catch (Throwable throwable) {
                    AndroidVideoDecoder androidVideoDecoder = this;
                    androidVideoDecoder.codec = null;
                    androidVideoDecoder.outputThread = null;
                    throw throwable;
                }
                Logging.e(TAG, "Media decoder release timeout", new RuntimeException());
                AndroidVideoDecoder androidVideoDecoder = this;
                androidVideoDecoder.codec = null;
                androidVideoDecoder.outputThread = null;
                return VideoCodecStatus.TIMEOUT;
            }
            if (this.shutdownException == null) break block7;
            Logging.e(TAG, "Media decoder release error", new RuntimeException(this.shutdownException));
            this.shutdownException = null;
            AndroidVideoDecoder androidVideoDecoder = this;
            androidVideoDecoder.codec = null;
            androidVideoDecoder.outputThread = null;
            return VideoCodecStatus.ERROR;
        }
        AndroidVideoDecoder androidVideoDecoder = this;
        androidVideoDecoder.codec = null;
        androidVideoDecoder.outputThread = null;
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus reinitDecode(int n3, int n4) {
        AndroidVideoDecoder androidVideoDecoder = this;
        androidVideoDecoder.decoderThreadChecker.checkIsOnValidThread();
        VideoCodecStatus videoCodecStatus = androidVideoDecoder.releaseInternal();
        if (videoCodecStatus != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        return this.initDecodeInternal(n3, n4);
    }

    private Thread createOutputThread() {
        return new Thread("AndroidVideoDecoder.outputThread"){

            @Override
            public void run() {
                AndroidVideoDecoder.access$002(AndroidVideoDecoder.this, new ThreadUtils.ThreadChecker());
                while (AndroidVideoDecoder.this.running) {
                    AndroidVideoDecoder.this.deliverDecodedFrame();
                }
                AndroidVideoDecoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deliverTextureFrame(int n3, MediaCodec.BufferInfo bufferInfo, int n4, Integer n5) {
        Object object;
        int n6;
        int n7;
        AndroidVideoDecoder androidVideoDecoder = this;
        Object object2 = androidVideoDecoder.dimensionLock;
        AndroidVideoDecoder androidVideoDecoder2 = this;
        synchronized (object2) {
            n7 = androidVideoDecoder2.width;
            n6 = androidVideoDecoder2.height;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var5_5
            object = androidVideoDecoder.renderedTextureMetadataLock;
        }
        synchronized (object) {
            if (androidVideoDecoder.renderedTextureMetadata != null) {
                this.codec.releaseOutputBuffer(n3, false);
                return;
            }
            AndroidVideoDecoder androidVideoDecoder3 = this;
            androidVideoDecoder3.surfaceTextureHelper.setTextureSize(n7, n6);
            androidVideoDecoder3.surfaceTextureHelper.setFrameRotation(n4);
            androidVideoDecoder3.renderedTextureMetadata = new DecodedTextureMetadata(bufferInfo.presentationTimeUs, n5);
            androidVideoDecoder3.codec.releaseOutputBuffer(n3, true);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deliverByteFrame(int n3, MediaCodec.BufferInfo bufferInfo, int n4, Integer n5) {
        VideoFrame videoFrame;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        Object object = this.dimensionLock;
        AndroidVideoDecoder androidVideoDecoder = this;
        synchronized (object) {
            n10 = androidVideoDecoder.width;
            n9 = androidVideoDecoder.height;
            n8 = androidVideoDecoder.stride;
            n7 = androidVideoDecoder.sliceHeight;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var5_7
            n6 = bufferInfo.size;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        if (n6 < n10 * n9 * 3 / 2) {
            Logging.e(TAG, a.a("Insufficient output buffer size: ").append(bufferInfo.size).toString());
            return;
        }
        if (n6 < n8 * n9 * 3 / 2 && n7 == n9 && n8 > n10) {
            n8 = n6 * 2 / (n9 * 3);
        }
        AndroidVideoDecoder androidVideoDecoder2 = this;
        ByteBuffer byteBuffer = androidVideoDecoder2.codec.getOutputBuffers()[n3];
        byteBuffer.position(bufferInfo.offset);
        byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
        Object object2 = byteBuffer.slice();
        object2 = androidVideoDecoder2.colorFormat == 19 ? this.copyI420Buffer((ByteBuffer)object2, n8, n7, n10, n9) : this.copyNV12ToI420Buffer((ByteBuffer)object2, n8, n7, n10, n9);
        this.codec.releaseOutputBuffer(n3, false);
        long l3 = bufferInfo.presentationTimeUs * 1000L;
        VideoFrame videoFrame2 = videoFrame;
        videoFrame2((VideoFrame.Buffer)object2, n4, l3);
        this.callback.onDecodedFrame(videoFrame2, n5, null);
        videoFrame.release();
    }

    private VideoFrame.Buffer copyNV12ToI420Buffer(ByteBuffer byteBuffer, int n3, int n4, int n5, int n6) {
        return new NV12Buffer(n5, n6, n3, n4, byteBuffer, null).toI420();
    }

    private VideoFrame.Buffer copyI420Buffer(ByteBuffer byteBuffer, int n3, int n4, int n5, int n6) {
        if (n3 % 2 == 0) {
            int n7 = (n5 + 1) / 2;
            int n8 = n4 % 2;
            int n9 = n8 == 0 ? (n6 + 1) / 2 : n6 / 2;
            ByteBuffer byteBuffer2 = byteBuffer;
            int n10 = n3 / 2;
            int n11 = n3 * n6 + 0;
            int n12 = n3 * n4 + 0;
            int n13 = n10 * n9;
            ByteBuffer byteBuffer3 = byteBuffer;
            int n14 = n11;
            n4 = n10 * n4 / 2 + n12;
            n11 = n4 + n13;
            VideoFrame.I420Buffer i420Buffer = this.allocateI420Buffer(n5, n6);
            byteBuffer3.limit(n14);
            byteBuffer3.position(0);
            this.copyPlane(byteBuffer3.slice(), n3, i420Buffer.getDataY(), i420Buffer.getStrideY(), n5, n6);
            byteBuffer.limit(n12 + n13);
            byteBuffer2.position(n12);
            this.copyPlane(byteBuffer2.slice(), n10, i420Buffer.getDataU(), i420Buffer.getStrideU(), n7, n9);
            if (n8 == 1) {
                byteBuffer.position((n9 - 1) * n10 + n12);
                ByteBuffer byteBuffer4 = i420Buffer.getDataU();
                byteBuffer4.position(i420Buffer.getStrideU() * n9);
                byteBuffer4.put(byteBuffer);
            }
            ByteBuffer byteBuffer5 = byteBuffer;
            byteBuffer.limit(n11);
            byteBuffer5.position(n4);
            this.copyPlane(byteBuffer5.slice(), n10, i420Buffer.getDataV(), i420Buffer.getStrideV(), n7, n9);
            if (n8 == 1) {
                byteBuffer.position((n9 - 1) * n10 + n4);
                ByteBuffer byteBuffer6 = i420Buffer.getDataV();
                byteBuffer6.position(i420Buffer.getStrideV() * n9);
                byteBuffer6.put(byteBuffer);
            }
            return i420Buffer;
        }
        throw new AssertionError((Object)("Stride is not divisible by two: " + n3));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reformat(MediaFormat mediaFormat) {
        block15: {
            int n3;
            int n4;
            this.outputThreadChecker.checkIsOnValidThread();
            Logging.d(TAG, "Decoder format changed: " + mediaFormat.toString());
            if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_LEFT) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_RIGHT) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_BOTTOM) && mediaFormat.containsKey(MEDIA_FORMAT_KEY_CROP_TOP)) {
                MediaFormat mediaFormat2 = mediaFormat;
                n4 = mediaFormat2.getInteger(MEDIA_FORMAT_KEY_CROP_RIGHT) + 1 - mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_LEFT);
                n3 = mediaFormat2.getInteger(MEDIA_FORMAT_KEY_CROP_BOTTOM) + 1 - mediaFormat.getInteger(MEDIA_FORMAT_KEY_CROP_TOP);
            } else {
                MediaFormat mediaFormat3 = mediaFormat;
                n4 = mediaFormat3.getInteger("width");
                n3 = mediaFormat3.getInteger("height");
            }
            AndroidVideoDecoder androidVideoDecoder = this;
            Object object = androidVideoDecoder.dimensionLock;
            synchronized (object) {
                if (androidVideoDecoder.hasDecodedFirstFrame && (this.width != n4 || this.height != n3)) {
                    this.stopOnOutputThread(new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n4 + "*" + n3));
                    return;
                }
                this.width = n4;
                this.height = n3;
                // MONITOREXIT @DISABLED, blocks:[0, 4] lbl21 : MonitorExitStatement: MONITOREXIT : var4_7
                if (this.surfaceTextureHelper != null) break block15;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
            if (mediaFormat.containsKey("color-format")) {
                AndroidVideoDecoder androidVideoDecoder2 = this;
                androidVideoDecoder2.colorFormat = mediaFormat.getInteger("color-format");
                Logging.d(TAG, a.a("Color: 0x").append(Integer.toHexString(this.colorFormat)).toString());
                if (!androidVideoDecoder2.isSupportedColorFormat(androidVideoDecoder2.colorFormat)) {
                    this.stopOnOutputThread(new IllegalStateException(a.a("Unsupported color format: ").append(this.colorFormat).toString()));
                    return;
                }
            }
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_STRIDE)) {
                this.stride = mediaFormat.getInteger(MEDIA_FORMAT_KEY_STRIDE);
            }
            if (mediaFormat.containsKey(MEDIA_FORMAT_KEY_SLICE_HEIGHT)) {
                this.sliceHeight = mediaFormat.getInteger(MEDIA_FORMAT_KEY_SLICE_HEIGHT);
            }
            AndroidVideoDecoder androidVideoDecoder = this;
            Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
            androidVideoDecoder.stride = Math.max(androidVideoDecoder.width, this.stride);
            androidVideoDecoder.sliceHeight = Math.max(androidVideoDecoder.height, this.sliceHeight);
            return;
        }
    }

    private void releaseCodecOnOutputThread() {
        AndroidVideoDecoder androidVideoDecoder = this;
        androidVideoDecoder.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        try {
            androidVideoDecoder.codec.stop();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media decoder stop failed", exception);
        }
        try {
            this.codec.release();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media decoder release failed", exception);
            this.shutdownException = exception;
        }
        Logging.d(TAG, "Release on output thread done");
    }

    private void stopOnOutputThread(Exception exception) {
        this.outputThreadChecker.checkIsOnValidThread();
        this.running = false;
        this.shutdownException = exception;
    }

    private boolean isSupportedColorFormat(int n3) {
        Object object = MediaCodecUtils.DECODER_COLOR_FORMATS;
        int n4 = MediaCodecUtils.DECODER_COLOR_FORMATS.length;
        for (int i3 = 0; i3 < n4; ++i3) {
            if (object[i3] != n3) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ ThreadUtils.ThreadChecker access$002(AndroidVideoDecoder androidVideoDecoder, ThreadUtils.ThreadChecker threadChecker) {
        androidVideoDecoder.outputThreadChecker = threadChecker;
        return threadChecker;
    }

    @Override
    public VideoCodecStatus initDecode(VideoDecoder.Settings settings, VideoDecoder.Callback callback) {
        this.decoderThreadChecker = new ThreadUtils.ThreadChecker();
        this.callback = callback;
        if (this.sharedContext != null) {
            AndroidVideoDecoder androidVideoDecoder = this;
            androidVideoDecoder.surfaceTextureHelper = androidVideoDecoder.createSurfaceTextureHelper();
            androidVideoDecoder.surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
            androidVideoDecoder.surfaceTextureHelper.startListening(this);
        }
        return this.initDecodeInternal(settings.width, settings.height);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public VideoCodecStatus decode(EncodedImage object, VideoDecoder.DecodeInfo object2) {
        AndroidVideoDecoder androidVideoDecoder = this;
        androidVideoDecoder.decoderThreadChecker.checkIsOnValidThread();
        if (androidVideoDecoder.codec != null && this.callback != null) {
            ByteBuffer byteBuffer;
            int n3;
            int n4;
            block19: {
                block17: {
                    block18: {
                        object2 = ((EncodedImage)object).buffer;
                        if (object2 == null) {
                            Logging.e(TAG, "decode() - no input data");
                            return VideoCodecStatus.ERR_PARAMETER;
                        }
                        n4 = ((Buffer)object2).remaining();
                        if (n4 == 0) {
                            Logging.e(TAG, "decode() - input buffer empty");
                            return VideoCodecStatus.ERR_PARAMETER;
                        }
                        Object object3 = this.dimensionLock;
                        AndroidVideoDecoder androidVideoDecoder2 = this;
                        synchronized (object3) {
                            VideoCodecStatus videoCodecStatus;
                            int n5 = androidVideoDecoder2.width;
                            int n6 = androidVideoDecoder2.height;
                            // MONITOREXIT @DISABLED, blocks:[16, 0, 5] lbl18 : MonitorExitStatement: MONITOREXIT : var3_8
                            int n7 = ((EncodedImage)object).encodedWidth;
                            int n8 = ((EncodedImage)object).encodedHeight;
                            if (n7 * n8 > 0 && (n7 != n5 || n8 != n6) && (videoCodecStatus = this.reinitDecode(((EncodedImage)object).encodedWidth, ((EncodedImage)object).encodedHeight)) != VideoCodecStatus.OK) {
                                return videoCodecStatus;
                            }
                            if (!this.keyFrameRequired) break block17;
                            if (((EncodedImage)object).frameType == EncodedImage.FrameType.VideoFrameKey) break block18;
                            {
                                catch (Throwable throwable) {}
                                {
                                    throw throwable;
                                }
                            }
                        }
                        Logging.e(TAG, "decode() - key frame required first");
                        return VideoCodecStatus.NO_OUTPUT;
                    }
                    if (!((EncodedImage)object).completeFrame) {
                        Logging.e(TAG, "decode() - complete frame required first");
                        return VideoCodecStatus.NO_OUTPUT;
                    }
                }
                try {
                    n3 = this.codec.dequeueInputBuffer(500000L);
                    if (n3 >= 0) break block19;
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(TAG, "dequeueInputBuffer failed", illegalStateException);
                    return VideoCodecStatus.ERROR;
                }
                Logging.e(TAG, "decode() - no HW buffers available; decoder falling behind");
                return VideoCodecStatus.ERROR;
            }
            try {
                byteBuffer = this.codec.getInputBuffers()[n3];
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "getInputBuffers failed", illegalStateException);
                return VideoCodecStatus.ERROR;
            }
            if (byteBuffer.capacity() < n4) {
                Logging.e(TAG, "decode() - HW buffer too small");
                return VideoCodecStatus.ERROR;
            }
            AndroidVideoDecoder androidVideoDecoder3 = this;
            byteBuffer.put(((EncodedImage)object).buffer);
            androidVideoDecoder3.frameInfos.offer(new FrameInfo(SystemClock.elapsedRealtime(), ((EncodedImage)object).rotation));
            try {
                androidVideoDecoder3.codec.queueInputBuffer(n3, 0, n4, TimeUnit.NANOSECONDS.toMicros(((EncodedImage)object).captureTimeNs), 0);
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "queueInputBuffer failed", illegalStateException);
                this.frameInfos.pollLast();
                return VideoCodecStatus.ERROR;
            }
            if (androidVideoDecoder3.keyFrameRequired) {
                this.keyFrameRequired = false;
            }
            return VideoCodecStatus.OK;
        }
        object = TAG;
        object2 = a.a("decode uninitalized, codec: ");
        boolean bl = this.codec != null;
        Logging.d((String)object, ((StringBuilder)object2).append(bl).append(", callback: ").append(this.callback).toString());
        return VideoCodecStatus.UNINITIALIZED;
    }

    @Override
    public boolean getPrefersLateDecoding() {
        return true;
    }

    @Override
    public String getImplementationName() {
        return this.codecName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public VideoCodecStatus release() {
        AndroidVideoDecoder androidVideoDecoder = this;
        Logging.d(TAG, "release");
        Object object = androidVideoDecoder.releaseInternal();
        if (androidVideoDecoder.surface != null) {
            AndroidVideoDecoder androidVideoDecoder2 = this;
            androidVideoDecoder2.releaseSurface();
            androidVideoDecoder2.surface = null;
            androidVideoDecoder2.surfaceTextureHelper.stopListening();
            androidVideoDecoder2.surfaceTextureHelper.dispose();
            androidVideoDecoder2.surfaceTextureHelper = null;
        }
        VideoCodecStatus videoCodecStatus = object;
        AndroidVideoDecoder androidVideoDecoder3 = this;
        object = androidVideoDecoder3.renderedTextureMetadataLock;
        synchronized (object) {
            this.renderedTextureMetadata = null;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl17 : MonitorExitStatement: MONITOREXIT : object /* !! */ 
            androidVideoDecoder3.callback = null;
        }
        androidVideoDecoder3.frameInfos.clear();
        return videoCodecStatus;
    }

    /*
     * Unable to fully structure code
     */
    public void deliverDecodedFrame() {
        block12: {
            block11: {
                block10: {
                    v0 = this;
                    v0.outputThreadChecker.checkIsOnValidThread();
                    var1_2 = v1;
                    v1 = new MediaCodec.BufferInfo();
                    var2_3 = v0.codec.dequeueOutputBuffer(var1_2, 100000L);
                    if (var2_3 != -2) break block10;
                    v2 = this;
                    v2.reformat(v2.codec.getOutputFormat());
                    return;
                }
                if (var2_3 >= 0) ** GOTO lbl17
                Logging.v("AndroidVideoDecoder", "dequeueOutputBuffer returned " + var2_3);
                return;
lbl17:
                // 1 sources

                var3_4 = this.frameInfos.poll();
                var4_5 = null;
                var5_6 = 0;
                if (var3_4 == null) break block11;
                v3 = var3_4;
                v4 = (int)(SystemClock.elapsedRealtime() - var3_4.decodeStartTimeMs);
                var4_5 = v4;
                var5_6 = v3.rotation;
            }
            this.hasDecodedFirstFrame = true;
            if (this.surfaceTextureHelper == null) ** GOTO lbl35
            try {
                this.deliverTextureFrame(var2_3, var1_2, var5_6, var4_5);
                break block12;
lbl35:
                // 1 sources

                this.deliverByteFrame(var2_3, var1_2, var5_6, var4_5);
            }
            catch (IllegalStateException var0_1) {
                Logging.e("AndroidVideoDecoder", "deliverDecodedFrame failed", var0_1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame videoFrame) {
        AndroidVideoDecoder androidVideoDecoder = n3;
        Object object = androidVideoDecoder.renderedTextureMetadataLock;
        synchronized (object) {
            block7: {
                VideoFrame videoFrame2;
                if (androidVideoDecoder.renderedTextureMetadata == null) break block7;
                AndroidVideoDecoder androidVideoDecoder2 = n3;
                Object object2 = object;
                AndroidVideoDecoder androidVideoDecoder3 = n3;
                AndroidVideoDecoder androidVideoDecoder4 = androidVideoDecoder3;
                AndroidVideoDecoder androidVideoDecoder5 = androidVideoDecoder3;
                long l3 = androidVideoDecoder3.renderedTextureMetadata.presentationTimestampUs * 1000L;
                Integer n3 = androidVideoDecoder5.renderedTextureMetadata.decodeTimeMs;
                androidVideoDecoder4.renderedTextureMetadata = null;
                // ** MonitorExit[v3] (shouldn't be in output)
                object = videoFrame2;
                videoFrame2 = new VideoFrame(videoFrame.getBuffer(), videoFrame.getRotation(), l3);
                androidVideoDecoder2.callback.onDecodedFrame((VideoFrame)object, n3, null);
                return;
            }
            throw new IllegalStateException("Rendered texture metadata was null in onTextureFrameAvailable.");
        }
    }

    public SurfaceTextureHelper createSurfaceTextureHelper() {
        return SurfaceTextureHelper.create("decoder-texture-thread", this.sharedContext);
    }

    public void releaseSurface() {
        this.surface.release();
    }

    public VideoFrame.I420Buffer allocateI420Buffer(int n3, int n4) {
        return JavaI420Buffer.allocate(n3, n4);
    }

    public void copyPlane(ByteBuffer byteBuffer, int n3, ByteBuffer byteBuffer2, int n4, int n5, int n6) {
        YuvHelper.copyPlane(byteBuffer, n3, byteBuffer2, n4, n5, n6);
    }

    public static class DecodedTextureMetadata {
        public final long presentationTimestampUs;
        public final Integer decodeTimeMs;

        public DecodedTextureMetadata(long l3, Integer n3) {
            this.presentationTimestampUs = l3;
            this.decodeTimeMs = n3;
        }
    }

    public static class FrameInfo {
        public final long decodeStartTimeMs;
        public final int rotation;

        public FrameInfo(long l3, int n3) {
            this.decodeStartTimeMs = l3;
            this.rotation = n3;
        }
    }
}

