package com.jimi.jimitalk.tools.recorder;


import android.annotation.SuppressLint;
import android.os.Environment;
import android.util.Log;

import com.jimi.jimitalk.tools.recorder.PCM2MP3Converter;

import org.webrtc.PeerConnectionFactory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @author Administrator
 * @date 2020/4/7
 */
public class RTCAudioRecordThread extends Thread{
    private AtomicBoolean isQuit = new AtomicBoolean();
    private AtomicBoolean isStarted = new AtomicBoolean();
    private FileOutputStream fileOutputStream;
    private Queue<PCMAudioData> pcmAudioDataList = new ConcurrentLinkedDeque<>();
    private PCMFile pcmFile;
    private boolean isConfigured = false;
    private RTCAudioRecordCallback callback;

    public interface RTCAudioRecordCallback {
        public void onRecordVoiceSuccess(String filePath);
    }

    public RTCAudioRecordThread(RTCAudioRecordCallback callback) {
        isQuit.set(false);
        isStarted.set(false);
        this.callback = callback;
    }

    /**
     * type=0 record both
     * type=1 only record mine
     * type=2 only record opposite
     */
    private PeerConnectionFactory.VoiceRecordCallback voiceRecordCallback = new PeerConnectionFactory.VoiceRecordCallback() {
        @Override
        public void onRecordVoice(int type, byte[] pcm, int sampleRate, int channels) {
            Log.e("RTCAudioRecordThread", "type=" + type + " sampleRate=" + sampleRate + " channels=" + channels);
            if (type == 0 && !isQuit.get()) {
                pcmAudioDataList.add(new PCMAudioData(type, pcm, sampleRate, channels));

                if (!isConfigured) {
                    pcmFile = new PCMFile(null, type, sampleRate, channels);
                    isConfigured = true;
                }
            }
        }
    };

    @Override
    public void run() {
        super.run();
        isStarted.set(true);

        PeerConnectionFactory.SetVoiceRecordCallback(voiceRecordCallback);

        @SuppressLint("SimpleDateFormat") SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        Date curDate = new Date(System.currentTimeMillis());
        String curTime = formatter.format(curDate).replace(" ", "");
        File root = Environment.getExternalStorageDirectory();
        File out = new File(root,curTime + ".pcm");
        try {
            fileOutputStream = new FileOutputStream(out);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }

        while (!isQuit.get()) {
            if (!pcmAudioDataList.isEmpty()) {
                PCMAudioData pcmAudioData = pcmAudioDataList.poll();

                try {
                    if (pcmAudioData != null) {
                        fileOutputStream.write(pcmAudioData.getPcm());
                    }else{
                        //没及时产生数据，那么先休眠5毫秒
                        sleep(5);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        try {
            fileOutputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

        PeerConnectionFactory.SetVoiceRecordCallback(null);

        pcmFile.setFile(out);

        PCM2MP3Converter pcm2MP3Converter = new PCM2MP3Converter(pcmFile.getSampleRate(), pcmFile.getChannels(), 0, 320, 0);
        String galleryPath = Environment.getExternalStorageDirectory()
                + File.separator + Environment.DIRECTORY_DCIM
                + File.separator + "Guard Talk" + File.separator;

        File galleryDir = new File(galleryPath);
        if (!galleryDir.exists()) {
            galleryDir.mkdir();
        }

        String dest = galleryPath + curTime + ".mp3";

        pcm2MP3Converter.convert(out.getAbsolutePath(), dest);

        callback.onRecordVoiceSuccess(dest);

        if (out.exists()) {
            out.delete();
        }
    }

    public boolean isStarted() {
        return isStarted.get();
    }

    public void exit() {
        isQuit.set(true);
    }

    private static class PCMFile {
        private File file;
        private int type;
        private int sampleRate;
        private int channels;

        PCMFile(File file, int type, int sampleRate, int channels) {
            this.file = file;
            this.type = type;
            this.sampleRate = sampleRate;
            this.channels = channels;
        }

        public File getFile() {
            return file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getSampleRate() {
            return sampleRate;
        }

        public void setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
        }

        public int getChannels() {
            return channels;
        }

        public void setChannels(int channels) {
            this.channels = channels;
        }
    }

    public static class PCMAudioData {
        private int type;
        private byte[] pcm;
        private int sampleRate;
        private int channels;

        public PCMAudioData(int type, byte[] pcm, int sampleRate, int channels) {
            this.type = type;
            this.pcm = pcm;
            this.sampleRate = sampleRate;
            this.channels = channels;
        }

        public byte[] getPcm() {
            return pcm;
        }

        public int getType() {
            return type;
        }

        public int getSampleRate() {
            return sampleRate;
        }

        public int getChannels() {
            return channels;
        }
    }
}
