package com.jimi.jimitalk.tools;

import android.media.MediaPlayer;
import android.os.AsyncTask;

import java.io.File;
import java.io.IOException;
import java.util.UUID;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/**
 * @author Administrator
 * @date 2020/5/12
 */
public class UploadFileUtils {
    public static String upload_url = "https://dev.yunptt.com/web-api/api/file/upload";

    public static class UploadFile {
        int userId;
        int groupId;
        String fileName;
        int fileType; // 文件类型： 1视频 2音频 3图片 4其他
        File file;
        int duraion = 0;// seconds

        public UploadFile(int userId, int groupId, String fileName, int fileType, File file) {
            this.userId = userId;
            this.groupId = groupId;
            this.fileName = fileName;
            this.fileType = fileType;
            this.file = file;

            if (fileType == 1 || fileType == 2) {
                MediaPlayer mediaPlayer = new MediaPlayer();
                try {
                    mediaPlayer.setDataSource(file.getPath());
                    mediaPlayer.prepare();
                } catch (IOException e) {
                    e.printStackTrace();
                }

                duraion = mediaPlayer.getDuration() / 1000;
            }
        }

        public int getUserId() {
            return userId;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }

        public int getGroupId() {
            return groupId;
        }

        public void setGroupId(int groupId) {
            this.groupId = groupId;
        }

        public String getFileName() {
            return fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public int getFileType() {
            return fileType;
        }

        public void setFileType(int fileType) {
            this.fileType = fileType;
        }

        public File getFile() {
            return file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public int getDuraion() {
            return duraion;
        }

        @Override
        public String toString() {
            return "UploadFile={" +
                    "userId=" + userId +
                    ", groupId=" + groupId +
                    ", fileName='" + fileName + '\'' +
                    ", fileType=" + fileType +
                    ", duraion=" + duraion +
                    '}';
        }
    }

    /**
     * pls put the codes in thread
     * @param uploadFile
     * @return upload result
     */
    public static boolean uploadFile(UploadFile uploadFile) {
        LogUtil.e(uploadFile.toString());

        OkHttpClient client = new OkHttpClient();
        try {
            RequestBody fileBody = RequestBody.create(MediaType.parse("multipart/form-data"), uploadFile.getFile());
            RequestBody body = new MultipartBody.Builder()
                    .setType(MultipartBody.FORM)
                    .addFormDataPart("multipartFile", uploadFile.getFileName(), fileBody)
                    .addFormDataPart("userId", "" + uploadFile.getUserId())
                    .addFormDataPart("groupId", "" + uploadFile.getGroupId())
                    .addFormDataPart("fileKey", uploadFile.getFileName())
                    .addFormDataPart("fileType","" + uploadFile.getFileType())
                    .addFormDataPart("duration", "" + uploadFile.getDuraion())
                    .addFormDataPart("timestamp", "" + System.currentTimeMillis()/1000)
                    .build();

            Request request = new Request.Builder()
                    .header("Authorization", "Client-ID " + UUID.randomUUID())
                    .url(upload_url)
                    .post(body)
                    .build();

            Response response = client.newCall(request).execute();
            LogUtil.d("Upload response = " + response.isSuccessful());
            LogUtil.d("Upload response code = " + response.code());
            LogUtil.d("Upload body = " + response.toString());

            if(response.code() == 200){
                LogUtil.e("Upload success");
                return true;
            } else {
                LogUtil.e("Upload fail code=" + response.code());
                return false;
            }
        } catch (IOException e) {
            LogUtil.e(e.getMessage());
            e.printStackTrace();
        }

        return false;
    }

    public static class UploadFileAsyncTask extends AsyncTask<UploadFile, Void, Response> {
        private UploadFile file;
        @Override
        protected Response doInBackground(UploadFile... uploadFiles) {
            file = uploadFiles[0];

            OkHttpClient client = new OkHttpClient();

            try {
                RequestBody fileBody = RequestBody.create(MediaType.parse("multipart/form-data"), file.getFile());
                RequestBody body = new MultipartBody.Builder()
                        .setType(MultipartBody.FORM)
                        .addFormDataPart("multipartFile", file.getFileName(), fileBody)
                        .addFormDataPart("userId", "" + file.getUserId())
                        .addFormDataPart("groupId", "" + file.getGroupId())
                        .addFormDataPart("fileKey", file.getFileName())
                        .addFormDataPart("fileType","" + file.getFileType())
                        .addFormDataPart("duration", "" + file.getDuraion())
                        .addFormDataPart("timestamp", "" + System.currentTimeMillis()/1000)
                        .build();

                Request request = new Request.Builder()
                        .header("Authorization", "Client-ID " + UUID.randomUUID())
                        .url(upload_url)
                        .post(body)
                        .build();

                Response response = client.newCall(request).execute();
                LogUtil.d("Upload response = " + response.isSuccessful());
                LogUtil.d("Upload body = " + response.body());

                return response;
            } catch (IOException e) {
                LogUtil.e(e.getMessage());
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Response result) {
            super.onPostExecute(result);

            if(result != null){
                LogUtil.d("Upload response code = " + result.code() + " body = " + result.toString());
                if(result.code() == 200){
                    LogUtil.e("Upload success");
                } else {
                    LogUtil.e("Upload fail code=" + result.code());
                }
            } else {
                LogUtil.e("onPostExecute result==null");
            }
        }
    }
}
