package com.jimi.jimitalk.tools;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    // 单线程化的线程池，它只会用唯一的工作线程来执行任务，保证所有任务按照指定顺序(FIFO, LIFO, 优先级)执行。
    private ExecutorService newSingleThreadExecutor;
    // 可缓存线程池，如果线程池长度超过处理需要，可灵活回收空闲线程，若无可回收，则新建线程。
    private ExecutorService newCachedThreadPool;

    private ThreadUtils() {
        newSingleThreadExecutor = Executors.newSingleThreadExecutor();
        newCachedThreadPool = Executors.newCachedThreadPool();
    }

    public ExecutorService getNewSingleThreadExecutor() {
        return newSingleThreadExecutor;
    }

    public ExecutorService getNewCachedThreadPool() {
        return newCachedThreadPool;
    }

    private static class Holder {
        private static ThreadUtils INSTANCE;

        private static void init() {
            INSTANCE = new ThreadUtils();
        }
    }

    public static void initThreadUtils() {
        Holder.init();
    }

    public static void closeThreadUtils() {
        try{
            Holder.INSTANCE.newSingleThreadExecutor.shutdown();
            if (!Holder.INSTANCE.newSingleThreadExecutor.awaitTermination(1, TimeUnit.SECONDS)) {
                LogUtil.e("1s timeout to wait, shutdown grpc grpcInstantRequestHandler now!");
                Holder.INSTANCE.newSingleThreadExecutor.shutdownNow();
            }
        } catch (Throwable e) {
            Holder.INSTANCE.newSingleThreadExecutor.shutdownNow();
            e.printStackTrace();
        }

        try{
            Holder.INSTANCE.newCachedThreadPool.shutdown();
            if (!Holder.INSTANCE.newCachedThreadPool.awaitTermination(1, TimeUnit.SECONDS)) {
                LogUtil.e("1s timeout to wait, shutdown grpc newCachedThreadPool now!");
                Holder.INSTANCE.newCachedThreadPool.shutdownNow();
            }
        } catch (Throwable e) {
            Holder.INSTANCE.newCachedThreadPool.shutdownNow();
            e.printStackTrace();
        }
    }

    public static ThreadUtils getInstance() {
        return Holder.INSTANCE;
    }
}
