package com.jimi.jimitalk.tools;

/**
 * @author Administrator
 * @date 2019/12/26
 */
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Build;

import java.util.HashMap;
import java.util.Map;

public class SoundPoolUtils {
    private static SoundPool soundPool = builder();

    private static Map<Integer, Integer> soundIDMap = new HashMap<>();

    private static SoundPool builder() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            SoundPool.Builder builder = new SoundPool.Builder();
            //传入音频的数量
            builder.setMaxStreams(1);
            //AudioAttributes是一个封装音频各种属性的类
            AudioAttributes.Builder attrBuilder = new AudioAttributes.Builder();
            //设置音频流的合适属性
            attrBuilder.setLegacyStreamType(AudioManager.STREAM_MUSIC);
            builder.setAudioAttributes(attrBuilder.build());
            soundPool = builder.build();
        } else {
            //第一个参数是可以支持的声音数量，第二个是声音类型，第三个是声音品质
            soundPool = new SoundPool(1, AudioManager.STREAM_MUSIC, 0);
        }

        return soundPool;
    }

//    public static void init() {
//        if (soundPool == null) {
//            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
//                SoundPool.Builder builder = new SoundPool.Builder();
//                //传入音频的数量
//                builder.setMaxStreams(1);
//                //AudioAttributes是一个封装音频各种属性的类
//                AudioAttributes.Builder attrBuilder = new AudioAttributes.Builder();
//                //设置音频流的合适属性
//                attrBuilder.setLegacyStreamType(AudioManager.STREAM_MUSIC);
//                builder.setAudioAttributes(attrBuilder.build());
//                soundPool = builder.build();
//            } else {
//                //第一个参数是可以支持的声音数量，第二个是声音类型，第三个是声音品质
//                soundPool = new SoundPool(1, AudioManager.STREAM_MUSIC, 0);
//            }
//
//            int pttSoundId = soundPool.load(MyApplication.getContext(), R.raw.ptt, 1);
//            soundIDMap.put(R.raw.ptt, pttSoundId);
//        }
//    }

    public static void loadSound(int resId, Context context) {
        int soundId = soundPool.load(context, resId, 1);
        soundIDMap.put(resId, soundId);
    }

    /**
     * 播放音频文件
     *
     * @param resId      音频文件 R.raw.xxx
     * @param repeatTime 重复次数
     */
    public static void play(int resId, int repeatTime) {
        int soundID = soundIDMap.get(resId);
        soundPool.play(soundID, 0.3f, 0.3f, 0, repeatTime, 1);
    }
}

