package com.jimi.jimitalk.tools;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;

//import com.google.gson.Gson;
//import com.google.gson.reflect.TypeToken;
//
//import java.util.ArrayList;
//import java.util.List;
//
//import isd.src.bean.TalkMessage;

@SuppressLint("StaticFieldLeak")
public class SPUtil {

    private static SharedPreferences sharedPreferences;
    private static SharedPreferences.Editor sharedPreferencesEditor;

    @SuppressLint("CommitPrefEdits")
    public static void init(Context context) {
        sharedPreferences = context.getSharedPreferences("setting", Context.MODE_PRIVATE);
        sharedPreferencesEditor = sharedPreferences.edit();
    }

    /**
     *
     * @param address
     * @description address
     */
    public static void setServer(String address) {
        sharedPreferencesEditor.putString("server", address);
        sharedPreferencesEditor.commit();
    }

    /**
     *
     * @return
     */
    public static String getServer() {
        return sharedPreferences.getString("server", "dev.yunptt.com");
    }

    /**
     *
     * @param port
     */
    public static void setWebrtcPort(int port) {
        sharedPreferencesEditor.putInt("webrtc", port);
        sharedPreferencesEditor.commit();
    }

    /**
     *
     * @return
     */
    public static int getWebrtcPort() {
        return sharedPreferences.getInt("webrtc", 9188);
    }

    /**
     *
     * @param port
     */
    public static void setGrpcPort(int port) {
        sharedPreferencesEditor.putInt("grpc", port);
        sharedPreferencesEditor.commit();
    }

    /**
     *
     * @return
     */
    public static int getGrpcPort() {
        return sharedPreferences.getInt("grpc", 9001);
    }

    /**
     *
     * @param port
     */
    public static void setDataPort(int port) {
        sharedPreferencesEditor.putInt("data", port);
        sharedPreferencesEditor.commit();
    }

    /**
     *
     * @return
     */
    public static int getDataPort() {
        return sharedPreferences.getInt("data", 10000);
    }

    /**
     * 设置上一次登录的群组ID
     * @param gid
     */
    public static void setLockGid(int gid){
        sharedPreferencesEditor.putInt("lockGid", gid);
        sharedPreferencesEditor.commit();
    }

    /**
     * 获取上一次登录的群组ID
     * @return
     */
    public static int getLockGid(){
        return sharedPreferences.getInt("lockGid",-1);
    }

    public static boolean isLockGidValid() {
        if (getLockGid() == -1) {
            return false;
        }

        return true;
    }

    /**
     * 设置用户ID
     * @param userId
     */
    public static void setUserId(int userId){
        sharedPreferencesEditor.putInt("userId", userId);
        sharedPreferencesEditor.commit();
    }

    /**
     * 获取用户ID
     * @return
     */
    public static int getUserId(){
        return sharedPreferences.getInt("userId",0);
    }

    /**
     * 设置用户Account
     * @param userAccount
     */
    public static void setUserAccount(String userAccount){
        sharedPreferencesEditor.putString("userAccount", userAccount);
        sharedPreferencesEditor.commit();
    }

    /**
     * 获取用户Account
     * @return
     */
    public static String getUserAccount(){
        return sharedPreferences.getString("userAccount","");
    }

    /**
     * 设置用户密码
     * @param password
     */
    public static void setPassword(String password){
        sharedPreferencesEditor.putString("password", password);
        sharedPreferencesEditor.commit();
    }

    /**
     * 获取用户密码
     * @return
     */
    public static String getPassword(){
        return sharedPreferences.getString("password","");
    }

//    /**
//     * groupId 为key, list转json为value存储录音回放数据
//     * @param groupId
//     * @param uris
//     */
//    public synchronized static void recordPttMessages(int groupId, List<TalkMessage> uris) {
//        Gson gson = new Gson();
//        String urisStr = gson.toJson(uris);
//
//        sharedPreferencesEditor.putString(groupId + "", urisStr);
//        sharedPreferencesEditor.commit();
//    }
//
//    /**
//     * 根据groupId获取录音回放数据list
//     * @param groupId
//     * @return
//     */
//    public static List<TalkMessage> getPttMessages(int groupId) {
//        String urisStr = sharedPreferences.getString(groupId + "", "");
//        List<TalkMessage> uris = new ArrayList<>();
//        if (!urisStr.equals("")) {
//            Gson gson = new Gson();
//            uris = gson.fromJson(urisStr, new TypeToken<List<TalkMessage>>(){}.getType());
//        }
//        return uris;
//    }

    /**
     * 从LoginRsp获取GrpcSessionId,用于在超时范围内重连
     * @param sessionId
     */
    public static void setGrpcSessionId(String sessionId) {
        sharedPreferencesEditor.putString("grpcSessionId", sessionId);
        sharedPreferencesEditor.commit();
    }

    /**
     * 获取GrpcSessionId
     * @return
     */
    public static String getGrpcSessionId() {
        return sharedPreferences.getString("grpcSessionId", "");
    }

    /**
     * 设置IPS服务
     */
    public static void setIpsStat(Boolean isOpened) {
        sharedPreferencesEditor.putBoolean("ips", isOpened);
        sharedPreferencesEditor.commit();
    }

    /**
     * 获取IPS服务开关状态
     */
    public static boolean getIpsStat() {
        return sharedPreferences.getBoolean("ips", true);
    }

    /**
     * 清除所有的sharedPreferences数据
     * */
    public static void clearMyData(){
        sharedPreferencesEditor.clear();
    }
}
