package com.jimi.jimitalk.tools;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;

public class MediaPlayerUtil {

    private static volatile MediaPlayerUtil mediaPlayer;

    private MediaPlayerUtil() {
    }

    public static MediaPlayerUtil getMediaPlayer() {
        if (mediaPlayer == null) {
            synchronized (MediaPlayerUtil.class) {
                if (mediaPlayer == null) {
                    mediaPlayer = new MediaPlayerUtil();
                }
            }
        }
        return mediaPlayer;
    }

    public static void closeMediaPlayerUtil() {
        if (mediaPlayer != null) {
            mediaPlayer.stopPlay();
            nowPlayMediaUrl = null;
            mediaPlayer = null;
        }
    }

    private MediaPlayer mPlayer;
    private static String nowPlayMediaUrl;

    /**
     * 播放音频
     *
     * @param mediaUrl 网络音频Url
     */
    public synchronized void startPlay(Context context, String mediaUrl, int rawId, OnMediaPlayerCallback callback) {
        try {
            stopPlay();
            nowPlayMediaUrl = mediaUrl;
            mPlayer = new MediaPlayer();
            if ("".equals(mediaUrl)) {
                mPlayer.setDataSource(context, Uri.parse("android.resource://" + context.getPackageName() + "/" + rawId));
            } else {
                mPlayer.setDataSource(mediaUrl);
            }
            mPlayer.prepareAsync();
            mPlayer.setOnPreparedListener(mp -> mPlayer.start());
            mPlayer.setOnErrorListener((m, w, e) -> {
                return false;
            });
            mPlayer.setOnCompletionListener(p -> {
                callback.onCompleted(true);
                nowPlayMediaUrl = "";
                mPlayer.stop();
                mPlayer.reset();
                mPlayer.release();
                mPlayer = null;
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 列表中的音频播放
     * <p>
     * 点击播放，再点击停止
     *
     * @param mediaUrl
     */
    public void playOrStop(Context context, String mediaUrl, int rawId, OnMediaPlayerCallback callback) {
        if (mPlayer != null) {
            stopPlay();
        } else {
            startPlay(context, mediaUrl, rawId, callback);
        }
    }

    /**
     * 停止播放音频，lastMediaUrl置空
     */
    public synchronized void stopPlay() {
        nowPlayMediaUrl = "";
        try {
            if (mPlayer != null && mPlayer.isPlaying()) {
                mPlayer.stop();
                mPlayer.release();
                mPlayer = null;
            } else if (mPlayer != null) {
                mPlayer.release();
                mPlayer = null;
            }
        } catch (Exception e) {
            LogUtil.e("stopPlay: " + e.toString());
        }
    }

    public interface OnMediaPlayerCallback {
        void onCompleted(boolean completed);
    }
}