package com.jimi.jimitalk.tools;

import android.content.Context;
import android.os.Environment;
import android.util.Log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;

public class LogcatHelper {
    private static String TAG = "LogcatHelper";
    private static LogcatHelper INSTANCE = null;
    private LogDumper mLogDumper = null;
    private String logPath = Environment.getExternalStorageDirectory().getPath() + "/appLog/" ; //可设置
    private String logFileName = "log";                                                       //可设置
    private String logFormat = "time";                                                        //log打印样式级别：brief process tag thread raw time threadtime long
    private String logLevel = "d";                                                            //过滤级别： v d i w e f
    private int mPId = 1;                                                                     //process Id
    private String logTAG = "" + mPId;                                                        //过滤tag可设置  交集再来一次grep 并集-e

    private int mFileMaxCount = 5;                    // 单次运行下，最大可保留日志文件数目
    private int mFileMaxSize = 100;                   // 单个文件最大容量，单位MB，默认100M
    private File mCurrent = null;                     // 当前读写的日志文件
    private Deque<File> mFiles = new LinkedList<>();  // 日志管理队列

    public static LogcatHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LogcatHelper();
        }
        return INSTANCE;
    }

    private LogcatHelper() {
        mPId = android.os.Process.myPid();

        LogUtil.e("000 logPath=" + logPath);
        File file = new File(logPath);
        if (!file.exists()) {
            LogUtil.e("0000");
            file.mkdirs();
        } else {
            LogUtil.e("00000");
            mFiles = getFileSort(logPath);
        }
    }

    public static LogcatHelper getInstance(Context context, String format, String level, String dirPath, String fileName, int filesMaxCount, int fileMaxSize) {
        if (INSTANCE == null) {
            INSTANCE = new LogcatHelper(context, format, level, dirPath, fileName, filesMaxCount, fileMaxSize);
        }
        return INSTANCE;
    }

    private LogcatHelper(Context context, String format, String level, String dirPath, String fileName, int filesMaxCount, int fileMaxSize) {
        logFormat = format;
        logLevel = level;
        logPath = dirPath;
        logFileName = fileName;
        mFileMaxCount = filesMaxCount;
        mFileMaxSize = (fileMaxSize < 0 || fileMaxSize > mFileMaxSize) ? mFileMaxSize : fileMaxSize;
        mPId = android.os.Process.myPid();

        File file = new File(logPath);
        if (!file.exists()) {
            file.mkdirs();
        } else {
            mFiles = getFileSort(logPath);
        }
    }

    public void start() {
        LogUtil.e("111");
        if (mLogDumper == null)
        {
            mLogDumper = new LogDumper();
            mLogDumper.start();
        }
    }

    public void stop() {
        if (mLogDumper != null) {
            mLogDumper.stopLogs();
            mLogDumper = null;
        }

        if (INSTANCE != null) {
            INSTANCE = null;
        }
    }

    public void setmFileMaxCount(int MaxCount) {
        Log.e(TAG,"--------------------日志MaxCount被修改:" + MaxCount + "-------------------");
        INSTANCE.stop();
        mFileMaxCount = MaxCount;
        INSTANCE.start();
    }

    public void setFileMaxSizeInMB(int fileMaxSize) {
        Log.e(TAG,"--------------------日志fileMaxSizeInMB被修改:" + fileMaxSize + "-------------------");
        INSTANCE.stop();
        mFileMaxSize = fileMaxSize;
        INSTANCE.start();
    }

    public void setLogFormat(String format) {
        Log.e(TAG,"--------------------日志format被修改:" + format + "-------------------");
        INSTANCE.stop();
        logFormat = format;
        INSTANCE.start();
    }

    public void setLogLevel(String level) {
        Log.e(TAG,"--------------------日志level被修改:" + level + "-------------------");
        INSTANCE.stop();
        logLevel = level;
        INSTANCE.start();
    }

    public void setLogTAG(String tag) {
        Log.e(TAG,"--------------------日志tag被修改:" + tag + "-------------------");
        INSTANCE.stop();
        logTAG = tag;
        INSTANCE.start();
    }

    public void setLogPath(String path) {
        Log.e(TAG,"--------------------日志path被修改:" + path + "-------------------");
        INSTANCE.stop();
        logPath = path;
        INSTANCE.start();
    }

    public void setLogFileName(String name) {
        Log.e(TAG,"--------------------日志name被修改:" + name + "-------------------");
        INSTANCE.stop();
        logFileName = name;
        INSTANCE.start();
    }

    public String getLogPath() {
        return logPath;
    }

    private String getFileName() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String date = format.format(new Date(System.currentTimeMillis()));
        if ("log".equals(logFileName)) {
            logFileName = date;
        }
        return logFileName;// 2012年10月03日 23:41:31
    }

    /**
     * 获取目录下所有文件
     */
    private LinkedList<File> getFiles(String dirPath, LinkedList<File> files) {
        File realFile = new File(dirPath);
        if (realFile.isDirectory()) {
            File[] subFiles = realFile.listFiles();
            if (subFiles == null) {
                return files;
            }

            for (File file : subFiles) {
                if (file.isDirectory()) {
                    getFiles(file.getAbsolutePath(), files);
                } else {
                    files.offer(file);
                }
            }
        }
        return files;
    }

    /**
     * 获取目录下所有文件(按时间排序)
     */
    private LinkedList<File> getFileSort(String path) {
        LinkedList<File> list = new LinkedList<>();

        getFiles(path, list);

        if (list != null && list.size() > 0) {
            LogUtil.e("666");
            Collections.sort(list, new Comparator<File>() {
                public int compare(File file, File newFile) {
                    if (file.lastModified() > newFile.lastModified()) {
                        return 1;
                    } else if (file.lastModified() == newFile.lastModified()) {
                        return 0;
                    } else {
                        return -1;
                    }
                }
            });
        }
        return list;
    }

    private class LogDumper extends Thread {

        private Process logcatProc;
        private BufferedReader mReader = null;
        private boolean mRunning = true;
        String cmds = null;
        String mPID = null;
        private FileOutputStream out = null;

        public LogDumper() {
            LogUtil.e("222");
            mPID =String.valueOf(mPId);
            fileOutputStreamGenerator();
            // cmds = "logcat *:e *:w | grep \"(" + mPID + ")\"";
            // cmds = "logcat  -v "+ logFormat + "  | grep \"(" + mPID + ")\"";//打印所有日志信息
            // cmds = "logcat -s way";//打印标签过滤信息
            cmds = "logcat  -v "+ logFormat + " *:" + logLevel + " AudioTrack:I" + " | grep " + mPID + " | grep " +  logTAG
                    + " | grep -v audio_mixer_impl.cc | grep -v org.webrtc.Logging | grep -v rtp_sender_audio.cc | grep -v webrtc_voice_engine.cc | grep -v audio_processing_impl.cc "
            + " | grep -v audio_record_jni.cc | grep -v HwCustAudioRecordImpl | grep -v chatty | grep -v nack_module.cc";
        }

        public void stopLogs() {
            mRunning = false;
        }

        private void fileOutputStreamGenerator() {
            try {
                if (!mFiles.isEmpty() && (mFiles.getLast().length() < mFileMaxSize * 1024 * 1024)) {
                    LogUtil.e("333");
                    mCurrent = mFiles.getLast();
                } else {
                    LogUtil.e("444");
                    mCurrent = new File(logPath, getFileName() + "_" + getTimestamp() + ".log");
                }
                out = new FileOutputStream(mCurrent, true);

                mFiles.offer(mCurrent);
                if (mFiles.size() > mFileMaxCount) {
                    File oldOne = mFiles.poll();
                    if (oldOne != null) {
                        oldOne.delete();
                    }
                }
            } catch (FileNotFoundException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

        private long getTimestamp() {
            return System.currentTimeMillis() / 1000;
        }

        @Override
        public void run() {
            LogUtil.e("555");
            try {
//                logcatProc = Runtime.getRuntime().exec(cmds);
                String[] commands = { "/system/bin/sh", "-c", cmds };
                logcatProc = Runtime.getRuntime().exec(commands);
                outPutLogCatData();
            } catch (IOException e) {
                e.printStackTrace();
                Log.e("long", "logPath:" + logPath);
                //出现异常的时候可能是SHELL位置问题 可能在bin/sh下  但是这里直接用最初版本log的以保证有log 但是无法过滤关键词不打印
                if (e.getMessage().contains("/system/bin/sh")) {
                    try {
                         logcatProc = Runtime.getRuntime().exec(cmds);
                        outPutLogCatData();
                    } catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            } finally {
                if (logcatProc != null) {
                    logcatProc.destroy();
                    logcatProc = null;
                }
                if (mReader != null) {
                    try {
                        mReader.close();
                        mReader = null;
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    out = null;
                }
            }
        }

        private void outPutLogCatData() throws IOException {
            mReader = new BufferedReader(new InputStreamReader(logcatProc.getInputStream()), 1024);
            String line = null;
            while (mRunning && (line = mReader.readLine()) != null) {
                if (!mRunning) {
                    break;
                }

                if (line.length() == 0) {
                    continue;
                }

                if (mCurrent.exists()) {
                    if (mCurrent.length() > mFileMaxSize * 1024 * 1024) {
                        fileOutputStreamGenerator();
                    }
                } else {
                    fileOutputStreamGenerator();
                }

                if (out != null && line.contains(mPID)) {
                    out.write((line + "\n").getBytes());
                }
            }
        }
    }
}
