package com.jimi.jimitalk.tools;

import android.content.Context;
import android.media.projection.MediaProjection;

import com.jimi.jimitalk.R;
import com.jimi.jimitalk.bean.UserBean;
import com.jimi.jimitalk.ptt.webrtc.AppRTCAudioManager;
import com.jimi.jimitalk.receiver.NetWorkStatusChangeReceiver;

import org.webrtc.EglBase;

/**
 * @author Administrator
 * @date 2020/2/26
 */
public class JimipttConfig {
    private static Context sAppContext;
    private static EglBase _rootEglBase;

    public static MediaProjection getMediaProjection() {
        return mediaProjection;
    }

    public static void setMediaProjection(MediaProjection mediaProjection) {
        JimipttConfig.mediaProjection = mediaProjection;
    }

    private static MediaProjection mediaProjection;

    public static void init(Context appContext) {
        sAppContext = appContext;
        _rootEglBase = EglBase.create();

        CrashHandler.getInstance().init(sAppContext);

        LogcatHelper.getInstance().start();

        AppRTCAudioManager.create(appContext, ()->{}).init();

        SoundPoolUtils.loadSound(R.raw.ptt, sAppContext);

        SPUtil.init(sAppContext);

        ThreadUtils.initThreadUtils();

        DBUtil.ChatDBManager.initialize(sAppContext);

        NetWorkStatusChangeReceiver.getInstance(sAppContext);
    }

    public static void release() {
        MediaPlayerUtil.closeMediaPlayerUtil();

        UserBean.clearUserBean();

        DBUtil.ChatDBManager.closeDBManager();

        LogcatHelper.getInstance().stop();
    }

    public static Context getAppContext() {
        return sAppContext;
    }

    public static EglBase getRootEglbase() {
        return _rootEglBase;
    }
}
