package com.jimi.jimitalk.receiver;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.util.Log;

import com.jimi.jimitalk.grpc.GrpcConnectionController;

//todo 无网络 断开连接 有网络 开始重连 grpc和janus重连就不用再进行网络状态判断
public class NetWorkStatusChangeReceiver {

    private Context mContext;
    private static NetWorkStatusChangeReceiver instance = null;
    final ConnectivityManager cm;

    public static NetWorkStatusChangeReceiver getInstance(Context context) {
        if (instance == null) {
            synchronized (NetWorkStatusChangeReceiver.class) {
                if (instance == null) {
                    instance = new NetWorkStatusChangeReceiver(context);
                }
            }
        }
        return instance;
    }

    public NetWorkStatusChangeReceiver(Context context) {
        mContext = context;
        cm = (ConnectivityManager) mContext.getSystemService(Context.CONNECTIVITY_SERVICE);
        cm.requestNetwork(new NetworkRequest.Builder().build(), new ConnectivityManager.NetworkCallback() {
            @Override
            public void onLost(Network network) {
                super.onLost(network);
                ///网络不可用的情况下的方法
                Log.e("long", "网络断开");
                if (GrpcConnectionController.getInstance() != null) {
                    GrpcConnectionController.getInstance().netWorkProblem();
                }
//                GrpcConnectionController.getInstance().ifReconnectForNetWorkMonitor();
            }

            @Override
            public void onAvailable(Network network) {
                super.onAvailable(network);
                ///网络可用的情况下的方法
                Log.e("long", "网络连上了");
                if (GrpcConnectionController.getInstance() != null) {
                    GrpcConnectionController.getInstance().ifReconnectForNetWorkMonitor();
                }
            }
        });
    }

    public void stopReceiver() {
    }
}
