package com.jimi.jimitalk.ptt.janusclientapi;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.Nullable;

import com.jimi.jimitalk.tools.JimipttConfig;
import com.jimi.jimitalk.tools.LogUtil;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.DataChannel;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RtpReceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.JavaAudioDeviceModule;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by ben.trent on 6/25/2015.
 */
public class JanusPluginHandle {
    private SessionDescription mySdp = null;
    private PeerConnection pc = null;
    private DataChannel dataChannel = null;
    private boolean trickle = true;
    private boolean iceDone = false;
    private boolean sdpSent = false;

    private String VIDEO_TRACK_ID = "1929283";
    private String AUDIO_TRACK_ID = "1928882";
    private String LOCAL_MEDIA_ID = "1198181";

    private VideoSource videoSource;
    private AudioSource audioSource;

    private AudioTrack audioTrack = null;
    private VideoTrack videoTrack = null;
    private MediaStream myStream = null;

    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private JanusServer server;
    public  JanusSupportedPluginPackages plugin;
    public  BigInteger id;
    private IJanusPluginCallbacks iJanusPluginCallbacks;

    private Context _context = JimipttConfig.getAppContext();
    private boolean isVideo;
    private boolean isAudio;

    private static SurfaceTextureHelper _surfaceTextureHelper;
    private VideoCapturer _captureAndroid;
    private final int VIDEO_RESOLUTION_WIDTH = 320;
    private final int VIDEO_RESOLUTION_HEIGHT = 240;
    private final int FPS = 30;

    private static AudioManager am = (AudioManager) JimipttConfig.getAppContext().getSystemService(Context.AUDIO_SERVICE);
    private static JavaAudioDeviceModule jadm = null;
    private static PeerConnectionFactory sessionFactory = null;

    public JanusPluginHandle(JanusServer server, JanusSupportedPluginPackages plugin, BigInteger handle_id, IJanusPluginCallbacks iJanusPluginCallbacks) {
        this.server = server;
        this.plugin = plugin;
        this.id = handle_id;
        this.iJanusPluginCallbacks = iJanusPluginCallbacks;
    }

    public void createPeerConnectionFactory(Context context, boolean isAudio, boolean isVideo) {
        this.isVideo = isVideo;
        this.isAudio = isAudio;

        executor.execute(() -> {
            if(jadm == null){
                jadm = (JavaAudioDeviceModule) JavaAudioDeviceModule.builder(_context).createAudioDeviceModule();

                PeerConnectionFactory.initialize(PeerConnectionFactory.InitializationOptions.builder(_context)
                        .createInitializationOptions());
                final VideoEncoderFactory encoderFactory;
                final VideoDecoderFactory decoderFactory;
                boolean hardwareAccelerated = true;
                if (hardwareAccelerated) {
                    encoderFactory = new DefaultVideoEncoderFactory(
                            JimipttConfig.getRootEglbase().getEglBaseContext(),
                            true,
                            true);
                    decoderFactory = new DefaultVideoDecoderFactory(JimipttConfig.getRootEglbase().getEglBaseContext());
                } else {
                    encoderFactory = new SoftwareVideoEncoderFactory();
                    decoderFactory = new SoftwareVideoDecoderFactory();
                }
                PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();

                //此处设置禁用网络类型
                /*
                 *     static final int ADAPTER_TYPE_UNKNOWN = 0;
                 *     static final int ADAPTER_TYPE_ETHERNET = 1 << 0;
                 *     static final int ADAPTER_TYPE_WIFI = 1 << 1;
                 *     static final int ADAPTER_TYPE_CELLULAR = 1 << 2;
                 *     static final int ADAPTER_TYPE_VPN = 1 << 3;
                 *     static final int ADAPTER_TYPE_LOOPBACK = 1 << 4;
                 *     static final int ADAPTER_TYPE_ANY = 1 << 5;
                 */
                //设置允许开启ADAPTER_TYPE_ETHERNET、ADAPTER_TYPE_WIFI、ADAPTER_TYPE_CELLULAR、ADAPTER_TYPE_VPN
                options.networkIgnoreMask = ~(1 | 2 | 4 | 8);

                sessionFactory = PeerConnectionFactory.builder()
                        .setOptions(options)
                        .setAudioDeviceModule(jadm)
                        .setVideoEncoderFactory(encoderFactory)
                        .setVideoDecoderFactory(decoderFactory)
                        .createPeerConnectionFactory();
            }
        });
    }

    public void jadmWakeup() {
        if(am != null) {
            jadm.audioOutput.isSleeping = false;
            jadm.audioOutput.firstAfterWakerup = true;
        }
    }

    public void jadmSleep() {
        if(am != null) {
            jadm.audioOutput.isSleeping = true;
            jadm.audioOutput.firstAfterWakerup = true;
        }
    }

    public void addAudioTrack() {
        LogUtil.d("Stream is null?" + (myStream == null) + " audioTrack is null?" + (audioTrack == null) + " pc is null?" + (pc == null));
        executor.execute(() -> {
            PeerConnectionFactory.enableSendRtcp(true);
            if(myStream != null && audioTrack != null && pc != null){
                myStream.addTrack(audioTrack);
                onLocalStream(myStream);
                pc.addStream(myStream);
            }
        });
    }

    public void removeAudioTrack() {
        LogUtil.d("stream is null?" + (myStream == null) + " audioTrack is null?" + (audioTrack == null) + " pc is null?" + (pc == null));
        executor.execute(() -> {
            PeerConnectionFactory.enableSendRtcp(false);
            if(myStream != null && audioTrack != null && pc != null) {
                myStream.removeTrack(audioTrack);
                pc.removeStream(myStream);
            }
        });
    }

    public void switchCamera() {
        CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)_captureAndroid;
        cameraVideoCapturer.switchCamera(null);
    }

    //创建peerConnection
    public void createPeerConnection(IPluginHandleWebRTCCallbacks callbacks) {
        executor.execute(() -> {
            PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(server.iceServers);

//            rtcConfig.stunCandidateKeepaliveIntervalMs = 1000;
//            rtcConfig.iceCheckMinInterval =  1000;
//            rtcConfig.audioJitterBufferFastAccelerate = true;
            rtcConfig.audioJitterBufferMaxPackets = 500;//75;
            //禁用tcp/ipv6 candidate
            rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.DISABLED;
            rtcConfig.disableIpv6 = true;

            pc = sessionFactory.createPeerConnection(rtcConfig, new WebRtcObserver(callbacks));
            trickle = callbacks.getTrickle() != null ? callbacks.getTrickle() : false;

            if (callbacks.getMedia().getSendAudio()) {
                audioSource = sessionFactory.createAudioSource(new MediaConstraints());
                audioTrack = sessionFactory.createAudioTrack(AUDIO_TRACK_ID, audioSource);
            }

            LogUtil.d("Need to send video?" + callbacks.getMedia().getSendVideo());
            if (callbacks.getMedia().getSendVideo()) {
                LogUtil.d("Need to set camera?" + callbacks.getMedia().getCamera() + " Camera2 is supported?" + useCamera2());
                switch (callbacks.getMedia().getCamera()) {
                    case back:
                        if(useCamera2()){
                            _captureAndroid = createCameraCapture(new Camera2Enumerator(_context), false);
                        }else{
                            _captureAndroid = createCameraCapture(new Camera1Enumerator(true), false);
                        }
                        break;
                    case front:
                        if(useCamera2()){
                            _captureAndroid = createCameraCapture(new Camera2Enumerator(_context), true);
                        }else{
                            _captureAndroid = createCameraCapture(new Camera1Enumerator(true), true);
                        }
                        break;
                }
                if (_surfaceTextureHelper == null) {
                    _surfaceTextureHelper = SurfaceTextureHelper.create("CaptureThread", JimipttConfig.getRootEglbase().getEglBaseContext());
                }
//                _surfaceTextureHelper = SurfaceTextureHelper.create("CaptureThread", JimipttConfig.getRootEglbase().getEglBaseContext());
                videoSource = sessionFactory.createVideoSource(_captureAndroid.isScreencast());
                _captureAndroid.initialize(_surfaceTextureHelper, _context, videoSource.getCapturerObserver());
                _captureAndroid.startCapture(VIDEO_RESOLUTION_WIDTH, VIDEO_RESOLUTION_HEIGHT, FPS);
                videoTrack = sessionFactory.createVideoTrack(VIDEO_TRACK_ID, videoSource);
            }

            LogUtil.d("audioTrack != null?" + (audioTrack != null));
            LogUtil.d("videoTrack != null?" + (videoTrack != null));
            if (audioTrack != null || videoTrack != null) {
                myStream = sessionFactory.createLocalMediaStream(LOCAL_MEDIA_ID);
                if (audioTrack != null) {
                    myStream.addTrack(audioTrack);
                }

                if (videoTrack != null && callbacks.getMedia().getSendVideo()) {
                    myStream.addTrack(videoTrack);
                }
            }

            if (myStream != null) {
                onLocalStream(myStream);
            }

            if (myStream != null) {
                pc.addStream(myStream);
            }

            LogUtil.d("Is jsep existed?" + (callbacks.getJsep() == null));
            if (callbacks.getJsep() == null) {
                pc.createOffer(new WebRtcObserver(callbacks), offerOrAnswerConstraint());
            } else {
                try {
                    JSONObject obj = callbacks.getJsep();
                    String sdp = obj.getString("sdp");
                    SessionDescription.Type type = SessionDescription.Type.fromCanonicalForm(obj.getString("type"));
                    SessionDescription sessionDescription = new SessionDescription(type, sdp);
                    pc.setRemoteDescription(new WebRtcObserver(callbacks), sessionDescription);
                } catch (Exception ex) {
                    callbacks.onCallbackError(ex.getMessage());
                }
            }
        });
    }

    public void JanusSetRemoteDescription(IPluginHandleWebRTCCallbacks callbacks, boolean isUpdateMySdp){
        executor.execute(() -> {
            try {
                if (isUpdateMySdp) {
                    mySdp = null;
                }
                JSONObject obj = callbacks.getJsep();
                String sdp = obj.getString("sdp");
                SessionDescription.Type type = SessionDescription.Type.fromCanonicalForm(obj.getString("type"));
                SessionDescription sessionDescription = new SessionDescription(type, sdp);
                pc.setRemoteDescription(new WebRtcObserver(callbacks), sessionDescription);
            } catch (Exception ex) {
                callbacks.onCallbackError(ex.getMessage());
            }
        });
    }

    public void createOffer(IPluginHandleWebRTCCallbacks callbacks) {
        executor.execute(() -> {
            pc.createOffer(new WebRtcObserver(callbacks), offerOrAnswerConstraint());
        });
    }

    public void createAnswer(IPluginHandleWebRTCCallbacks callbacks) {
        executor.execute(() -> {
            pc.createAnswer(new WebRtcObserver(callbacks), offerOrAnswerConstraint());
        });
    }


    public void onMessage(String msg) {
        try {
            JSONObject obj = new JSONObject(msg);
            iJanusPluginCallbacks.onMessage(obj, null);
        } catch (JSONException ex) {
            //TODO do we want to notify the GatewayHandler?
        }
    }

    public void onMessage(JSONObject msg, JSONObject jsep) {
        iJanusPluginCallbacks.onMessage(msg, jsep);
    }

    private void onLocalStream(MediaStream stream) {
        iJanusPluginCallbacks.onLocalStream(stream);
    }

    private void onRemoteStream(MediaStream stream) {
        iJanusPluginCallbacks.onRemoteStream(stream);
    }

    public void onDataOpen(Object data) {
        iJanusPluginCallbacks.onDataOpen(data);
    }

    public void onData(Object data) {
        iJanusPluginCallbacks.onData(data);
    }

    public void onCleanup() {
        iJanusPluginCallbacks.onCleanup();
    }

    public void onDetached() {
        iJanusPluginCallbacks.onDetached();
    }

    public void sendMessage(IPluginHandleSendMessageCallbacks obj) {
        server.sendMessage(TransactionType.plugin_handle_message, id, obj, plugin);
    }

    private VideoCapturer createCameraCapture(CameraEnumerator enumerator, boolean isFront) {
        final String[] deviceNames = enumerator.getDeviceNames();

        // First, try to find front facing camera
        for (String deviceName : deviceNames) {
            if (isFront ? enumerator.isFrontFacing(deviceName) : enumerator.isBackFacing(deviceName)) {
                VideoCapturer videoCapturer = enumerator.createCapturer(deviceName, null);
                if (videoCapturer != null) {
                    return videoCapturer;
                }
            }
        }

        // Front facing camera not found, try something else TODO
        for (String deviceName : deviceNames) {
            if (!enumerator.isFrontFacing(deviceName)) {
                VideoCapturer videoCapturer = enumerator.createCapturer(deviceName, null);
                if (videoCapturer != null) {
                    return videoCapturer;
                }
            }
        }

        return null;
    }

    private boolean useCamera2() {
        return Camera2Enumerator.isSupported(_context);
    }

    public void hangUp() {
       if (audioSource != null) {
           audioSource.dispose();
           audioSource = null;
       }

       if (videoSource != null) {
           videoSource.dispose();
           videoSource = null;
       }

       if (_captureAndroid != null) {
           try {
               _captureAndroid.stopCapture();
           } catch (InterruptedException e) {
               e.printStackTrace();
           }
           _captureAndroid.dispose();
           _captureAndroid = null;
       }
//
//       if (_surfaceTextureHelper != null) {
//           _surfaceTextureHelper.dispose();
//           _surfaceTextureHelper = null;
//       }

       if (pc != null && pc.signalingState() != PeerConnection.SignalingState.CLOSED){
           pc.close();
           pc = null;
       }

//       if (sessionFactory != null) {
//           sessionFactory.dispose();
//           sessionFactory = null;
//       }

       mySdp = null;
       if (dataChannel != null)
           dataChannel.close();
       dataChannel = null;
       trickle = true;
       iceDone = false;
       sdpSent = false;

    }

    public void detach() {
        hangUp();
        JSONObject obj = new JSONObject();
        server.sendMessage(obj, JanusMessageType.detach, id);
    }

    public void janusDetach() {
        JSONObject obj = new JSONObject();
        server.sendMessage(obj, JanusMessageType.detach, id);
    }

    public void sendUserCall(int myId,String myName,int remoteId,int type,boolean isVideo,int isAccept) {
        server.sendMessage(myId, myName, remoteId, type, isVideo, isAccept);
    }

    private  final String VIDEO_CODEC_H264 = "H264";
    private  void onLocalSdp(SessionDescription sdp, IPluginHandleWebRTCCallbacks callbacks) {
        executor.execute(() ->{
            if (mySdp == null) {
                mySdp = sdp;
                if(JimipttConfig.getRootEglbase() != null && isVideo){
                    String sdpDescription = sdp.description;
                    sdpDescription = preferCodec(sdpDescription, VIDEO_CODEC_H264, false);
                    SessionDescription localsdp = new SessionDescription(sdp.type, sdpDescription);
                    pc.setLocalDescription(new WebRtcObserver(callbacks), localsdp);
                }else{
                    pc.setLocalDescription(new WebRtcObserver(callbacks), sdp);
                }
            }
            if (!iceDone && !trickle)
                return;
            if (sdpSent)
                return;
            try {
                sdpSent = true;
                JSONObject obj = new JSONObject();
                obj.put("sdp", mySdp.description);
                obj.put("type", mySdp.type.canonicalForm());
                callbacks.onSuccess(obj);
            } catch (JSONException ex) {
                callbacks.onCallbackError(ex.getMessage());
            }

        });
    }

    private static String preferCodec(String sdpDescription, String codec, boolean isAudio) {
        final String[] lines = sdpDescription.split("\r\n");
        final int mLineIndex = findMediaDescriptionLine(isAudio, lines);
        if (mLineIndex == -1) {
            return sdpDescription;
        }

        final List<String> codecPayloadTypes = new ArrayList<>();
        // a=rtpmap:<payload type> <encoding name>/<clock rate> [/<encoding parameters>]
        final Pattern codecPattern = Pattern.compile("^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$");
        for (String line : lines) {
            Matcher codecMatcher = codecPattern.matcher(line);
            if (codecMatcher.matches()) {
                codecPayloadTypes.add(codecMatcher.group(1));
            }
        }
        if (codecPayloadTypes.isEmpty()) {
            return sdpDescription;
        }

        final String newMLine = movePayloadTypesToFront(codecPayloadTypes, lines[mLineIndex]);
        if (newMLine == null) {
            return sdpDescription;
        }

        lines[mLineIndex] = newMLine;
        return joinString(Arrays.asList(lines), "\r\n", true /* delimiterAtEnd */);
    }

    private static @Nullable
    String movePayloadTypesToFront(
            List<String> preferredPayloadTypes, String mLine) {
        // The format of the media description line should be: m=<media> <port> <proto> <fmt> ...
        final List<String> origLineParts = Arrays.asList(mLine.split(" "));
        if (origLineParts.size() <= 3) {
            return null;
        }
        final List<String> header = origLineParts.subList(0, 3);
        final List<String> unpreferredPayloadTypes =
                new ArrayList<>(origLineParts.subList(3, origLineParts.size()));
        unpreferredPayloadTypes.removeAll(preferredPayloadTypes);
        // Reconstruct the line with |preferredPayloadTypes| moved to the beginning of the payload
        // types.
        final List<String> newLineParts = new ArrayList<>();
        newLineParts.addAll(header);
        newLineParts.addAll(preferredPayloadTypes);
        newLineParts.addAll(unpreferredPayloadTypes);
        return joinString(newLineParts, " ", false /* delimiterAtEnd */);
    }

    private static int findMediaDescriptionLine(boolean isAudio, String[] sdpLines) {
        final String mediaDescription = isAudio ? "m=audio " : "m=video ";
        for (int i = 0; i < sdpLines.length; ++i) {
            if (sdpLines[i].startsWith(mediaDescription)) {
                return i;
            }
        }
        return -1;
    }

    private static String joinString(
            Iterable<? extends CharSequence> s, String delimiter, boolean delimiterAtEnd) {
        Iterator<? extends CharSequence> iter = s.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        if (delimiterAtEnd) {
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private MediaConstraints offerOrAnswerConstraint() {
        MediaConstraints mediaConstraints = new MediaConstraints();
        ArrayList<MediaConstraints.KeyValuePair> keyValuePairs = new ArrayList<>();
        keyValuePairs.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));

        //add by huzhiquan test
        keyValuePairs.add(new MediaConstraints.KeyValuePair("echoCancellation", "true"));
        keyValuePairs.add(new MediaConstraints.KeyValuePair("googEchoCancellation", "true"));
        keyValuePairs.add(new MediaConstraints.KeyValuePair("googAutoGainControl", "true"));
        keyValuePairs.add(new MediaConstraints.KeyValuePair("googAutoGainControl2", "true"));
        keyValuePairs.add(new MediaConstraints.KeyValuePair("googNoiseSuppression", "true"));
        keyValuePairs.add(new MediaConstraints.KeyValuePair("googHighpassFilter", "true"));
        keyValuePairs.add(new MediaConstraints.KeyValuePair("googTypingNoiseDetection", "true"));
        //end

        if (JimipttConfig.getRootEglbase() == null || !isVideo){
            keyValuePairs.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", String.valueOf(false)));
        } else {
            keyValuePairs.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", String.valueOf(true)));
        }
        mediaConstraints.mandatory.addAll(keyValuePairs);
        return mediaConstraints;
    }

    private void sendTrickleCandidate(IceCandidate candidate) {
        try {
            JSONObject message = new JSONObject();
            JSONObject cand = new JSONObject();
            if (candidate == null)
                cand.put("completed", true);
            else {
                cand.put("candidate", candidate.sdp);
                cand.put("sdpMid", candidate.sdpMid);
                cand.put("sdpMLineIndex", candidate.sdpMLineIndex);
            }
            message.put("candidate", cand);

            server.sendMessage(message, JanusMessageType.trickle, id);
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
    }

    private void sendSdp(IPluginHandleWebRTCCallbacks callbacks) {
        if (mySdp != null) {
            mySdp = pc.getLocalDescription();
            if (!sdpSent) {
                sdpSent = true;
                try {
                    JSONObject obj = new JSONObject();
                    obj.put("sdp", mySdp.description);
                    obj.put("type", mySdp.type.canonicalForm());
                    callbacks.onSuccess(obj);
                } catch (JSONException ex) {
                    callbacks.onCallbackError(ex.getMessage());
                }
            }
        }
    }

    private class WebRtcObserver implements SdpObserver, PeerConnection.Observer {
        private final IPluginHandleWebRTCCallbacks webRtcCallbacks;
        public WebRtcObserver(IPluginHandleWebRTCCallbacks callbacks) {
            this.webRtcCallbacks = callbacks;
        }

        @Override
        public void onSetSuccess() {
            LogUtil.d("On Set Success");
            if (mySdp == null) {
                createAnswer(webRtcCallbacks);
            }
        }

        @Override
        public void onSetFailure(String error) {
            LogUtil.d("On set Failure");
            //todo JS api does not account for this
            webRtcCallbacks.onCallbackError(error);
        }

        @Override
        public void onCreateSuccess(SessionDescription sdp) {
            LogUtil.d("Create success");
            onLocalSdp(sdp, webRtcCallbacks);
        }

        @Override
        public void onCreateFailure(String error) {
            LogUtil.d("Create failure");
            webRtcCallbacks.onCallbackError(error);
        }

        @Override
        public void onSignalingChange(PeerConnection.SignalingState state) {
            LogUtil.d("Signal change " + state.toString());
            switch (state) {
                case STABLE:
                    break;
                case HAVE_LOCAL_OFFER:
                    break;
                case HAVE_LOCAL_PRANSWER:
                    break;
                case HAVE_REMOTE_OFFER:
                    break;
                case HAVE_REMOTE_PRANSWER:
                    break;
                case CLOSED:
                    break;
            }
        }

        @Override
        public void onIceConnectionChange(PeerConnection.IceConnectionState state) {
            LogUtil.d("Ice Connection change " + state.toString());
            switch (state) {
                case DISCONNECTED:
                    iJanusPluginCallbacks.onIceConnectionChange("IceDisconnected");
                    break;
                case CONNECTED:
                    iJanusPluginCallbacks.onIceConnectionChange("IceConnected");
                    break;
                case NEW:
                    iJanusPluginCallbacks.onIceConnectionChange("IceNew");
                    break;
                case CHECKING:
                    iJanusPluginCallbacks.onIceConnectionChange("IceChecking");
                    break;
                case CLOSED:
                    iJanusPluginCallbacks.onIceConnectionChange("IceClosed");
                    break;
                case FAILED:
                    iJanusPluginCallbacks.onIceConnectionChange("IceFailed");
                    break;
                default:
                    break;
            }
        }

        @Override
        public void onIceConnectionReceivingChange(boolean b) {

        }

        @Override
        public void onIceGatheringChange(PeerConnection.IceGatheringState state) {
            switch (state) {
                case NEW:
                    break;
                case GATHERING:
                    break;
                case COMPLETE:
                    if(!trickle) {
                        mySdp = pc.getLocalDescription();
                        sendSdp(webRtcCallbacks);
                    } else {
                        sendTrickleCandidate(null);
                    }
                    break;
                default:
                    break;
            }
            LogUtil.d("Ice Gathering " + state.toString());
        }

        @Override
        public void onIceCandidate(IceCandidate candidate) {
            //忽略loopback网络
            if(candidate.sdp.contains("127.0.0.1")){
                return;
            }
            if(trickle){
                sendTrickleCandidate(candidate);
            }
        }

        @Override
        public void onIceCandidatesRemoved(IceCandidate[] iceCandidates) {

        }

        @Override
        public void onAddStream(MediaStream stream) {
            onRemoteStream(stream);
        }

        @Override
        public void onRemoveStream(MediaStream stream) {
            LogUtil.d("onRemoveStream");
        }

        @Override
        public void onDataChannel(DataChannel channel) {
            LogUtil.d("onDataChannel");
        }

        @Override
        public void onRenegotiationNeeded() {
            LogUtil.d("Renegotiation needed");
        }

        @Override
        public void onAddTrack(RtpReceiver rtpReceiver, MediaStream[] mediaStreams) {

        }
    }
}
