package com.jimi.jimitalk.ptt.api;

import android.content.Context;

import com.jimi.jimitalk.bean.UserBean;

import org.json.JSONObject;
import org.webrtc.MediaStream;

public class VideoRoomController {
    private static VideoRoomController instance = null;
    private JanusVideoRoomPlugin plugin;

    private int room;
    private int remoteId;
    private boolean isAudio;

    public boolean isVideo() {
        return isVideo;
    }

    private boolean isVideo;

    private VideoRoomController(String userName, int userId) {
        plugin = new JanusVideoRoomPlugin(userName, userId);
        registerMessageCallbacks(new VideoRoomMessageCallback());
    }

    public static VideoRoomController getInstance() {
        if (instance == null) {
            synchronized (VideoRoomController.class){
                if (instance == null) {
                    instance = new VideoRoomController(UserBean.getInstance().getNickName(), UserBean.getInstance().getUid());
                }
            }
        }

        return instance;
    }

    public static void close() {
        JanusSessionController.getInstance().userCall(
                UserBean.getInstance().getUid(),
                UserBean.getInstance().getNickName(),
                VideoRoomController.getInstance().getRemoteId(),
                "vss",
                false,
                103,
                "UE exits application"
        );

        if (instance != null) {
            instance = null;
        }
    }

    public JanusVideoRoomPlugin getPlugin() {
        return plugin;
    }

    public boolean isConnected() {
        return plugin.isConnected();
    }

    public void registerMessageCallbacks(IJanusPluginMessageCallbacks callbacks) {
        plugin.registerMessageCallbacks(callbacks);
    }

    public void unregisterMessageCallbacks(IJanusPluginMessageCallbacks callback) {
        plugin.unregisterMessageCallbacks(callback);
    }

    public void createPeerConnectionFactory(Context context, boolean isAudio, boolean isVideo){
        plugin.createPeerConnectionFactory(context, isAudio, isVideo);
    }

    public void joinRoom(int roomId, String participantType, String userName, int userId, boolean isAudio, boolean isVideo) {
        this.isAudio = isAudio;
        this.isVideo = isVideo;
        plugin.joinRoom(roomId,participantType,userName,userId);
    }

    public void leaveRoom() {
        plugin.leaveRoom();
    }

    public int getRemoteId() {
        return remoteId;
    }

    public void setRemoteId(int remoteId) {
        this.remoteId = remoteId;
    }

    public class VideoRoomMessageCallback implements IJanusPluginMessageCallbacks {

        @Override
        public void onMessage(JSONObject msg, JSONObject jsep) {
            try {
                if (msg.getString("vssroom").equals("joined")) {
                    plugin.publish(isAudio, isVideo);
                }

                if (msg.getString("vssroom").equals("event")) {
                    if (msg.has("leaving")) {
                        if (msg.getString("leaving").equals("ok")) {
                            VideoRoomController.getInstance().getPlugin().destroy();
                            JanusSessionController.getInstance().attach(VideoRoomController.getInstance().getPlugin());
                        }
                    }
                }

                if (msg.getString("vssroom").equals("destroyed")) {
                    VideoRoomController.getInstance().getPlugin().destroy();
                    JanusSessionController.getInstance().attach(VideoRoomController.getInstance().getPlugin());
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onSetLocalStream(MediaStream stream) {

        }

        @Override
        public void onAddRemoteStream(MediaStream stream) {

        }
    }
}
