package com.jimi.jimitalk.ptt.api;

import android.content.Context;

import com.jimi.jimitalk.bean.UserBean;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.MediaStream;

import java.util.LinkedList;

public class VideoCallController {
    private LinkedList<MyControlCallBack> callbacks = new LinkedList<>();
    private static VideoCallController instance = null;

    private IJanusPluginMessageCallbacks messageCallbacks;

    private JanusVideoCallPlugin plugin;
    private boolean isVideo;

    private VideoCallController(String userName, int userId){
        plugin = new JanusVideoCallPlugin(userName, userId);
        this.messageCallbacks = new VideoCallMessageCallback();

        registerMessageCallbacks(messageCallbacks);
    }

    public static VideoCallController getInstance() {
        if (instance == null){
            synchronized (VideoCallController.class){
                if (instance == null){
                    instance = new VideoCallController(UserBean.getInstance().getNickName(), UserBean.getInstance().getUid());
                }
            }
        }

        return instance;
    }

    public static void close() {
        if (instance != null) {
            instance = null;
        }
    }

    public JanusVideoCallPlugin getPlugin() {
        return plugin;
    }

    public void registerMyControlCallBack(MyControlCallBack callback) {
        if (!callbacks.contains(callback)) {
            callbacks.add(callback);
        }
    }

    public void unregisterMyControlCallBack(MyControlCallBack callback) {
        callbacks.remove(callback);
    }

    public void registerMessageCallbacks(IJanusPluginMessageCallbacks callbacks) {
        plugin.registerMessageCallbacks(callbacks);
    }

    public void unregisterMessageCallbacks(IJanusPluginMessageCallbacks callback) {
        plugin.unregisterMessageCallbacks(callback);
    }

    public void sendUserCall(int remoteId, int type, boolean isVideo, int isAccept){
        this.isVideo = isVideo;

        plugin.sendUserCall(remoteId, type, isVideo, isAccept);
    }

    public void createPeerConnectionFactory(Context context, boolean isAudio, boolean isVideo) {
        plugin.createPeerConnectionFactory(context, isAudio, isVideo);
    }

    public void call(String remoteName, boolean isVideo){
        plugin.call(remoteName, isVideo);
    }

    public void accept(boolean isVideo) {
        plugin.accept(isVideo);
    }

    public void switchCamera() {
        plugin.switchCamera();
    }

    public boolean isConnected(){
        return plugin.isConnected();
    }

    public void closeRtc() {
        plugin.closeRtc();
    }

    public void hangup() {
        plugin.hangup();
    }

    public boolean isVideo() {
        return isVideo;
    }

    public class VideoCallMessageCallback implements IJanusPluginMessageCallbacks {

        @Override
        public void onMessage(JSONObject object, JSONObject jsep) {
            if (!callbacks.isEmpty()) {
                for (MyControlCallBack callback : callbacks) {
                    callback.showMessage(object, null);
                }
            }

            try {
                if (object.has("result")) {
                    JSONObject jsonResult = object.getJSONObject("result");

                    if (jsonResult.has("event") && jsonResult.getString("event").equals("accepted")) {
                        // Check UE is running VSS and should stop VSS if video call incoming.
                        if (VideoRoomController.getInstance().isConnected()
                                && VideoRoomController.getInstance().isVideo()
                                && isVideo)
                        {
                            JanusSessionController.getInstance().userCall(
                                    UserBean.getInstance().getUid(),
                                    UserBean.getInstance().getNickName(),
                                    VideoRoomController.getInstance().getRemoteId(),
                                    "vss",
                                    false,
                                    102,
                                    "UE will run VideoCall, should stop VSS"
                            );
                            VideoRoomController.getInstance().leaveRoom();
                        }
                    }
                }
            } catch (JSONException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void onSetLocalStream(MediaStream stream) {
//            if (callback != null) {
//                callback.onSetLocalStream(stream);
//            }

            if (!callbacks.isEmpty()) {
                for (MyControlCallBack callback : callbacks) {
                    callback.onSetLocalStream(stream);
                }
            }
        }

        @Override
        public void onAddRemoteStream(MediaStream stream) {
//            if (callback != null) {
//                callback.onAddRemoteStream(stream);
//            }

            if (!callbacks.isEmpty()) {
                for (MyControlCallBack callback : callbacks) {
                    callback.onAddRemoteStream(stream);
                }
            }
        }
    }
}
