package com.jimi.jimitalk.ptt.api;

import com.jimi.jimitalk.R;
import com.jimi.jimitalk.bean.GroupBean;
import com.jimi.jimitalk.bean.TalkMessage;
import com.jimi.jimitalk.bean.UserBean;
import com.jimi.jimitalk.grpc.GrpcConnectionController;
import com.jimi.jimitalk.tools.AppTool;
import com.jimi.jimitalk.tools.DateUtil;
import com.jimi.jimitalk.tools.LogUtil;
import com.jimi.jimitalk.tools.SoundPoolUtils;
import com.jimi.jimitalk.tools.ThreadUtils;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.MediaStream;

/**
 * @author Administrator
 * @date 2020/2/27
 */
public class PocRoomController {
    private static PocRoomController instance = null;

    private String userName;
    private int userId;
    private boolean isTalking = false;

    private JanusPocRoomPlugin plugin;

    private PocRoomController(String userName, int userId) {
        this.userName = userName;
        this.userId = userId;
        this.plugin = new JanusPocRoomPlugin(userName, userId);

        registerMessageCallbacks(new IJanusPluginMessageCallbacks() {
            @Override
            public void onMessage(JSONObject msg, JSONObject jsep) {

                try {
                    if (msg.has("pocroom")) {
                        if (msg.getString("pocroom").equals("attached")) {
                            if (UserBean.getInstance().isTempGroupExisted()) {
                                PocRoomController.getInstance().joinRoom(UserBean.getInstance().getTempGroup().getGroupId());
                            } else {
                                if (UserBean.getInstance().isLockGidExisted()) {
                                    PocRoomController.getInstance().joinRoom(UserBean.getInstance().getLockGid());
                                }
                            }
                        }

                        if (msg.getString("pocroom").equals("untalked")) {
                            if (msg.has("display")) {
                                String talker = msg.getString("display");

                                AppTool.sendBroadcast("jimi", "talkfreed", talker + "");
                            }

                            SoundPoolUtils.play(R.raw.ptt, 0);

                            ThreadUtils.getInstance().getNewCachedThreadPool().execute(() -> storeTalkMessage(msg.toString()));
                        }

                        //{"pocroom":"roomchanged","room":934,"id":8,"participants":[]}
                        if (msg.getString("pocroom").equals("roomchanged")) {
                            if (msg.has("room")) {
                                int roomId = msg.getInt("room");
                                AppTool.sendBroadcast("jimi", "roomchanged", roomId + "");
                            }
                        }

                        if (msg.getString("pocroom").equals("joined")) {
                            //participant joined, notify to refresh
                            if (msg.has("room")) {
                                int roomId = msg.getInt("room");
                                AppTool.sendBroadcast("jimi", "group_member_updated", roomId + "");
                            }
                        }

                        if (msg.getString("pocroom").equals("event")) {
                            if (msg.has("talkfreed")) {
                                if (msg.has("display")) {
                                    String talker = msg.getString("display");
                                    AppTool.sendBroadcast("jimi", "talkfreed", talker + "");
                                }

                                SoundPoolUtils.play(R.raw.ptt, 0);

                                ThreadUtils.getInstance().getNewCachedThreadPool().execute(() -> storeTalkMessage(msg.toString()));
                            }

                            //{"pocroom":"event","room":934,"leaving":213}
                            if (msg.has("leaving")) {
                                //Other participant left, notify to refresh
                                if (msg.has("room")) {
                                    int roomId = msg.getInt("room");
                                    AppTool.sendBroadcast("jimi", "group_member_updated", roomId + "");
                                }
                            }
                        }

                        if (msg.getString("pocroom").equals("talked")) {
                            AppTool.sendBroadcast("jimi", "wakeup_screen", "pocroom");
                            SoundPoolUtils.play(R.raw.ptt, 0);

                            if (msg.has("display")) {
                                String talker = msg.getString("display");
                                AppTool.sendBroadcast("jimi", "talkholder", talker + "");
                            }
                        }

                        if (msg.getString("pocroom").equals("destroyed")) {
                            if (msg.has("room")) {
                                AppTool.sendBroadcast("jimi", "room_destroyed", msg.getInt("room") + "");
                            }

                            // Current group has been destroyed, back to normal locked group after temp group being destroyed
                            // or change to another normal group after normal group being destroyed
                            if (!UserBean.getInstance().isLockGidExisted()) {
                                if (!UserBean.getInstance().getGroups().isEmpty()) {
                                    int newLockGid = UserBean.getInstance().getGroups().get(0).getGroupId();
                                    UserBean.getInstance().setLockGid(newLockGid);
                                    GrpcConnectionController.getInstance().handleSetLockGroupIdBack(UserBean.getInstance().getUid(), newLockGid);

                                    if (UserBean.getInstance().isLockGidExisted()) {
                                        if (PocRoomController.getInstance().isInOneRoom()) {
                                            PocRoomController.getInstance().changeRoom(UserBean.getInstance().getLockGid());
                                        } else {
                                            PocRoomController.getInstance().joinRoom(UserBean.getInstance().getLockGid());
                                        }
                                    }
                                }
                            }
                        }
                    }

                    if (msg.has("error_code")) {
                        LogUtil.e(msg.toString());
                        int error_code = msg.getInt("error_code");
                        switch (error_code) {
                            // {"pocroom":"event","error_code":490,"error":"User ID xxx already exists"}
                            case 490:
                                LogUtil.e(UserBean.getInstance().getLockGid() + "");
                                sendKicksb(UserBean.getInstance().getLockGid(), UserBean.getInstance().getUid());
                                break;
                            // {"pocroom":"event","error_code":495,"error":"user (8) has no right to untalk in room (932)"}
                            // Just indicate no right to talk/untalk, no need to reset room and change

                            // {"pocroom":"event","error_code":491,"error":"Already in a room (use changeroom to join another one)"}
                            // {"pocroom":"event","error_code":491,"error":"Already in this room"}
                            // No need to reset room and change

                            // {"pocroom":"event","error_code":485,"error":"No such room (927)"}
                            case 485:
                            // {"pocroom":"event","error_code":492,"error":"talk failed, No Such User (8) in Room (935)"}
                            case 492:
                                /*current group has been destroyed, change group and reset default group id*/
                                if (!UserBean.getInstance().isLockGidExisted()) {
                                    if (!UserBean.getInstance().getGroups().isEmpty()) {
                                        int newLockGid = UserBean.getInstance().getGroups().get(0).getGroupId();
                                        UserBean.getInstance().setLockGid(newLockGid);
                                        GrpcConnectionController.getInstance().handleSetLockGroupIdBack(UserBean.getInstance().getUid(), newLockGid);

                                        if (UserBean.getInstance().isLockGidExisted()) {
                                            if (PocRoomController.getInstance().isInOneRoom()) {
                                                PocRoomController.getInstance().changeRoom(UserBean.getInstance().getLockGid());
                                            } else {
                                                PocRoomController.getInstance().joinRoom(UserBean.getInstance().getLockGid());
                                            }
                                        }
                                    }
                                }

                                break;
                        }
                    }

                    if (msg.has("ice")) {
                        String ice = msg.getString("ice");

                        if (ice.contains("IceFailed")) {
                            new Thread(new Runnable() {
                                @Override
                                public void run() {
                                    reconnect();
                                }
                            }).start();
                        }
                    }
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void onSetLocalStream(MediaStream stream) {

            }

            @Override
            public void onAddRemoteStream(MediaStream stream) {

            }
        });
    }

    public static PocRoomController getInstance() {
        if (instance == null) {
            synchronized (PocRoomController.class) {
                if (instance == null) {
                    instance = new PocRoomController(UserBean.getInstance().getNickName(), UserBean.getInstance().getUid());
                }
            }
        }

        return instance;
    }

    public static void close() {
        if (instance != null) {
            instance = null;
        }
    }

    public IJanusPlugin getPlugin() {
        return plugin;
    }

    public void registerMessageCallbacks(IJanusPluginMessageCallbacks callback) {
        plugin.registerMessageCallbacks(callback);
    }

    public void unregisterMessageCallbacks(IJanusPluginMessageCallbacks callback) {
        plugin.unregisterMessageCallbacks(callback);
    }

    public void talk(int roomId) {
        isTalking = true;
        plugin.talk(roomId);
    }

    public void untalk(int roomId) {
        isTalking = false;
        plugin.untalk(roomId);
    }

    public void joinRoom(int roomId) {
        plugin.joinRoom(roomId);

        GrpcConnectionController.getInstance().handleSetLockGroupIdBack(UserBean.getInstance().getUid(), roomId);
    }

    public void changeRoom(int roomId){
        plugin.changeRoom(roomId);

        GrpcConnectionController.getInstance().handleSetLockGroupIdBack(UserBean.getInstance().getUid(), roomId);
    }

    public void detach() {
        plugin.destroy();
    }

    public void attach() {
        JanusSessionController.getInstance().attach(PocRoomController.getInstance().getPlugin());
    }

    public void leave() {
        plugin.leave();
    }

    public boolean isInOneRoom() {
        return plugin.isInOneRoom();
    }

    // Only PoC received 'Ice Failed' TODO
    public void reconnect() {
        LogUtil.e("PoC received 'IceFailed', will detach and attach plugin now.");
        PocRoomController.getInstance().detach();
        PocRoomController.getInstance().attach();
    }

    public void sendKicksb(int roomId, int uid) {
        plugin.kick(roomId, uid);
    }

    public boolean isConnected() {
        return plugin.isMediaConnected();
    }

    private static void storeTalkMessage(String msg) {
        String senderName = null;
        int senderId = 0;
        String url = null;
        int receiverId = 0;

        try {
            JSONObject object = new JSONObject(msg);
            if(object.getString("pocroom").equals("event")) {
                if (object.has("talkfreed")) {
                    senderName = object.getString("display");
                    senderId = object.getInt("talkfreed");
                    if (object.has("url")) {
                        url = object.getString("url");
                    }
                    receiverId = object.getInt("room");
                }
            }

            if (object.getString("pocroom").equals("untalked")) {
                senderName = object.getString("display");
                senderId = UserBean.getInstance().getUid();
                if (object.has("url")) {
                    url = object.getString("url");
                }
                receiverId = object.getInt("room");
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (null == url) { //TODO Record time is too short, didn't return URL
            return;
        }

        TalkMessage talkMessage = new TalkMessage();
        talkMessage.setSendName(senderName);
        talkMessage.setSendId(senderId);
        talkMessage.setUri(url);
        talkMessage.setTimestamp(Long.parseLong(DateUtil.timeStamp()));
        talkMessage.setSendTime(DateUtil.timeStamp());
        talkMessage.setReceiverId(receiverId);

        for (GroupBean group : UserBean.getInstance().getGroups()) {
            if (group.getGroupId() == receiverId) {
                group.appendTalkHistory(talkMessage);
                break;
            }
        }

        LogUtil.d(talkMessage.toString());
    }

    public boolean isTalking() {
        return isTalking;
    }
}
