package com.jimi.jimitalk.ptt.api;

import android.content.Context;

import com.jimi.jimitalk.ptt.janusclientapi.IJanusPluginCallbacks;
import com.jimi.jimitalk.ptt.janusclientapi.IPluginHandleWebRTCCallbacks;
import com.jimi.jimitalk.ptt.janusclientapi.JanusMediaConstraints;
import com.jimi.jimitalk.ptt.janusclientapi.JanusPluginHandle;
import com.jimi.jimitalk.ptt.janusclientapi.JanusSupportedPluginPackages;
import com.jimi.jimitalk.ptt.janusclientapi.PluginHandleSendMessageCallbacks;
import com.jimi.jimitalk.tools.JimipttConfig;
import com.jimi.jimitalk.tools.LogUtil;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.MediaStream;

import java.util.LinkedList;

public class JanusVideoRoomPlugin implements IJanusPlugin{
    final String MESSAGE = "message";
    final String REQUEST = "request";

    private JanusPluginHandle handle = null;
    private JanusVSSRoomPluginCallbacks callbacks;
    private LinkedList<IJanusPluginMessageCallbacks> messageCallbacks = new LinkedList<>();

    private boolean isAttached = false;

    public boolean isConnected() {
        return isConnected;
    }

    public void setConnected(boolean connected) {
        isConnected = connected;
    }

    private boolean isConnected = false;

    private JSONObject jsep = null;

    public JanusVideoRoomPlugin(String userName, int userId) {
        this.callbacks = new JanusVSSRoomPluginCallbacks();
    }

    public void registerMessageCallbacks(IJanusPluginMessageCallbacks callbacks) {
        if (!messageCallbacks.contains(callbacks)) {
            messageCallbacks.add(callbacks);
        }
    }

    public void unregisterMessageCallbacks(IJanusPluginMessageCallbacks callback) {
        messageCallbacks.remove(callback);
    }

    public void createPeerConnectionFactory(Context context, boolean isAudio, boolean isVideo){
        handle.createPeerConnectionFactory(context, isAudio, isVideo);
    }

    public void closeWebRtc(){
        handle.hangUp();
    }

    public void joinRoom(int roomId, String participantType, String userName, int userId) {
        if (isAttached) {
            try {
                JSONObject msg = new JSONObject();
                JSONObject body = new JSONObject();
                body.put(REQUEST, "join");
                body.put("room", roomId);
                body.put("display", userName);
                body.put("id", userId);
                body.put("ptype", participantType);
                msg.put(MESSAGE, body);

                if (handle != null) {
                    LogUtil.d("Sent:" + msg.toString());
                    handle.sendMessage(new PluginHandleSendMessageCallbacks(msg) {
                        @Override
                        public void onSuccessSynchronous(JSONObject obj) {

                        }

                        @Override
                        public void onSuccessAsynchronous() {

                        }

                        @Override
                        public JSONObject getMessage() {
                            return msg;
                        }

                        @Override
                        public void onCallbackError(String error) {

                        }
                    });
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void configure(boolean isAudio, boolean isVideo) {
        try {
            JSONObject msg = new JSONObject();
            JSONObject body = new JSONObject();
            body.put(REQUEST, "configure");
            body.put("audio", isAudio);
            body.put("video", isVideo);
            msg.put(MESSAGE, body);

            if (handle != null) {
                LogUtil.d("Sent:" + msg.toString());
                handle.sendMessage(new PluginHandleSendMessageCallbacks(msg) {
                    @Override
                    public void onSuccessSynchronous(JSONObject obj) {
                        LogUtil.d(obj.toString());
                    }

                    @Override
                    public void onSuccessAsynchronous() {

                    }

                    @Override
                    public JSONObject getMessage() {
                        return msg;
                    }

                    @Override
                    public void onCallbackError(String error) {
                        LogUtil.e(error);
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void publish(boolean isAuido, boolean isVideo) {
        LogUtil.e("JanusVideoRoomPlugin isAuido=" + isAuido + " isVideo=" + isVideo);
        createPeerConnectionFactory(JimipttConfig.getAppContext(), isAuido, isVideo);

        if (handle != null) {
            handle.createPeerConnection(new IPluginHandleWebRTCCallbacks() {
                @Override
                public void onSuccess(JSONObject obj) {
                    try {
                        JSONObject msg = new JSONObject();
                        JSONObject body = new JSONObject();
                        body.put(REQUEST, "publish");
                        body.put("audio", isAuido);
                        body.put("video", isVideo);
                        msg.put(MESSAGE, body);
                        msg.put("jsep", obj);

                        LogUtil.d("Sent:" + msg.toString());
                        handle.sendMessage(new PluginHandleSendMessageCallbacks(msg) {
                            @Override
                            public void onSuccessSynchronous(JSONObject obj) {
                                LogUtil.d(obj.toString());
                            }

                            @Override
                            public void onSuccessAsynchronous() {
                                LogUtil.d("publish onSuccessAsynchronous");
                            }

                            @Override
                            public JSONObject getMessage() {
                                return msg;
                            }

                            @Override
                            public void onCallbackError(String error) {
                                LogUtil.e(error);
                            }
                        });
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public JSONObject getJsep() {
                    return null;
                }

                @Override
                public JanusMediaConstraints getMedia() {
                    JanusMediaConstraints constraints = new JanusMediaConstraints();
                    constraints.setSendVideo(isVideo);
                    constraints.setSendAudio(isAuido);
                    constraints.setRecvVideo(false);
                    constraints.setRecvAudio(false);
                    constraints.setCamera(JanusMediaConstraints.Camera.back);
                    return constraints;
                }

                @Override
                public Boolean getTrickle() {
                    return true;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtil.e(error);
                }
            });
        }
    }

    public void unpublish() {
        try {
            JSONObject msg = new JSONObject();
            JSONObject body = new JSONObject();
            body.put(REQUEST, "unpublish");
            msg.put(MESSAGE, body);

            if (handle != null) {
                LogUtil.d("Sent:" + msg.toString());
                handle.sendMessage(new PluginHandleSendMessageCallbacks(msg) {
                    @Override
                    public void onSuccessSynchronous(JSONObject obj) {

                    }

                    @Override
                    public void onSuccessAsynchronous() {

                    }

                    @Override
                    public JSONObject getMessage() {
                        return msg;
                    }

                    @Override
                    public void onCallbackError(String error) {

                    }
                });
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void leaveRoom() {
        try {
            JSONObject msg = new JSONObject();
            JSONObject body = new JSONObject();
            body.put(REQUEST, "leave");
            msg.put(MESSAGE, body);

            if (handle != null) {
                LogUtil.d("Sent:" + msg.toString());
                handle.sendMessage(new PluginHandleSendMessageCallbacks(msg) {
                    @Override
                    public void onSuccessSynchronous(JSONObject obj) {
                        LogUtil.d(obj.toString());
                    }

                    @Override
                    public void onSuccessAsynchronous() {

                    }

                    @Override
                    public JSONObject getMessage() {
                        return msg;
                    }

                    @Override
                    public void onCallbackError(String error) {
                        LogUtil.e(error);
                    }
                });
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IJanusPluginCallbacks callbacks() {
        return callbacks;
    }

    @Override
    public void destroy() {
        if (handle != null) {
            handle.detach();
        }
    }

    public class JanusVSSRoomPluginCallbacks implements IJanusPluginCallbacks {
        @Override
        public void success(JanusPluginHandle janusPluginHandle) {
            LogUtil.i("VideoRoom plugin attached!");

            handle = janusPluginHandle;

            isAttached = true;
        }

        @Override
        public void onMessage(JSONObject msg, JSONObject jsep) {
            if (!messageCallbacks.isEmpty()) {
                for (IJanusPluginMessageCallbacks callback : messageCallbacks) {
                    callback.onMessage(msg, jsep);
                }
            }

            try {
                if(jsep != null && jsep.getString("type").equals("answer")) {
                    if (handle != null) {
                        handle.JanusSetRemoteDescription(new IPluginHandleWebRTCCallbacks() {
                            final JSONObject myJsep = jsep;

                            @Override
                            public void onSuccess(JSONObject obj) {
                                LogUtil.d(obj.toString());
                            }

                            @Override
                            public JSONObject getJsep() {
                                return myJsep;
                            }

                            @Override
                            public JanusMediaConstraints getMedia() {
                                JanusMediaConstraints cons = new JanusMediaConstraints();
                                cons.setRecvAudio(false);
                                cons.setRecvVideo(false);
                                cons.setSendAudio(true);
                                cons.setSendVideo(true);
                                cons.setCamera(JanusMediaConstraints.Camera.back);
                                return cons;
                            }

                            @Override
                            public Boolean getTrickle() {
                                return true;
                            }

                            @Override
                            public void onCallbackError(String error) {
                                LogUtil.e(error);
                            }
                        }, false);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onLocalStream(MediaStream stream) {
            if (!messageCallbacks.isEmpty()) {
                for (IJanusPluginMessageCallbacks callback : messageCallbacks) {
                    callback.onSetLocalStream(stream);
                }
            }
        }

        @Override
        public void onRemoteStream(MediaStream stream) {
            if (!messageCallbacks.isEmpty()) {
                for (IJanusPluginMessageCallbacks callback : messageCallbacks) {
                    callback.onAddRemoteStream(stream);
                }
            }
        }

        @Override
        public void onDataOpen(Object data) {
            LogUtil.d(data.toString());
        }

        @Override
        public void onData(Object data) {
            LogUtil.d(data.toString());
        }

        @Override
        public void onCleanup() {

        }

        @Override
        public void onDetached() {
            isConnected = false;
            isAttached = false;
        }

        @Override
        public void onIceConnectionChange(String msg) {
            LogUtil.d(msg);

            if(msg.contains("IceFailed")){
                isConnected = false;
            }

            if(msg.contains("IceDisconnected")){
                isConnected = false;
            }

            if(msg.contains("IceConnected")){
                isConnected = true;
            }

            if (msg.contains("IceClosed")){
                isConnected = false;
            }
        }

        @Override
        public JanusSupportedPluginPackages getPlugin() {
            return JanusSupportedPluginPackages.JANUS_VSS_ROOM;
        }

        @Override
        public void onCallbackError(String error) {
            LogUtil.e(error);
        }
    }
}
