package com.jimi.jimitalk.ptt.api;

import android.content.Context;

import com.jimi.jimitalk.ptt.janusclientapi.IJanusPluginCallbacks;
import com.jimi.jimitalk.ptt.janusclientapi.IPluginHandleWebRTCCallbacks;
import com.jimi.jimitalk.ptt.janusclientapi.JanusMediaConstraints;
import com.jimi.jimitalk.ptt.janusclientapi.JanusPluginHandle;
import com.jimi.jimitalk.ptt.janusclientapi.JanusSupportedPluginPackages;
import com.jimi.jimitalk.ptt.janusclientapi.PluginHandleSendMessageCallbacks;
import com.jimi.jimitalk.tools.LogUtil;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.MediaStream;

import java.util.LinkedList;

public class JanusVideoCallPlugin implements IJanusPlugin {
    final String MESSAGE = "message";
    final String REQUEST = "request";

    private LinkedList<IJanusPluginMessageCallbacks> messageCallbacks = new LinkedList<>();
    private JSONObject remoteJsep;

    private JanusVideoCallPluginCallbacks callbacks;
    private JanusPluginHandle handle = null;
    private String userName;
    private int userId;

    private boolean isConnected;
    private boolean isAttached;

    public JanusVideoCallPlugin(String userName, int userId) {
        this.userName = userName;
        this.userId = userId;
        this.isConnected = false;
        this.isAttached = false;
        this.callbacks = new JanusVideoCallPluginCallbacks();
    }

    public void registerMessageCallbacks(IJanusPluginMessageCallbacks callback) {
        if (!messageCallbacks.contains(callback)) {
            messageCallbacks.add(callback);
        }
    }

    public void unregisterMessageCallbacks(IJanusPluginMessageCallbacks callback) {
        messageCallbacks.remove(callback);
    }

    public void createPeerConnectionFactory(Context context, boolean isAudio, boolean isVideo){
        if (handle != null) {
            handle.createPeerConnectionFactory(context, isAudio, isVideo);
        }
    }

    public void closeRtc(){
        isConnected = false;
        if (handle != null) {
            handle.hangUp();
        }
    }

    public void switchCamera() {
        if (handle != null) {
            handle.switchCamera();
        }
    }

    public void sendUserCall(int remoteId,int type,boolean isVideo,int isAccept) {
        if (handle != null) {
            handle.sendUserCall(userId, userName, remoteId, type, isVideo, isAccept);
        }
    }

    public void list() {
        try {
            JSONObject msg = new JSONObject();
            JSONObject body = new JSONObject();
            body.put(REQUEST, "list");
            msg.put(MESSAGE, body);

            if (handle != null) {
                LogUtil.d("Sent:" + msg.toString());
                handle.sendMessage(new PluginHandleSendMessageCallbacks(msg) {
                    @Override
                    public void onSuccessSynchronous(JSONObject obj) {
                        LogUtil.d(obj.toString());

                        if (!messageCallbacks.isEmpty()) {
                            for (IJanusPluginMessageCallbacks callback : messageCallbacks) {
                                callback.onMessage(obj, null);
                            }
                        }
                    }

                    @Override
                    public void onSuccessAsynchronous() {

                    }

                    @Override
                    public JSONObject getMessage() {
                        return msg;
                    }

                    @Override
                    public void onCallbackError(String error) {
                        LogUtil.e(error);
                    }
                });
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void register() {
        try {
            JSONObject msg = new JSONObject();
            JSONObject body = new JSONObject();
            body.put(REQUEST, "register");
            body.put("username", userId+"");
            msg.put(MESSAGE, body);

            if (handle != null) {
                LogUtil.d("Sent:" + msg.toString());
                handle.sendMessage(new PluginHandleSendMessageCallbacks(msg) {
                    @Override
                    public void onSuccessSynchronous(JSONObject obj) {
                        LogUtil.d(obj.toString());
                    }

                    @Override
                    public void onSuccessAsynchronous() {

                    }

                    @Override
                    public JSONObject getMessage() {
                        return msg;
                    }

                    @Override
                    public void onCallbackError(String error) {
                        LogUtil.e(error);
                    }
                });
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void call(String remoteName, boolean isVideo) {
        if (handle != null) {
            handle.createPeerConnection(new IPluginHandleWebRTCCallbacks() {
                @Override
                public void onSuccess(JSONObject obj) {
                    try {
                        JSONObject msg = new JSONObject();
                        JSONObject body = new JSONObject();
                        body.put(REQUEST, "call");
                        body.put("username", remoteName);
                        msg.put(MESSAGE, body);
                        msg.put("jsep", obj);

                        LogUtil.d("Sent:" + msg);
                        handle.sendMessage(new PluginHandleSendMessageCallbacks(msg) {
                            @Override
                            public void onSuccessSynchronous(JSONObject obj) {
                                LogUtil.d(obj.toString());
                            }

                            @Override
                            public void onSuccessAsynchronous() {

                            }

                            @Override
                            public JSONObject getMessage() {
                                return msg;
                            }

                            @Override
                            public void onCallbackError(String error) {
                                LogUtil.e(error);
                            }
                        });
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }

                @Override
                public JSONObject getJsep() {
                    return null;
                }

                @Override
                public JanusMediaConstraints getMedia() {
                    JanusMediaConstraints cons = new JanusMediaConstraints();
                    cons.setRecvAudio(true);
                    cons.setRecvVideo(isVideo);
                    cons.setSendAudio(true);
                    cons.setSendVideo(isVideo);
                    return cons;
                }

                @Override
                public Boolean getTrickle() {
                    return true;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtil.e(error);
                }
            });
        }
    }

    public void accept(boolean isVideo) {
        if (handle != null) {
            handle.createPeerConnection(new IPluginHandleWebRTCCallbacks() {
                @Override
                public void onSuccess(JSONObject obj) {
                    LogUtil.d(obj.toString());

                    if (!messageCallbacks.isEmpty()) {
                        for (IJanusPluginMessageCallbacks callback : messageCallbacks) {
                            callback.onMessage(obj, null);
                        }
                    }

                    try {
                        JSONObject msg = new JSONObject();
                        JSONObject body = new JSONObject();
                        body.put(REQUEST, "accept");
                        msg.put(MESSAGE, body);
                        msg.put("jsep", obj);

                        LogUtil.d("Sent:" + msg);
                        handle.sendMessage(new PluginHandleSendMessageCallbacks(msg) {
                            @Override
                            public void onSuccessSynchronous(JSONObject obj) {
                                LogUtil.d(obj.toString());
                                if (!messageCallbacks.isEmpty()) {
                                    for (IJanusPluginMessageCallbacks callback : messageCallbacks) {
                                        callback.onMessage(obj, null);
                                    }
                                }
                            }

                            @Override
                            public void onSuccessAsynchronous() {
                            }

                            @Override
                            public JSONObject getMessage() {
                                return msg;
                            }

                            @Override
                            public void onCallbackError(String error) {
                                LogUtil.e(error);
                            }
                        });
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }

                @Override
                public JSONObject getJsep() {
                    return remoteJsep;
                }

                @Override
                public JanusMediaConstraints getMedia() {
                    JanusMediaConstraints cons = new JanusMediaConstraints();
                    cons.setRecvAudio(true);
                    cons.setRecvVideo(isVideo);
                    cons.setSendAudio(true);
                    cons.setSendVideo(isVideo);
                    return cons;
                }

                @Override
                public Boolean getTrickle() {
                    return true;
                }

                @Override
                public void onCallbackError(String error) {
                    LogUtil.e(error);
                }
            });
        }
    }

    public void set(boolean audio, boolean video, int bitrate, boolean record, String recordFileName) {
        try {
            JSONObject msg = new JSONObject();
            JSONObject body = new JSONObject();
            body.put(REQUEST, "set");
            body.put("video", video);
            body.put("audio", audio);
            body.put("bitrate", bitrate);
            body.put("record", record);
            body.put("filename", recordFileName);
            msg.put(MESSAGE, body);

            if (handle != null) {
                LogUtil.d("Sent:" + msg.toString());
                handle.sendMessage(new PluginHandleSendMessageCallbacks(msg) {
                    @Override
                    public void onSuccessSynchronous(JSONObject obj) {
                        LogUtil.d(obj.toString());
                        if (!messageCallbacks.isEmpty()) {
                            for (IJanusPluginMessageCallbacks callback : messageCallbacks) {
                                callback.onMessage(obj, null);
                            }
                        }
                    }

                    @Override
                    public void onSuccessAsynchronous() {

                    }

                    @Override
                    public JSONObject getMessage() {
                        return msg;
                    }

                    @Override
                    public void onCallbackError(String error) {
                        LogUtil.e(error);
                    }
                });
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void hangup() {
        try {
            JSONObject msg = new JSONObject();
            JSONObject body = new JSONObject();
            body.put(REQUEST, "hangup");
            msg.put(MESSAGE, body);

            if (handle != null) {
                LogUtil.d("Sent:" + msg.toString());
                handle.sendMessage(new PluginHandleSendMessageCallbacks(msg) {
                    @Override
                    public void onSuccessSynchronous(JSONObject obj) {
                        LogUtil.d(obj.toString());
                        if (!messageCallbacks.isEmpty()) {
                            for (IJanusPluginMessageCallbacks callback : messageCallbacks) {
                                callback.onMessage(obj, null);
                            }
                        }
                    }

                    @Override
                    public void onSuccessAsynchronous() {

                    }

                    @Override
                    public JSONObject getMessage() {
                        return msg;
                    }

                    @Override
                    public void onCallbackError(String error) {
                        LogUtil.e(error);
                    }
                });
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public boolean isConnected() {
        return isConnected;
    }

    public void setConnected(boolean connected) {
        isConnected = connected;
    }

    @Override
    public IJanusPluginCallbacks callbacks() {
        return callbacks;
    }

    @Override
    public void destroy() {
        if (handle != null) {
            handle.detach();
        }
    }

    public class JanusVideoCallPluginCallbacks implements IJanusPluginCallbacks {

        @Override
        public void success(JanusPluginHandle pluginHandle) {
            LogUtil.i("VideoCall plugin attached!");

            handle = pluginHandle;

            register();
        }

        @Override
        public void onMessage(JSONObject msg, JSONObject jsepLocal) {
            LogUtil.i("msg=" + msg + " jsepLocal=" + jsepLocal);

            if (!messageCallbacks.isEmpty()) {
                for (IJanusPluginMessageCallbacks callback : messageCallbacks) {
                    callback.onMessage(msg, jsepLocal);
                }
            }

            try {
                if (jsepLocal != null) {
                    remoteJsep = jsepLocal;
                    if (handle != null) {
                        handle.JanusSetRemoteDescription(new IPluginHandleWebRTCCallbacks() {
                            @Override
                            public void onSuccess(JSONObject obj) {
                                LogUtil.d(obj.toString());
                            }

                            @Override
                            public JSONObject getJsep() {
                                return jsepLocal;
                            }

                            @Override
                            public JanusMediaConstraints getMedia() {
                                return null;
                            }

                            @Override
                            public Boolean getTrickle() {
                                return null;
                            }

                            @Override
                            public void onCallbackError(String error) {
                                LogUtil.e(error);
                            }
                        }, true);
                    }
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void onLocalStream(MediaStream stream) {
            if (!messageCallbacks.isEmpty()) {
                for (IJanusPluginMessageCallbacks callback : messageCallbacks) {
                    callback.onSetLocalStream(stream);
                }
            }
        }

        @Override
        public void onRemoteStream(MediaStream stream) {
            if (!messageCallbacks.isEmpty()) {
                for (IJanusPluginMessageCallbacks callback : messageCallbacks) {
                    callback.onAddRemoteStream(stream);
                }
            }
        }

        @Override
        public void onDataOpen(Object data) {
            LogUtil.d(data.toString());
        }

        @Override
        public void onData(Object data) {
            LogUtil.d(data.toString());
        }

        @Override
        public void onCleanup() {

        }

        @Override
        public JanusSupportedPluginPackages getPlugin() {
            return JanusSupportedPluginPackages.JANUS_VIDEO_CALL;
        }

        @Override
        public void onCallbackError(String error) {
            LogUtil.e(error);
        }

        @Override
        public void onDetached() {
        }

        @Override
        public void onIceConnectionChange(String msg) {
            LogUtil.d(msg);

            if(msg.contains("IceFailed")){
                isConnected = false;
            }

            if(msg.contains("IceDisconnected")){
                isConnected = false;
            }

            if(msg.contains("IceConnected")){
                isConnected = true;
            }

            if (msg.contains("IceClosed")){
                isConnected = false;
            }
        }
    }
}
