package com.jimi.jimitalk.ptt.api;

import android.content.Intent;

import com.jimi.jimitalk.activity.VideoCallActivity;
import com.jimi.jimitalk.bean.UserBean;
import com.jimi.jimitalk.tools.AppTool;
import com.jimi.jimitalk.tools.JimipttConfig;
import com.jimi.jimitalk.tools.SPUtil;

import org.json.JSONException;
import org.json.JSONObject;

public class JanusSessionController {
    private static JanusSessionController instance = null;

    private String serverUri;
    private int uid;
    private JanusSession session;

    private JanusSessionController(String serverUri, int uid) {
        this.serverUri = serverUri;
        this.uid = uid;
        this.session = new JanusSession(serverUri, uid);
        session.registerMessageCallbacks(new JanusSessionMessageCallbacks());
    }

    // Make parameters configurable TODO
    public static JanusSessionController getInstance() {
        if (instance == null) {
            synchronized (JanusSessionController.class) {
                if (instance == null) {
                    instance = new JanusSessionController("ws://" + SPUtil.getServer() + ":" + SPUtil.getWebrtcPort(), UserBean.getInstance().getUid());
                }
            }
        }

        return instance;
    }

    public static void close() {
        instance.session.setShutdown(true);
        instance.session.disconnect();

        if (instance != null) {
            instance = null;
        }
    }

    public void reconnect() {
        session.reconnect();
    }

    public void connect() {
        session.connect();
    }

    public void attach(IJanusPlugin plugin) {
        session.attach(plugin);
    }

    public void registerPlugin(IJanusPlugin plugin) {
        session.register(plugin);
    }

    public boolean isConnected() {
        return session.isConnected();
    }

    public void registerMessageCallbacks(IJanusSessionMessageCallbacks callbacks) {
        session.registerMessageCallbacks(callbacks);
    }

    public void unregisterMessageCallbacks(IJanusSessionMessageCallbacks callbacks) {
        session.unregisterMessageCallbacks(callbacks);
    }

    public void userCall(int myId, String myName, int remoteId, String plugin, boolean connect, int reason_code, String reason) {
        session.userCall(myId, myName, remoteId, plugin, connect, reason_code, reason);
    }

    public class JanusSessionMessageCallbacks implements IJanusSessionMessageCallbacks {

        @Override
        public void onMessage(JSONObject object) {
            try {
                if (object.getString("janus").equals("user_call")) {
                    JSONObject remoteUserInfo = object.getJSONObject("user_info");
                    int remoteId = remoteUserInfo.getInt("user_id");
                    String remoteName = remoteUserInfo.getString("display");

                    JSONObject janusExt = object.getJSONObject("janus_ext");
                    String plugin = janusExt.getString("name");

                    if (plugin.equals("vss")) {
                        int vssroom = janusExt.getInt("vssroom");
                        boolean connect = janusExt.getBoolean("connect");

                        boolean isAudioMonitor = true;
                        boolean isVideoMonitor = false;
                        if (janusExt.has("audio")) {
                            isAudioMonitor = janusExt.getBoolean("audio");
                        }
                        if (janusExt.has("video")) {
                            isVideoMonitor = janusExt.getBoolean("video");
                        }

                        if (connect) {
                            // Check UE is running video call that could not run VSS if result is TRUE.
                            if (isVideoMonitor
                                    && VideoCallController.getInstance().isConnected()
                                    && VideoCallController.getInstance().isVideo())
                            {
                                //Send tips TODO
                                JanusSessionController.getInstance().userCall(
                                        UserBean.getInstance().getUid(),
                                        UserBean.getInstance().getNickName(),
                                        remoteId,
                                        "vss",
                                        false,
                                        101,
                                        "UE is running VideoCall, could not receive VSS"
                                );
                            } else {
                                VideoRoomController.getInstance().joinRoom(
                                        vssroom,
                                        "publisher",
                                        UserBean.getInstance().getUid() + "",
                                        UserBean.getInstance().getUid(),
                                        isAudioMonitor,
                                        isVideoMonitor);
                                VideoRoomController.getInstance().setRemoteId(remoteId);
                            }
                        } else {
                            VideoRoomController.getInstance().leaveRoom();
                        }
                    }

                    if (plugin.equals("videocall")) {
                        int type = janusExt.getInt("type");
                        if(0 == type){
                            boolean isVideoCall = janusExt.getBoolean("isVideo");

                            if (VideoCallController.getInstance().isConnected()) {
                                // Current UE is running VideoCall, reject another VideoCall incoming
                                VideoCallController.getInstance().sendUserCall(remoteId, 1, isVideoCall, 4);
                            } else {
                                AppTool.wakeUpAndUnlock(JimipttConfig.getAppContext());

                                Intent intent = new Intent(JimipttConfig.getAppContext(), VideoCallActivity.class);
                                intent.putExtra("isCaller",false);
                                intent.putExtra("isVideo", isVideoCall);
                                intent.putExtra("remoteName", remoteName);
                                intent.putExtra("remoteId", remoteId);
                                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
                                JimipttConfig.getAppContext().startActivity(intent);
                            }
                        }
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}
