package com.jimi.jimitalk.location;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.support.v4.content.ContextCompat;
import android.util.Log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WifiControl {
    private static final String TAG = "WifiControl";

    private WifiManager mWifiManager = null;
    private Context mContext;

    WifiControl(Context context){
        Log.i(TAG, "------WifiControl------");
        mContext = context;
        mWifiManager = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
    }

    public WifiData getConnectedWifiData() {
        WifiData connected = new WifiData();

        WifiInfo info = mWifiManager.getConnectionInfo();
        if (info != null) {
            Log.i(TAG, "this is getConnectedWifiData wifi connected info=" + info.toString());
            connected.setSsid(info.getSSID());
            connected.setRssi(info.getRssi());
            connected.setBssid(info.getBSSID());
        }else {
            Log.i(TAG, "this is getConnectedWifiData no wifi connected");
            connected = null;
        }

        return connected;
    }

    public List<WifiData> getWifiDataArrayList(int topN) {
        List<WifiData> wifiDataArrayList = new ArrayList<>();

        WifiInfo info = mWifiManager.getConnectionInfo();
        if (info != null) {
            Log.i(TAG, "this is location wifi connected info=" + info.toString());
        }else {
            Log.i(TAG, "this is location no wifi connected");
        }

        if (ContextCompat.checkSelfPermission(mContext, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED
                || ContextCompat.checkSelfPermission(mContext, Manifest.permission.ACCESS_COARSE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
            List<ScanResult> scanResults = mWifiManager.getScanResults();

            for (ScanResult scanResult : scanResults) {
                WifiData wifiData = new WifiData();
                wifiData.setSsid(scanResult.SSID);
                wifiData.setBssid(scanResult.BSSID);
                wifiData.setRssi(scanResult.level);

                wifiDataArrayList.add(wifiData);
            }
        }

        for (WifiData wifiData : wifiDataArrayList) {
            Log.d(TAG, "this is wifiControll all wifiData=" + wifiData);
        }

        // Sorted by rssi, get top N.
        Collections.sort(wifiDataArrayList, (WifiData o1, WifiData o2)->{return o2.getRssi() - o1.getRssi();});
        List<WifiData> wifiDataArrayListTopN = new ArrayList<>();
        if (wifiDataArrayList.size() > topN){
            wifiDataArrayListTopN = wifiDataArrayList.subList(0, topN);
        }
        else {
            wifiDataArrayListTopN = wifiDataArrayList;
        }

        for (WifiData wifiData : wifiDataArrayListTopN) {
            Log.i(TAG, "this is wifiControll topN wifiData=" + wifiData);
        }

        return wifiDataArrayListTopN;
    }
}
