package com.jimi.jimitalk.location;

import android.content.Context;
import android.content.pm.PackageManager;
import android.support.v4.content.ContextCompat;
import android.telephony.NeighboringCellInfo;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.util.Log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TelephonyControl {
    private static final String TAG = "TelephonyControl";

    private Context mContext;

    TelephonyControl(Context context){
        Log.i(TAG, "------TelephonyControl------");
        mContext = context;
    }

    /**
     * 获取手机基站信息
     */
    public BaseStationInfo getGSMCellLocationInfo() {
        BaseStationInfo registed = new BaseStationInfo();
        if(!hasSimCard()){
            return registed;
        }

        TelephonyManager manager = (TelephonyManager) mContext.getSystemService(Context.TELEPHONY_SERVICE);
        String operator = manager.getNetworkOperator();
        /**通过operator获取 MCC 和MNC */
        if (operator == null || operator.length() < 4) {
            Log.e(TAG, "this is telephonyControl operator=" + operator);
            return registed;
        }
        int mcc = Integer.parseInt(operator.substring(0, 3));
        int mnc = Integer.parseInt(operator.substring(3));
        registed.setMcc(mcc);
        registed.setMnc(mnc);

        int lac = 0;
        int cellid = 0;
        int psc = 0;
        if (ContextCompat.checkSelfPermission(mContext, android.Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
            if(manager.getPhoneType() == TelephonyManager.PHONE_TYPE_CDMA){
                /**通过CdmaCellLocation获取中国电信 LAC 和cellID */
                CdmaCellLocation location1 = (CdmaCellLocation) manager.getCellLocation();
                lac = location1.getNetworkId();
                cellid = location1.getBaseStationId();
            }else{
                GsmCellLocation location = (GsmCellLocation) manager.getCellLocation();
                /**通过GsmCellLocation获取中国移动和联通 LAC 和cellID */
                lac = location.getLac();
                cellid = location.getCid();
                psc = location.getPsc();
            }
            registed.setLac(lac);
            registed.setCid(cellid);
            registed.setPsc(psc);

            Log.d(TAG, "this is registed baseStation info mcc=" + mcc + " mnc=" + mnc + " lac=" + lac + " cellid=" + cellid + " psc=" + psc);
        }
        return registed;
    }

    /**
     * 获取邻区基站信息
     */
    public List<BaseStationInfo> getBaseStationInfoList(int topN) {
        List<BaseStationInfo> baseStationInfoList = new ArrayList<>();

        if(!hasSimCard()){
            return baseStationInfoList;
        }

        TelephonyManager manager = (TelephonyManager) mContext.getSystemService(Context.TELEPHONY_SERVICE);
        String operator = manager.getNetworkOperator();
        /**通过operator获取 MCC 和MNC */
        if (operator == null || operator.length() < 4) {
            Log.e("TelephonyControll", "this is telephonyControll operator=" + operator);
            return baseStationInfoList;
        }
        int mcc = Integer.parseInt(operator.substring(0, 3));
        int mnc = Integer.parseInt(operator.substring(3));

        int lac = 0;
        int cellid = 0;
        int psc = 0;
        if (ContextCompat.checkSelfPermission(mContext, android.Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
            if(manager.getPhoneType() == TelephonyManager.PHONE_TYPE_CDMA){
                /**通过CdmaCellLocation获取中国电信 LAC 和cellID */
                CdmaCellLocation location = (CdmaCellLocation) manager.getCellLocation();
                lac = location.getNetworkId();
                cellid = location.getBaseStationId();
            }else{
                GsmCellLocation location = (GsmCellLocation) manager.getCellLocation();
                /**通过GsmCellLocation获取中国移动和联通 LAC 和cellID */
                lac = location.getLac();
                cellid = location.getCid();
                psc = location.getPsc();
            }

            BaseStationInfo registed = new BaseStationInfo();
            registed.setMcc(mcc);
            registed.setMnc(mnc);
            registed.setLac(lac);
            registed.setCid(cellid);
            registed.setPsc(psc);

            Log.d(TAG, "this is registed baseStation info mcc=" + mcc + " mnc=" + mnc + " lac=" + lac + " cellid=" + cellid + " psc=" + psc);

            /**通过getNeighboringCellInfo获取BSSS */
            List<NeighboringCellInfo> infoLists = manager.getNeighboringCellInfo();

            for (NeighboringCellInfo info : infoLists) {
                BaseStationInfo baseStationInfo = new BaseStationInfo();
                baseStationInfo.setMcc(mcc);
                baseStationInfo.setMnc(mnc);

                int nlac = info.getLac();// 取出当前邻区的LAC TODO -1
                int ncid = info.getCid();// 取出当前邻区的CID TODO -1
                int nBsss = (-133 + 2 * info.getRssi());// 获取邻区基站信号强度
                int nPsc = info.getPsc();//
                baseStationInfo.setLac(nlac);
                baseStationInfo.setCid(ncid);
                baseStationInfo.setBsss(nBsss);
                baseStationInfo.setPsc(nPsc);

                Log.d(TAG, "this is neighboring baseStation info mcc=" + mcc + " mnc=" + mnc + " lac=" + nlac + " cellid=" + ncid + " bsss=" + nBsss + " psc=" + nPsc);
                baseStationInfoList.add(baseStationInfo);
            }
        }

        Collections.sort(baseStationInfoList, (BaseStationInfo o1, BaseStationInfo o2)->{return o2.getBsss() - o1.getBsss();});
        if(baseStationInfoList.size() > topN) {
            baseStationInfoList = baseStationInfoList.subList(0, topN);
        }

        if (baseStationInfoList.isEmpty()) {
            baseStationInfoList.add(buildFakeBaseStationInfo());
        }

        return baseStationInfoList;
    }

    private BaseStationInfo buildFakeBaseStationInfo() {
        BaseStationInfo faker = new BaseStationInfo(0,0,0,0,0,0);
        return faker;
    }

    public boolean hasSimCard() {
        TelephonyManager mTelephonyManager = (TelephonyManager) mContext.getSystemService(Context.TELEPHONY_SERVICE);
        int simState = mTelephonyManager.getSimState();
        boolean result = true;
        switch (simState) {
            case TelephonyManager.SIM_STATE_ABSENT:
                result = false; // 没有SIM卡
                break;
            case TelephonyManager.SIM_STATE_UNKNOWN:
                result = false;
                break;
        }
        return result;
    }
}