package com.jimi.jimitalk.location;

import android.app.AlarmManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;

import com.jimi.jimitalk.tools.JimipttConfig;

import static android.content.Context.ALARM_SERVICE;

public class LocationServiceControl {

    private final String TAG = "LocationServiceControl";

    private static LocationServiceControl INSTANCE = null;

    private Intent locationServiceIntent;

    private Context mContext;

    private GPSDataAction mGpsDataAction;

    private AlarmManager mAlarmManager;

    public static LocationServiceControl getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new LocationServiceControl(context);
        }
        return INSTANCE;
    }

    private LocationServiceControl(Context context) {
        mContext = context;
        locationServiceIntent = new Intent(context, LocationService.class);
        mGpsDataAction = new GPSDataUpload();
        mAlarmManager = (AlarmManager) JimipttConfig.getAppContext().getSystemService(ALARM_SERVICE);;
    }

    public void initGPSDataActionAndOtherParameters(GPSDataAction gpsDataAction, AlarmManager alarmManager) {
        mGpsDataAction = gpsDataAction;
        mAlarmManager = alarmManager;
    }

    private LocationService.CheckBinder mLocationServiceBinder;
    private ServiceConnection serviceConnection = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.i(TAG, "this is onServiceConnected");
            mLocationServiceBinder = (LocationService.CheckBinder)service;
            mLocationServiceBinder.initGPSDataActionAndOtherParameters(mGpsDataAction, mAlarmManager);
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            Log.i(TAG, "this is onServiceDisconnected");
        }
    };

    public void startLocationService() {
        Log.i(TAG, "------start location service------");
        mContext.bindService(locationServiceIntent, serviceConnection, LocationService.BIND_AUTO_CREATE);
    }

    public void stopLocationService() {
        Log.i(TAG, "------stop location service------");
        try {
            mContext.unbindService(serviceConnection);
        } catch (IllegalArgumentException e) {
            Log.e("long", "service没有注册不用解绑");
        }
    }

    public void resetStatusNormal() {
        if (mLocationServiceBinder != null) {
            mLocationServiceBinder.startCheck();
        }
    }

    public void updateSleepFlag(Boolean mainActivitySleepFlag) {
        if (mLocationServiceBinder != null) {
            mLocationServiceBinder.updateSleepFlag(mainActivitySleepFlag);
        }
    }
}
