package com.jimi.jimitalk.location;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.util.Log;

import java.util.ArrayList;

//todo 速度为0的数据不上传比较好？ 2 监听gps变更数据做上传可能不靠谱，毕竟需要前后数据比对矢量，变化频繁矢量差会变低 需要有一个时间间隔判断 可以放在service里面做
public class LocationService extends Service {
    private static final String TAG = "LocationService";

    private WifiControl mWifiControl;
//    private TelephonyControl mTelephonyControl;
    private Context mContext;
    private DeviceControl mDeviceControl;
    private BluetoothControl mBluetoothControl;
    private final static long WAKEUP_TO_COLLECT_INFO_TIME = 1 * 60 * 1000;
    private final static long SLEEP_LOCATION_SEND_TIME = 5 * 60 * 1000;
    private final static long NORMAL_LOCATION_SEND_TIME = 20 * 1000;
    private final static long MOVING_LOCATION_SEND_TIME = 10 * 1000;
    private Boolean sleepFlag = false;
    private int locationState;
    private final int STATE_START = 0;//
    private final int STATE_SLEEP = 1;//速度不超过阈值且处于休眠状态
    private final int STATE_NORMAL = 2;//设备处于活跃状态且速度不超过阈值 1分钟发送一次信息，期间常开系统定位服务
    private final int STATE_MOVING = 3;//速度超过阈值10S发送一次信息，期间常开系统定位服务
    private final int SLEEP_END = 999;
    private final float MOVING_SPEED = 50/36;
    private GPSInfo lastGpsInfo;
    private AlarmManager alarmManager;
    private PendingIntent pi;
    private CheckStateBroadcastReceiver myBroadcastReceiver;
    private Boolean isBroadcastRegisted = false;
    private voidGpsData voidGpsDataComfirm;//确认GPS数据是否已经收集不到 当前defaultCount次没收集到gps数据视为没有数据
    private staticGpsData staticGpsDataComfirm;//确认是否已经连续多次数据速度为0
    private ArrayList<GPSInfo> gpsInfoDatas = new ArrayList<>();
    private GPSDataAction gpsDataAction;

    public final String LOCATION_SERVICE_CHECK_STATE = "locationService.checkstate";

    private CheckBinder mBinder = new CheckBinder();
    public class CheckBinder extends Binder {

        public void startCheck() {
            Log.e(TAG, "talk唤醒检查locationState  = " + locationState);
            if (locationState == STATE_SLEEP) {
                startSystemGPSService();
                mHandler.removeMessages(locationState);
                alarmManager.cancel(pi);
                voidGpsDataComfirm.reset();//重置空值判定
                checkState();
            }
        }

        public void initGPSDataActionAndOtherParameters(GPSDataAction mGpsDataAction, AlarmManager mAlarmManager) {//bind成功之后的回调执行项
            gpsDataAction = mGpsDataAction;
            alarmManager = mAlarmManager;
            mHandler.sendEmptyMessage(STATE_START);
        }

        public void updateSleepFlag(Boolean mainActivitySleepFlag) {
            sleepFlag = mainActivitySleepFlag;
        }
    }

    private Boolean checkIfNoSpeed(GPSInfo gpsInfo) {
        if (gpsInfo.getSpeed() == 0) {
            staticGpsDataComfirm.countDown();
        } else {//第一次出现速度不为0 上传数据 改变标志位
            staticGpsDataComfirm.reset();
        }
        return staticGpsDataComfirm.getStaticGpsDataConfirm();
    }

    private Boolean checkGpsDataAvailable(GPSInfo gpsInfo) {
        //check 1
        if (gpsInfo == null) {
            Log.e(TAG, "空的gps数据");
            return false;
        }
        //check 2
        if (lastGpsInfo != null && gpsInfo.getTime() == lastGpsInfo.getTime()) {//gps获取的是上次的数据，实际没有得到新数据
            Log.e(TAG, "旧的gps数据");
            return false;
        }
        //check 3
        if (gpsInfo.getLatitude() == 0.0 && gpsInfo.getLongitude() == 0.0) {//经纬度为0，视为数据不可用
            Log.d(TAG, "没有经纬度数据，不发送");
            return false;
        }
        //check 4
        if (!GSensorControll.getInstance(mContext).getDeviceMoveStatus()) {
            Log.e(TAG, "设备传感器没有移动");
            return false;
        }
        //check 5
//        if (checkIfNoSpeed(gpsInfo)) {
//            Log.e(TAG, "连着的第n次速度为0 不上传数据");
//            return false;
//        }
        //pass all check
        return true;
    }

    //上传数据开始 包括检查数据有效性、上传、重置其他参数
    private void gpsDataUpload(DeviceInfo deviceInfo, GPSInfo gpsInfo) {
        if (checkGpsDataAvailable(gpsInfo)) {//如果gps数据可用则发送数据
            Log.e(TAG, "check pass");
            if (gpsDataAction.sendGpsData(deviceInfo, gpsInfo)) {//发送本条数据成功 顺便补传
                checkLocalLocationDataArrayList();
            } else {//发送不成功，有效数据存入本地等待补传
                storeLocalData(gpsInfo);
            }
            voidGpsDataComfirm.reset();
            lastGpsInfo = gpsInfo;
        } else if (locationState == STATE_MOVING || locationState == STATE_NORMAL) {
            voidGpsDataComfirm.countDown();
        }
    }

    private void storeLocalData(GPSInfo gpsInfo) {
        if (gpsInfoDatas.size() > 200)
            gpsInfoDatas.remove(0);
        gpsInfoDatas.add(gpsInfo);
        Log.e(TAG,"上传失败数据存储到本地 当前本地缓存大小为：" + gpsInfoDatas.size());
    }

    @SuppressLint("HandlerLeak")
    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            DeviceInfo deviceInfo = mDeviceControl.getDeviceDetail(LocationService.this);
            GPSInfo gpsInfo = GPSControl.getInstance(mContext).getCurrentLocationInfo();
            switch (msg.what) {
                case STATE_START:
                    startSystemGPSService();
                    checkState();
                    break;
                case STATE_SLEEP:
                    startSystemGPSService();
                    sendEmptyMessageDelayed(SLEEP_END, WAKEUP_TO_COLLECT_INFO_TIME);
                    break;
                case SLEEP_END:
                    gpsDataUpload(deviceInfo, gpsInfo);
                    checkState();
                    break;
                case STATE_NORMAL:
                    gpsDataUpload(deviceInfo, gpsInfo);
                    checkState();
                    break;
                case STATE_MOVING:
                    gpsDataUpload(deviceInfo, gpsInfo);
                    checkState();
                    break;
            }
        }
    };


    //todo 休眠控制主次颠倒/grpc反复重连的时候消耗资源导致闹钟不准
    private void checkState() {
        GPSInfo gpsInfo = GPSControl.getInstance(this).getCurrentLocationInfo();
        Float speed = 0f;
        if (gpsInfo != null) {
            speed = gpsInfo.getSpeed();
        }

        Log.e(TAG, "state判定开始  speed:" + speed + "  休眠FLAG:" + sleepFlag + " 空值判定:" + voidGpsDataComfirm.getVoidGpsDataConfirm());
        if (sleepFlag && voidGpsDataComfirm.getVoidGpsDataConfirm()) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                alarmManager.setExactAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + SLEEP_LOCATION_SEND_TIME,pi);
            } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                alarmManager.setExact(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + SLEEP_LOCATION_SEND_TIME,pi);
            }
            closeSystemGPSService();
            locationState = STATE_SLEEP;
        } else if (speed > MOVING_SPEED) {
            if (sleepFlag) {
                alarmManager.setExact(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + MOVING_LOCATION_SEND_TIME, pi);
            } else {
                mHandler.sendEmptyMessageDelayed(STATE_MOVING, MOVING_LOCATION_SEND_TIME);
            }
            locationState = STATE_MOVING;
        } else {
            if (sleepFlag) {
                alarmManager.setExact(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + NORMAL_LOCATION_SEND_TIME, pi);
            } else {
                mHandler.sendEmptyMessageDelayed(STATE_NORMAL, NORMAL_LOCATION_SEND_TIME);
            }
            locationState = STATE_NORMAL;
        }
        Log.i(TAG,"-----this is 开始定位 ----- " + locationState );
    }

    private void checkLocalLocationDataArrayList() {
        if (gpsInfoDatas.size() == 0) {
            return;
        }
        for (int index = 0; index < gpsInfoDatas.size(); index++) {
            Log.d(TAG,"补传第"+index+"条数据");
            if (gpsDataAction.sendGpsData(mDeviceControl.getDeviceDetail(LocationService.this),
                    gpsInfoDatas.get(index))) {
                Log.d(TAG,"第"+index+"条数据补传成功");
                gpsInfoDatas.remove(index);
                index--;
            }
        }
    }

    @Override
    public IBinder onBind(Intent intent) {
        Log.i(TAG, "this is onBind");
        init();
        return mBinder;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        mHandler.removeCallbacksAndMessages(null);
        unInit();
        return super.onUnbind(intent);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        Log.i(TAG, "this is onCreate");
    }

    private void init(){
        Log.i(TAG, "------init location service------");
        mContext = getApplicationContext();
        locationState = STATE_START;
        GPSControl.getInstance(this).startLocation();
        GSensorControll.getInstance(this).registerSensorListener();

        if(mDeviceControl == null){
            mDeviceControl = new DeviceControl(this);
        }

        if (voidGpsDataComfirm == null) {
            voidGpsDataComfirm = new voidGpsData();
        }

        if (staticGpsDataComfirm == null) {
            staticGpsDataComfirm = new staticGpsData();
        }

        if(myBroadcastReceiver == null){
            myBroadcastReceiver = new CheckStateBroadcastReceiver();
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction(LOCATION_SERVICE_CHECK_STATE);
            registerReceiver(myBroadcastReceiver, intentFilter);
            isBroadcastRegisted = true;
        }

        pi = PendingIntent.getBroadcast(mContext, 0, new Intent(LOCATION_SERVICE_CHECK_STATE), 0);
//        gpsDataAction = new GPSDataUpload();
    }

    private void unInit() {
        Log.i(TAG, "------unInit location service------");
        GPSControl.getInstance(this).stopLocation();
        GSensorControll.getInstance(this).unRegisterSensorListener();
        if(mDeviceControl != null){
            mDeviceControl = null;
        }
        if (voidGpsDataComfirm != null) {
            voidGpsDataComfirm = null;
        }
        if (staticGpsDataComfirm != null) {
            staticGpsDataComfirm = null;
        }
        if (isBroadcastRegisted) {
            unregisterReceiver(myBroadcastReceiver);
            isBroadcastRegisted = false;
        }
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.e(TAG,"-----this is 开始定位-11---- thread id=" + Thread.currentThread().getId());
        init();
        mHandler.sendEmptyMessageDelayed(STATE_SLEEP, SLEEP_LOCATION_SEND_TIME);
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        Log.i(TAG, "------this is locationService onDestroy------");
        mHandler.removeCallbacksAndMessages(null);
        unInit();
    }

    private void startSystemGPSService() {
        Log.e(TAG, "系统GPS功能开启");
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.WRITE_SETTINGS) != PackageManager.PERMISSION_GRANTED) {
            Log.d(TAG, "this is WRITE_SETTINGS权限缺失");
            return;
        }
        Settings.Secure.putInt(mContext.getContentResolver(), Settings.Secure.LOCATION_MODE, Settings.Secure.LOCATION_MODE_HIGH_ACCURACY);
    }

    private void closeSystemGPSService() {
        Log.e(TAG, "系统GPS功能关闭");
        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.WRITE_SETTINGS) != PackageManager.PERMISSION_GRANTED) {
            Log.d(TAG, "this is WRITE_SETTINGS权限缺失");
            return;
        }
        Settings.Secure.putInt(mContext.getContentResolver(), Settings.Secure.LOCATION_MODE, Settings.Secure.LOCATION_MODE_OFF);
    }

    private class voidGpsData {//defaultCount次收不到数据就认为没有gps数据了
        private int exitMovingStateCountdown;
        private Boolean voidGpsDataConfirm;
        private final int defaultCount = 5;
        private voidGpsData() {
            exitMovingStateCountdown = defaultCount;
            voidGpsDataConfirm = false;
        }
        private Boolean getVoidGpsDataConfirm() {
            return voidGpsDataConfirm;
        }
        private void countDown() {
            Log.e(TAG, "voidGpsData countDown");
            exitMovingStateCountdown--;
            voidGpsDataConfirm = (exitMovingStateCountdown <= 0);
        }
        private void reset() {
            Log.v(TAG, "voidGpsData reset");
            exitMovingStateCountdown = defaultCount;
            voidGpsDataConfirm = false;
        }
    }

    private class staticGpsData {//defaultCount次连续的0速数据后不再上传
        private int sequentStaticData;
        private Boolean staticGpsDataConfirm;
        private final int defaultCount = 10;
        private staticGpsData() {
            sequentStaticData = defaultCount;
            staticGpsDataConfirm = false;
        }
        private Boolean getStaticGpsDataConfirm() {
            return staticGpsDataConfirm;
        }
        private void countDown() {
            Log.e(TAG, "staticGpsData countDown:" + sequentStaticData);
            sequentStaticData--;
            staticGpsDataConfirm = (sequentStaticData <= 0);
        }
        private void reset() {
            Log.e(TAG, "staticGpsData reset");
            sequentStaticData = defaultCount;
            staticGpsDataConfirm = false;
        }
    }

    private class CheckStateBroadcastReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            String broadcastAction = intent.getAction();
            if (LOCATION_SERVICE_CHECK_STATE.equals(broadcastAction)) {
                mHandler.sendEmptyMessage(locationState);
            }
        }
    }
}
