package com.jimi.jimitalk.location;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;


public class GSensorControll {
	private SensorManager mSensorManager = null;
	private Context mContext = null;
	private static GSensorControll sensorControll = null;
	private static String TAG = "GSensorControl:";
	private boolean mDeviceMove = false;
	private float mAcceleX = 0.0f;
	private float mAcceleY = 0.0f;
	private float mAcceleZ = 0.0f;
	private static final int MAX_FILTER_DATA_NUM = 20;
	private static final int MAX_SPEED_DIFF = 5;
	private static final int MAX_WALKING_SPEED = 5;
	private static final int MIN_CAR_SPEED = 10;
	private int mFilterDataCount = 0;
	private int mMaxDeviceSpeed = -1;
	private int mMaxAcceleValue = -1;

	private GSensorControll(Context context) {
		Log.d(TAG, "GSensorControll");
		mContext = context;
		mSensorManager = (SensorManager) mContext
				.getSystemService(Context.SENSOR_SERVICE);
	}

	public static GSensorControll getInstance(Context context) {
		if (sensorControll == null) {
			synchronized (GSensorControll.class) {
				if (sensorControll == null) {
					sensorControll = new GSensorControll(context);
				}
			}
		}
		return sensorControll;
	}

	public boolean getDeviceMoveStatus() {
		Log.d(TAG, "mMaxAcceleValue:" + mMaxAcceleValue + ",mMaxDeviceSpeed:"
						+ mMaxDeviceSpeed);
		return mDeviceMove;
	}

	public void setDeviceMoveStatus(boolean status) {
		mDeviceMove = status;
	}

	public void registerSensorListener() {
		mSensorManager.registerListener(eventListener,
				mSensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER),
				SensorManager.SENSOR_DELAY_GAME);
	}

	public void unRegisterSensorListener() {
		mSensorManager.unregisterListener(eventListener);
	}

	private SensorEventListener eventListener = new SensorEventListener() {

		@Override
		public void onSensorChanged(SensorEvent event) {
			int type = event.sensor.getType();
			switch (type) {
				case Sensor.TYPE_ACCELEROMETER:
					if (mFilterDataCount >= MAX_FILTER_DATA_NUM) {
						mFilterDataCount = 0;
						judgeDeviceMoveState(event.values[0], event.values[1],
								event.values[2]);
					}
					mFilterDataCount++;
					break;
				default:
					break;
			}
		}

		@Override
		public void onAccuracyChanged(Sensor sensor, int accuracy) {

		}
	};

	private void judgeDeviceMoveState(float x, float y, float z) {
		int px = Math.abs((int) (x - mAcceleX));
		int py = Math.abs((int) (y - mAcceleY));
		int pz = Math.abs((int) (z - mAcceleZ));

		mMaxAcceleValue = getMaxValue(px, py, pz);

		int currentSpeed = getCurrentDeviceSpeed();
		if (mMaxAcceleValue > 0) {
			mDeviceMove = true;
			if (currentSpeed >= mMaxDeviceSpeed) {
				mMaxDeviceSpeed = currentSpeed;
			}
		} else {
			if (mMaxDeviceSpeed == -1) {
				mDeviceMove = false;
				return;
			}

			if (mMaxDeviceSpeed <= MAX_WALKING_SPEED) {
				mDeviceMove = false;
				mMaxDeviceSpeed = -1;
			} else {
				if (currentSpeed >= MIN_CAR_SPEED) {
					mDeviceMove = true;
				} else {
					mDeviceMove = false;
					mMaxDeviceSpeed = -1;
				}
			}
		}

		mAcceleX = x;
		mAcceleY = y;
		mAcceleZ = z;

		Log.d(TAG,"x =" + x+" y=" + y+" z=" + z+"\n mAcceleX="+mAcceleX+
				" px="+px+" py="+py+" pz="+pz+
				" mMaxAcceleValue="+ mMaxAcceleValue + " currentSpeed="+currentSpeed +" mMaxDeviceSpeed="+mMaxDeviceSpeed+ " mDeviceMove:" + mDeviceMove);
	}

	private int getCurrentDeviceSpeed() {
		GPSInfo info = GPSControl.getInstance(mContext)
				.getCurrentLocationInfo();
		if (info != null) {
			return Integer.parseInt(String.format("%d", (int) (info.getSpeed() * 3.6f)));
		}
		return -1;
	}

	public int getMaxValue(int px, int py, int pz) {
		int max = 0;
		if (px > py && px > pz) {
			max = px;
		} else if (py > px && py > pz) {
			max = py;
		} else if (pz > px && pz > py) {
			max = pz;
		}
		return max;
	}
}
