package com.jimi.jimitalk.location;

import android.util.Log;

import com.jimi.jimitalk.bean.UserBean;
import com.jimi.jimitalk.grpc.GrpcConnectionController;

import talk_cloud.TalkCloudLocationOuterClass;

public class GPSDataUpload implements GPSDataAction {

    private static final String TAG = "GPSDataUpload";

    public Boolean sendGpsData(DeviceInfo deviceInfo, GPSInfo gpsInfo) {
        Log.e(TAG, "start upload");
        TalkCloudLocationOuterClass.Device device = dealDeviceInfoData(deviceInfo);
        TalkCloudLocationOuterClass.Location location = dealGpsInfoData(gpsInfo);
        String task = "" + System.currentTimeMillis()/1000;
        outputGpsLog(task,location);
        return GrpcConnectionController.getInstance().sendGpsData(device, location);
    }

    private static void outputGpsLog(String task, TalkCloudLocationOuterClass.Location location) {
        Log.e(TAG, task +"的发送任务开始 "
                + "this is lat="+location.getGpsInfo().getLatitude()
                +" lon="+location.getGpsInfo().getLongitude()
                +" spe="+location.getGpsInfo().getSpeed()
                + " cou="+location.getGpsInfo().getCourse()
                +" time="+location.getGpsInfo().getLocalTime());
    }

    private static TalkCloudLocationOuterClass.Location dealGpsInfoData(GPSInfo gpsInfo) {
        TalkCloudLocationOuterClass.GPS gps = TalkCloudLocationOuterClass.GPS.newBuilder()
                .setLocalTime(gpsInfo.getTime())
                .setLatitude(gpsInfo.getLatitude())
                .setLongitude(gpsInfo.getLongitude())
                .setSpeed((int)gpsInfo.getSpeed())
                .setCourse(gpsInfo.getBearing())
                .build();
        return TalkCloudLocationOuterClass.Location.newBuilder().setGpsInfo(gps).build();
    }

    private static TalkCloudLocationOuterClass.Device dealDeviceInfoData(DeviceInfo deviceInfo) {
        return TalkCloudLocationOuterClass.Device.newBuilder()
                .setId(UserBean.getInstance().getUid())
                .setBattery(deviceInfo.getBattery())
                .setDeviceType(deviceInfo.getType())
                .build();
    }
}
