package com.jimi.jimitalk.location;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.util.Log;

public class GPSControl {
    private static final String TAG = "GPSControl";
    private LocationManager mLocationManager;
    private String bestProvider = null;
    private long updateRate = 10 * 1000;
    public static final byte[] UPDATE_MODE = {0x00, 0x01, 0x02, 0x03, 0x04,
            0x05, 0x06, 0x07, 0x08, 0x09};
    public static final byte[] UPDATE_REALTIME = {0x00, 0x01};
    private GPSInfo mCurrentInfo = null;
    private int mGpsState = 0;
    private Context mContext;
    private static GPSControl gpsControl;

    public static GPSControl getInstance(Context context) {
        if (gpsControl == null) {
            synchronized (GPSControl.class) {
                if (gpsControl == null) {
                    gpsControl = new GPSControl(context);
                }
            }
        }
        return gpsControl;
    }

    public GPSControl(Context context) {
        Log.i(TAG, "------GPSControl------");
        mContext = context;
        mLocationManager = (LocationManager) mContext.getSystemService(Context.LOCATION_SERVICE);//FIXME Why call location, if location is null?
        bestProvider = mLocationManager.getBestProvider(getCriteria(), true);
    }

    private Criteria getCriteria() {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(Criteria.ACCURACY_FINE);//设置为最大精度
        criteria.setSpeedRequired(true);//设置是否需要提供速度
        criteria.setSpeedAccuracy(Criteria.ACCURACY_HIGH);//设置速度精度
        criteria.setCostAllowed(false);//设置找到的Provider是否允许产生费用
        criteria.setBearingRequired(true);//是否需要方向信息
        criteria.setBearingAccuracy(Criteria.ACCURACY_HIGH);//设置方向的精度
        criteria.setAltitudeRequired(true);//设置是否需要提供海拔信息
        criteria.setHorizontalAccuracy(Criteria.ACCURACY_HIGH);//设置水平方向的精度
        criteria.setVerticalAccuracy(Criteria.ACCURACY_HIGH);//设置垂直方向的精度
        criteria.setPowerRequirement(Criteria.POWER_LOW);//设置耗电
        return criteria;
    }

    public void startLocation() {
        Log.i(TAG, "------start location------");
        if (mContext == null)
            return;

        if (ContextCompat.checkSelfPermission(mContext, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
            mLocationManager.requestLocationUpdates(bestProvider, updateRate, 0, locationListener);
        }
    }

    public void stopLocation() {
        locationListener = null;
        mLocationManager = null;
        mContext = null;
        bestProvider = null;
    }

    public GPSInfo getCurrentLocationInfo() {
//        Log.d(TAG, "this is getCurrentLocationInfo \tnullData:" + (mCurrentInfo == null) + " bestProvider:"+bestProvider);
        if (mCurrentInfo == null) {
            if (ContextCompat.checkSelfPermission(mContext, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED
                && mLocationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
                mCurrentInfo = getLocationInfo(mLocationManager.getLastKnownLocation(bestProvider));
                if (mCurrentInfo  == null)
                {
                    bestProvider = mLocationManager.getBestProvider(getCriteria(), true);//空值有可能是选取了一个不适合的provider
                    Log.d(TAG, "更新provider  \tbestProvider:"+bestProvider);
                    mLocationManager.requestLocationUpdates(bestProvider, updateRate, 1, locationListener);
                }
            }
        }
        return mCurrentInfo;
    }

    //todo 一段时间后listener失效？
    private LocationListener locationListener = new LocationListener() {
        /**
         * GPS状态变化时触发
         */
        @Override
        public void onStatusChanged(String provider, int status, Bundle extra) {
            switch (status) {
                //GPS状态为可见时
                case LocationProvider.AVAILABLE:
                    Log.i(TAG, "当前GPS状态为可用状态");
                    break;
                //GPS状态为服务区外时
                case LocationProvider.OUT_OF_SERVICE:
                    Log.i(TAG, "当前GPS状态为服务区外状态");
                    break;
                //GPS状态为暂停服务时
                case LocationProvider.TEMPORARILY_UNAVAILABLE:
                    Log.i(TAG, "当前GPS状态为暂停服务状态");
                    break;
            }
        }

        /**
         * GPS开启时触发
         */
        @Override
        public void onProviderEnabled(String provider) {
            Log.d(TAG, "this is onProviderEnabled");
            if (mContext == null)
                return;

            if (ContextCompat.checkSelfPermission(mContext, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
                Log.d(TAG, "this is onProviderEnabled " + mLocationManager.getLastKnownLocation(bestProvider));
                if (mLocationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
                    Log.d(TAG, "this is onProviderEnabled LocationManager.GPS_PROVIDER");
                    Location location = mLocationManager.getLastKnownLocation(bestProvider);
                    int index = 5;
                    while(location  == null && index >0)
                    {
                        Log.d(TAG, "this is requestLocationUpdates");
                        mLocationManager.requestLocationUpdates(bestProvider, updateRate, 1, locationListener);
                        index--;
                    }
                    mCurrentInfo = getLocationInfo(location);
                }
            }
        }

        /**
         * GPS禁用时触发
         */
        @Override
        public void onProviderDisabled(String provider) {
            Log.d(TAG, "this is onProviderDisabled");
            mGpsState = 0;
        }

        /**
         * 位置信息变化时触发
         */
        @Override
        public void onLocationChanged(Location location) {
            if (mContext == null)
                return;

            if (ContextCompat.checkSelfPermission(mContext, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
                Log.d(TAG, "this is onLocationChanged " + mLocationManager.getLastKnownLocation(bestProvider));
                if (mLocationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
//                    Log.d(TAG, "this is onLocationChanged LocationManager.GPS_PROVIDER");
                    location = mLocationManager.getLastKnownLocation(bestProvider);
                    int index = 5;
                    while(location  == null && index >0)
                    {
                        Log.d(TAG, "this is requestLocationUpdates");
                        mLocationManager.requestLocationUpdates(bestProvider, updateRate, 1, locationListener);
                        index--;
                    }
                }

                if (location == null) {
                    if (mLocationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
//                        Log.d(TAG, "this is onLocationChanged LocationManager.NETWORK_PROVIDER");
                        location = mLocationManager.getLastKnownLocation(bestProvider);
                    }
                }
            }
            mCurrentInfo = getLocationInfo(location);
            mGpsState = 1;
        }
    };

    private GPSInfo getLocationInfo(Location location) {
        Log.d(TAG, "this is getLocationInfo");
        if (location == null) {
            Log.e(TAG, "this is getLocationInfo location == null");
            return null;
        }
        GPSInfo info = new GPSInfo();
        info.setTime(location.getTime()/1000);
        info.setLatitude(location.getLatitude());
        info.setLongitude(location.getLongitude());
        info.setSpeed(location.getSpeed());
        info.setBearing(location.getBearing());
        info.setSupply(UPDATE_REALTIME[0]);
        info.setMode(UPDATE_MODE[0]);
        return info;
    }
}
