package com.jimi.jimitalk.location;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.BatteryManager;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.util.Log;

import java.util.Locale;

public class DeviceControl{
    private static final String TAG = "DeviceControl";
    private Context mContext;
    private String imei;
    private int deviceType;

    public DeviceControl(Context context) {
        Log.i(TAG, "------DeviceControl------");
        mContext = context;
        imei = getImei(context);
        deviceType = 1;
    }

    public String getImei(Context context) {
        String imei = "";
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        if (ContextCompat.checkSelfPermission(context, android.Manifest.permission.READ_PHONE_STATE) == PackageManager.PERMISSION_GRANTED) {
            imei = telephonyManager.getDeviceId();
        }
        return imei;
    }

    public static int getBattery(Context context) {
        int battery = 0;
        IntentFilter ifilter = new IntentFilter(Intent.ACTION_BATTERY_CHANGED);
        Intent batteryStatus = context.registerReceiver(null, ifilter);
        int level = batteryStatus.getIntExtra(BatteryManager.EXTRA_LEVEL, -1);
        int scale = batteryStatus.getIntExtra(BatteryManager.EXTRA_SCALE, -1);
        battery = (level * 100) / scale;
        return battery;
    }

    public int getDeviceType() {
        return 1;
    }

//    public DeviceInfo getDeviceDetail(Context context) {
//        DeviceInfo info = new DeviceInfo();
//        info.setImei(getImei(context));
//        info.setBattery(getBattery(context));
//        info.setType(getDeviceType());
//        return info;
//    }

    public DeviceInfo getDeviceDetail(Context context) {
        return new DeviceInfo(imei, getBattery(context), deviceType);
    }

    private boolean isZh() {
        Locale locale = mContext.getResources().getConfiguration().locale;
        String language = locale.getLanguage();
        Log.d("device","this is device and language = "+language);
        if (language.endsWith("zh"))
            return true;
        else
            return false;
    }

}
