package com.jimi.jimitalk.location;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BluetoothControl {
    private static final String TAG = "BluetoothControl";

    private BluetoothAdapter mBluetoothAdapter = null;
    private Context mContext;
    private List<BluetoothInfo> bluetoothInfos;

    @SuppressLint("HandlerLeak")
    Handler mHandler = new Handler(){
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what){
                case 1:
                    clearBluetoothInfos();
                    scanBluetooth();
                    break;
                default:
                    break;
            }
        }
    };

    public BluetoothControl(Context context) {
        Log.i(TAG, "------BluetoothControl------");
        mContext = context;
        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        bluetoothInfos = new ArrayList<>();

        // Broadcast Action: Remote device discovered.
        IntentFilter action_found = new IntentFilter(BluetoothDevice.ACTION_FOUND);
        context.registerReceiver(receiver, action_found);

        // Broadcast Action: Remote device discovered finished.
        IntentFilter action_discover_finished = new IntentFilter(BluetoothAdapter.ACTION_DISCOVERY_FINISHED);
        context.registerReceiver(receiver, action_discover_finished);
    }

    public void scanBluetooth() {
        Log.i(TAG, "------scan bluetooth------");
        if (mBluetoothAdapter == null) {
            Log.e(TAG, "this is no bluetooth capability");
            return;
        }

        if (!mBluetoothAdapter.isEnabled()) {
            mBluetoothAdapter.enable();
        }

        if(!mBluetoothAdapter.isDiscovering()){
            mBluetoothAdapter.startDiscovery();
        }
    }

    public void close(){
        mContext.unregisterReceiver(receiver);
        if (mBluetoothAdapter.isDiscovering()) {
            mBluetoothAdapter.cancelDiscovery();
        }
        mBluetoothAdapter = null;
    }

    private synchronized void clearBluetoothInfos() {
        bluetoothInfos.clear();
    }

    public synchronized List<BluetoothInfo> getBluetoothInfos(int topN) {
        List<BluetoothInfo> bluetoothInfoListTopN = new ArrayList<>();

        for (BluetoothInfo bluetoothInfo: bluetoothInfos) {
            Log.i(TAG, "this is bluetooth discovered info=" + bluetoothInfo.toString());
        }

        if (bluetoothInfos.size() > topN) {
            Collections.sort(bluetoothInfos, (BluetoothInfo o1, BluetoothInfo o2)->{return o2.getRssi() - o1.getRssi();});
            bluetoothInfoListTopN = bluetoothInfos.subList(0, topN);
        }

        return bluetoothInfoListTopN;
    }

    private final BroadcastReceiver receiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {   // 收到的广播类型
            String action = intent.getAction();// 发现设备的广播
            if (BluetoothDevice.ACTION_FOUND.equals(action)) {// 获得已经搜索到的蓝牙设备
                BluetoothDevice device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
                if (device != null) {
                    short rssi = intent.getExtras().getShort(BluetoothDevice.EXTRA_RSSI);
                    String name = device.getName();
                    String address = device.getAddress();
                    int bondState = device.getBondState();

//                    // 将蓝牙信号强度换算为距离
//                    double d = Math.pow(10,((Math.abs(rssi)-59) / (10 * 2.0)));
//                    DecimalFormat df   = new DecimalFormat("######0.00");
//                    String juli = df.format(d);

                    BluetoothInfo bluetoothInfo = new BluetoothInfo(name, address, bondState, rssi);
                    bluetoothInfos.add(bluetoothInfo);
                } else {
                    Log.e(TAG, "this is no bluetooth discovered");
                }
            } else if (BluetoothAdapter.ACTION_DISCOVERY_FINISHED.equals(action)) {//蓝牙设备搜索完成
                mHandler.sendEmptyMessageDelayed(1, 1*60*1000);
            }
        }
    };
}