package com.jimi.jimitalk.grpc;

import com.jimi.jimitalk.bean.FriendBean;
import com.jimi.jimitalk.bean.GroupBean;
import com.jimi.jimitalk.bean.UserBean;
import com.jimi.jimitalk.location.DeviceControl;
import com.jimi.jimitalk.location.DeviceInfo;
import com.jimi.jimitalk.ptt.api.PocRoomController;
import com.jimi.jimitalk.receiver.NetWorkStatusChangeReceiver;
import com.jimi.jimitalk.tools.AppTool;
import com.jimi.jimitalk.tools.JimipttConfig;
import com.jimi.jimitalk.tools.LogUtil;
import com.jimi.jimitalk.tools.SPUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import io.grpc.ManagedChannel;
import talk_cloud.TalkCloudApp;
import talk_cloud.TalkCloudGrpc;
import talk_cloud.TalkCloudLocationGrpc;
import talk_cloud.TalkCloudLocationOuterClass;
import talk_cloud.TalkCloudModel;

public class GrpcConnectionController {
    /** Signals for rpc connection*/
    private boolean isGrpcConnect = false;
    private boolean isConnectRunning = false;
    private boolean isLoginRunning = false;
    private boolean isShutDown = false;//只有断网 或者 外层调用stopGrpcStreamReceiver()方法才会置true 收到心跳和有网值false
    private boolean isAfterFirtHeartBeat = false;
    private String conIp = null;
    private int conPort = 0;

    /** Dispatch rpc stream messages*/
    private IGrpcStreamObserverCallbacks callbacks;

    private ExecutorService executorService = Executors.newCachedThreadPool();

    private GrpcConnection grpcConnection;

    private static GrpcConnectionController instance = null;

    private static Thread keepAlive = null;

    private final int DATA_TYPE_ERROR = 0;
    private final int DATA_TYPE_KEEPALIVE = 4;
    private final int DATA_TYPE_PASSIVE = 9;
    private final int DATA_TYPE_TEMP_GROUP = 11;

    public static GrpcConnectionController getInstance() {
        if (instance == null) {
            synchronized (GrpcConnectionController.class) {
                if (instance == null) {
                    try {
                        instance = new GrpcConnectionController(SPUtil.getServer(), SPUtil.getGrpcPort());
                    } catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return instance;
    }

    public int computeLastStringLength(String inputString) {
        if (inputString == null || inputString.length() >4999) {
            return -1;
        }
        return inputString.length()-inputString.lastIndexOf(" ") - 1;
    }

    private GrpcConnectionController(String ip, int port) {
        LogUtil.i("new GrpcConnectionController");
        conIp = ip;
        conPort = port;
        grpcConnection = new GrpcConnection(ip, port);
        grpcConnection.registerMessageCallbacks(new IGrpcStreamObserverCallbacks() {
            @Override
            public void onNext(TalkCloudApp.StreamResponse value) {
                LogUtil.e("Grpc msg DataType:" +value.getDataType() + " time:" +value.getTimeStamp());
                reactGrpcMsg(UserBean.getInstance().getUid(), -1, value.getTimeStamp());

                if (callbacks != null) {
                    callbacks.onNext(value);
                }

                switch (value.getDataType()) {
                    case DATA_TYPE_ERROR: {
//                        ifReconnect();
                        break;
                    }
                    case DATA_TYPE_KEEPALIVE: {
                        isAfterFirtHeartBeat = true;
                        isGrpcConnect = true;
                        isShutDown = false;
                        reconnectDelay = 0;
                        grpcHeartReceiveCount++;
                        NetWorkStatusChangeReceiver.getInstance(JimipttConfig.getAppContext());
                        LogUtil.i("Grpc recv ack: " + "isConnectRunning(" + isConnectRunning + ")" + "grpcHeartReceiveCount("+grpcHeartReceiveCount+")");
                        break;
                    }
                    case DATA_TYPE_PASSIVE: {
                        LogUtil.e(value.toString());
                        TalkCloudApp.LoginOrLogoutNotify updater = value.getNotify();
                        ArrayList<GroupBean> groups = new ArrayList<>();
                        boolean isTempGroupExisted = false;
                        boolean isLockGidExisted = false;
                        for (TalkCloudModel.GroupInfo groupInfo : updater.getGroupListList()) {
                            if (groupInfo.getStatus() == 1) {
                                GroupBean group = new GroupBean();
                                group.setUserGroupBeanObj(groupInfo);
                                groups.add(group);
                            }

                            if (groupInfo.getStatus() == 2) {
                                if (UserBean.getInstance().isTempGroupExisted()) {
                                    if (UserBean.getInstance().getTempGroup().getGroupId() == groupInfo.getGid()) {
                                        isTempGroupExisted = true;
                                    }
                                } else {
                                    LogUtil.d("更新的数据中有临时组 且本地没有临时组");
                                }
                            }

                            if (groupInfo.getGid() == SPUtil.getLockGid()) {
                                isLockGidExisted = true;
                            }
                        }

                        UserBean.getInstance().setGroups(groups);

                        if (!isTempGroupExisted && UserBean.getInstance().isTempGroupExisted()) {
                            AppTool.sendBroadcast("jimi", "temp_group", "destroyed");
                            UserBean.getInstance().setTempGroup(null);//防止临时组界面不存在 本地数据没有清空
                        }

                        if (!isLockGidExisted) {
                            if (!UserBean.getInstance().getGroups().isEmpty()) {
                                int newLockGid = UserBean.getInstance().getGroups().get(0).getGroupId();
                                UserBean.getInstance().setLockGid(newLockGid);
                                GrpcConnectionController.getInstance().handleSetLockGroupIdBack(UserBean.getInstance().getUid(), newLockGid);

                                if (PocRoomController.getInstance().isInOneRoom()) {
                                    PocRoomController.getInstance().changeRoom(UserBean.getInstance().getLockGid());
                                } else {
                                    PocRoomController.getInstance().joinRoom(UserBean.getInstance().getLockGid());
                                }
                            }
                        }

                        AppTool.sendBroadcast("jimi", "pocroom", "group_list_updated");

                        break;
                    }
                    case DATA_TYPE_TEMP_GROUP: {
                        int tempGid = value.getNotify().getGroupInfo().getGid();
                        if (!UserBean.getInstance().isTempGroupExisted()) {
                            boolean errorData = true;

                            for (TalkCloudModel.GroupInfo groupInfo : value.getNotify().getGroupListList()) {
                                if (tempGid == groupInfo.getGid()) {
                                    LogUtil.d(groupInfo.toString());

                                    GroupBean temp = new GroupBean();
                                    temp.setUserGroupBeanObj(groupInfo);

                                    UserBean.getInstance().setTempGroup(temp);
                                    AppTool.sendBroadcast("jimi", "temp_group", "created");

//                                    if (VideoRoomController.getInstance().isConnected()) {
//                                        VideoRoomController.getInstance().leaveRoom();
//                                    }
//
//                                    Intent tempGroup = new Intent(JimipttConfig.getAppContext(), TempGroupActivity.class);
//                                    tempGroup.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_EXCLUDE_FROM_RECENTS);
//                                    JimipttConfig.getAppContext().startActivity(tempGroup);

                                    errorData = false;
                                    break;
                                }
                            }
                            if (errorData) {
                                LogUtil.e("tempGroup msg errorData:dirty data.");//脏数据导致有tempgroup信息 但是getGroupListList返回空等问题
                            }
                        } else if (UserBean.getInstance().getTempGroup().getGroupId() != tempGid) {
                            LogUtil.e("tempGroup msg errorData：different temp group.");//已有的临时组id与传下来的临时组id不一致
                        } else {
                            //典型场景 强关app或关机 重登 web再次圈选
                            LogUtil.e("tempGroup msg errorData：else.");
                        }
                        break;
                    }
                }
            }

            @Override
            public void onError(Throwable t) {
                if (callbacks != null) {
                    callbacks.onError(t);
                }
                LogUtil.e("StreamObserver onError=" + t.getMessage() + " \n whether to reconnect:" + !isConnectRunning +" isShutDown:"+isShutDown);
                isGrpcConnect = false;
                if (isShutDown) {
                    return;
                }
                ifReconnect();
            }

            @Override
            public void onCompleted() {
                if (callbacks != null) {
                    callbacks.onCompleted();
                }
            }
        }
        );
    }

    public static void initGrpcConnection(String ip, int port) {
        LogUtil.i("GRPC init info ip=" + ip + ", port=" + port);
        instance = new GrpcConnectionController(ip, port);
    }

    public void registerMessageCallbacks(IGrpcStreamObserverCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    public void startGrpcStreamReceiver() {
        LogUtil.i("GstartGrpcStreamReceiver");
        grpcConnection.startGrpcStreamReceiver();
        LogUtil.i("keepAlive");
        keepAlive();
    }

    public void stopGrpcStreamReceiver() {
        isShutDown = true;

        grpcConnection.stopGrpcStreamReceiver();
    }

    private void fetchOfflineMessage(int userId, int dataType) {
        TalkCloudApp.StreamRequest streamRequest = TalkCloudApp.StreamRequest.newBuilder()
                .setUid(userId)
                .setDataType(dataType)
                .build();
        if (grpcConnection.getRequest() != null) {
            grpcConnection.getRequest().onNext(streamRequest);
        }
    }

    public boolean isGrpcAvailable() {
        return instance.grpcConnection.isGrpcAvailable();
    }

    public TalkCloudGrpc.TalkCloudBlockingStub getBlockingStub() {
        return grpcConnection.getBlockingStub();
    }

    public ManagedChannel getManagedChannel() {
        return grpcConnection.getManagedChannel();
    }

    public TalkCloudLocationGrpc.TalkCloudLocationBlockingStub getLocationBlockingStub() {
        return grpcConnection.getLocationBlockingStub();
    }

    public void closeGrpcConnection() {
        if (instance == null) {
            return;
        } else {
            isGrpcConnect = false;
            instance.executorService.shutdownNow();
            instance.grpcConnection.closeGrpcConnection();
            keepAlive = null;
            LogUtil.e("reconnect grpc close end");
        }
    }

    public void startGrpcConnection(String ip, int port) {
        instance.executorService = Executors.newCachedThreadPool();
        instance.grpcConnection.startGrpcConnection(ip, port);
        LogUtil.e("reconnect grpc start end");
    }



    private void reactGrpcMsg(int userId, int dataType, long timeStamp) {
        TalkCloudApp.StreamRequest grpcMsgRespondReq = TalkCloudApp.StreamRequest.newBuilder()
                .setDataType(dataType)
                .setUid(userId)
                .setTimeStamp(timeStamp)
                .build();
        if (grpcConnection.getRequest() != null) {
            grpcConnection.getRequest().onNext(grpcMsgRespondReq);
            LogUtil.e("success repsone server " + timeStamp);
        } else {
            LogUtil.e("error repsone server");
        }
    }

    public void handleSetLockGroupIdBack(int userId, int lockGroupId) {
        TalkCloudApp.SetLockGroupIdReq setLockGroupIdReq = TalkCloudApp.SetLockGroupIdReq.newBuilder()
                .setGId(lockGroupId)
                .setUId(userId)
                .build();

        try {
            executorService.submit(() -> {
                boolean isSetLockGroupIdSuccess = false;
                while (!isSetLockGroupIdSuccess) {
                    TalkCloudApp.SetLockGroupIdResp setLockGroupIdResp = GrpcConnectionController.getInstance().getBlockingStub().setLockGroupId(setLockGroupIdReq);

                    if (setLockGroupIdResp == null) {
                        LogUtil.e("Set lock group id failed");
                        isSetLockGroupIdSuccess = false;
                    } else {
                        LogUtil.i("setLockGroupIdResp=" + setLockGroupIdResp.getRes().getCode() + " msg=" + setLockGroupIdResp.getRes().getMsg());

                        if (setLockGroupIdResp.getRes().getCode() == 200) {
                            isSetLockGroupIdSuccess = true;
                        } else {
                            isSetLockGroupIdSuccess = false;
                        }

                        if (setLockGroupIdResp.getRes().getCode() == 422) {//repeat to set same id
                            isSetLockGroupIdSuccess = true;
                        }

                        /*setLockGroupIdResp=500 msg=User id or group id is not valid, please try again later.*/
                        if (setLockGroupIdResp.getRes().getCode() == 500) {
                            isSetLockGroupIdSuccess = true;//FIXME
                        }
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//    private long lastRecvAckTime = System.currentTimeMillis() / 1000;
    private final int default_keepAlive_interval = 5;
    private int grpcHeartReceiveCount = 0;
    private int grpcHeartCompareCount = -1;
    private void keepAlive() {
        LogUtil.i("keepalive " + (keepAlive != null));
        if (keepAlive != null && keepAlive.isAlive())
            return;

        keepAlive = new Thread(()-> {
            while (!isShutDown) {
                try {
                    /*Sometimes we thought constantly lost two or more heartbeat replies that indicates lost connection to server, go to reconnect needed.*/
                    if (instance != null && !instance.isGrpcAvailable()) {//grpc需要重新建立channel
                        LogUtil.i("heartBeat catch error1"+ " heartId=" + Thread.currentThread().getId());
                        ifReconnect();
                        return;
                    } else if (grpcHeartCompareCount >= grpcHeartReceiveCount) {
                        LogUtil.i("heartBeat catch error2"+ " heartId=" + Thread.currentThread().getId());
                        ifReconnect();
                        return;
                    } else {
                        LogUtil.i("Grpc sent heartbeat: "
                                + "isGrpcConnect(" + isGrpcConnect + ")"
                                + "isGrpcConnecting(" + isConnectRunning + ")"
                                + "grpcHeartCompareCount(" + grpcHeartCompareCount + ")"
                                + "grpcHeartReceiveCount("+grpcHeartReceiveCount+")" + " heartId=" + Thread.currentThread().getId());
                        grpcHeartCompareCount = grpcHeartReceiveCount;
                        sentGrpcHeartBeat();
                        TimeUnit.SECONDS.sleep(default_keepAlive_interval);
                    }
                } catch (InterruptedException ex) {
                    try {
                        TimeUnit.SECONDS.sleep(default_keepAlive_interval);
                    } catch (InterruptedException ex2){
                        ex2.printStackTrace();
                    }
                    ex.printStackTrace();
                }
            }
        });

        keepAlive.start();
    }

    private void sentGrpcHeartBeat() {
        /*Heartbeat message for keeping alive*/
        DeviceControl deviceControl = new DeviceControl(JimipttConfig.getAppContext());
        DeviceInfo deviceInfo = deviceControl.getDeviceDetail(JimipttConfig.getAppContext());
        talk_cloud.TalkCloudModel.DeviceInfo device = null;
        if (deviceInfo != null) {
            device = talk_cloud.TalkCloudModel.DeviceInfo.newBuilder().setBattery(deviceInfo.getBattery()).build();
        }
        TalkCloudApp.StreamRequest keepAliveReq = TalkCloudApp.StreamRequest.newBuilder().setUid(UserBean.getInstance().getUid()).setDataType(4).setDeviceInfo(device).build();

        if (grpcConnection.getRequest() != null) {
            grpcConnection.getRequest().onNext(keepAliveReq);
        }
    }

    //以下场景开启重连： 1 发心跳前判断连接状态有问题 2 收到服务器反馈type=0消息 3 收到服务器消息type=20（ips切换消息） 4 onerror(视情况操作)
    //重连过程中 gps补传一直在进行
    public void ifReconnectForNetWorkMonitor() {
        netWorkRework();
        LogUtil.i("isConnectRunning:"+isConnectRunning +"  isAfterFirtHeartBeat="+isAfterFirtHeartBeat );
        if (!isConnectRunning && isAfterFirtHeartBeat && !executorService.isShutdown()) {
            executorService.execute(() -> reconnect());
        }
    }

    public void netWorkProblem() {
        isShutDown = true;
    }

    public void netWorkRework() {
        isShutDown = false;
    }

    private void ifReconnect() {
        LogUtil.i("isConnectRunning:"+isConnectRunning +"  isShutDown="+isShutDown );
        if (!isConnectRunning && !isShutDown) {
            reconnect();
        }
    }

    private int reconnectDelay = 0;
    public void reconnect() {
        LogUtil.i("grpc reconnect");
        grpcHeartCompareCount = -1;
        grpcHeartReceiveCount = 0;
        isConnectRunning = true;
        closeGrpcConnection();
        try {
            TimeUnit.SECONDS.sleep(++reconnectDelay);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        startGrpcConnection(conIp,conPort);
        if (!isLoginRunning) {
            LogUtil.i("reLogin");

            try {
                JSONObject result = login(
                        SPUtil.getUserAccount(),
                        SPUtil.getPassword(),
                        SPUtil.getServer(),
                        SPUtil.getDataPort(),
                        AppTool.packageName(JimipttConfig.getAppContext()));

                if (result.getBoolean("login")) {
                    SPUtil.setGrpcSessionId(result.getString("sessionID"));
                } else {
                    if (result.has("errorMsg")) {
                        LogUtil.e(result.getString("errorMsg"));
                    }
                }
            } catch (JSONException ex) {
                ex.printStackTrace();
            }
        }
        startGrpcStreamReceiver();
        isConnectRunning = false;
    }

    public void updateLocalInfoWithLoginRsp(TalkCloudApp.LoginRsp loginRsp) {
        UserBean.getInstance().setUserBeanObj(loginRsp);

        for (TalkCloudModel.GroupInfo groupInfo : loginRsp.getGroupListList()) {
            LogUtil.e(groupInfo.getGid() + " " + groupInfo.getStatus());
        }

        SPUtil.setGrpcSessionId(loginRsp.getSessionId());
    }

    public JSONObject login(String account, String password, String serverIp, int serverPort, String appVersion){
        SPUtil.setUserAccount(account);
        SPUtil.setPassword(password);

        boolean isLoginSuccess = false;
        isLoginRunning = true;
        String sessionID = "";
        String errorMsg = "";

        if (!isGrpcAvailable()){
            try {
                initGrpcConnection(serverIp, serverPort);
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }

        LogUtil.e("account=" + account + ", password=" + password + ", serverIp=" + serverIp + ", appVersion=" + appVersion);
        TalkCloudApp.LoginReq loginReq = TalkCloudApp.LoginReq.newBuilder()
                .setName(account)
                .setPasswd(password)
                .setGrpcServer(serverIp)
                .setAppVersion(appVersion)
                .build();

        try {
            TalkCloudApp.LoginRsp loginRsp = GrpcConnectionController.getInstance().getBlockingStub().login(loginReq);
            if (loginRsp != null) {
                if (loginRsp.getRes().getCode() == 200) {
                    isLoginSuccess = true;
                    LogUtil.d("reLogin success");
                    sessionID = loginRsp.getSessionId();

                    updateLocalInfoWithLoginRsp(loginRsp);
                } else {
                    LogUtil.e(loginRsp.getRes().getMsg());
                    errorMsg = loginRsp.getRes().getMsg();
                }
            } else {
                LogUtil.e("Login response is null");
                errorMsg = "Login response is null";
            }
        } catch (Exception e) {
            e.printStackTrace();
            errorMsg = e.getMessage();
        }

        isLoginRunning = false;

        JSONObject result = new JSONObject();
        try {
            result.put("login", isLoginSuccess);
            result.put("sessionID", sessionID);
            result.put("errorMsg", errorMsg);
        } catch (JSONException ex) {
            ex.printStackTrace();
        }

        return result;
    }

    public void updateGroupInfo(int gid) {
        TalkCloudApp.GetGroupInfoReq getGroupInfoReq = TalkCloudApp.GetGroupInfoReq.newBuilder()
                .setGid(gid)
                .setUid(UserBean.getInstance().getUid())
                .build();

        try {
            executorService.submit( () -> {
                TalkCloudApp.GetGroupInfoResp getGroupInfoResp = GrpcConnectionController.getInstance().getBlockingStub().getGroupInfo(getGroupInfoReq);

                if (getGroupInfoResp == null) {
                    LogUtil.e("get group info resp is null");
                    return;
                }

                if (getGroupInfoResp.getRes().getCode() != 200) {
                    LogUtil.e("get group info resp result code is incorrect, code=" + getGroupInfoResp.getRes().getCode() + " msg=" + getGroupInfoResp.getRes().getMsg());
                    return;
                }

                for (GroupBean group : UserBean.getInstance().getGroups()) {
                    if (group.getGroupId() == gid) {
                        group.setUserGroupBeanObj(getGroupInfoResp.getGroupInfo());

                        for (FriendBean friendBean : group.getMembersList()) {
                            LogUtil.d("---------->>> " + friendBean.toString());
                        }

                        break;
                    }
                }

                if (UserBean.getInstance().isTempGroupExisted()) {
                    if (gid == UserBean.getInstance().getTempGroup().getGroupId()) {
                        UserBean.getInstance().getTempGroup().setUserGroupBeanObj(getGroupInfoResp.getGroupInfo());

                        for (FriendBean friendBean : UserBean.getInstance().getTempGroup().getMembersList()) {
                            LogUtil.d("---------->>>> " + friendBean.toString());
                        }
                    }
                }

                AppTool.sendBroadcast("jimi", "update_group_member", ""+gid);
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateAllGroupsInfo() {
        TalkCloudApp.GrpListReq grpListReq = TalkCloudApp.GrpListReq.newBuilder().setUid(UserBean.getInstance().getUid()).build();

        try {
            executorService.submit( () -> {
                TalkCloudApp.GroupListRsp groupListRsp = GrpcConnectionController.getInstance().getBlockingStub().getGroupList(grpListReq);

                if (groupListRsp == null) {
                    LogUtil.e("get groupListRsp is null");
                    return;
                }

                if (groupListRsp.getRes().getCode() != 200) {
                    LogUtil.e("get groupListRsp result code is incorrect, code=" + groupListRsp.getRes().getCode() + " msg=" + groupListRsp.getRes().getMsg());
                    return;
                }

                // Updating User's info
                List<GroupBean> groupBeanArrayList = new ArrayList<>();
                for (TalkCloudModel.GroupInfo groupRecord : groupListRsp.getGroupListList()) {
                    if (groupRecord.getStatus() == 1) {
                        GroupBean groupBean = new GroupBean();
                        groupBean.setUserGroupBeanObj(groupRecord);

                        groupBeanArrayList.add(groupBean);
                    }
                }

                UserBean.getInstance().setGroups(groupBeanArrayList);

                AppTool.sendBroadcast("jimi", "update_group_list", "");
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean sendGpsData(TalkCloudLocationOuterClass.Device device, TalkCloudLocationOuterClass.Location location) {
        if (!isGrpcAvailable() || !isGrpcConnect || executorService.isShutdown()) {
            LogUtil.e("Grpc is not available");
            return false;
        }

        TalkCloudLocationOuterClass.ReportDataReq dataReq = TalkCloudLocationOuterClass.ReportDataReq.newBuilder()
                .setDataType(1)
                .setIMei(UserBean.getInstance().getImei())
                .setDeviceInfo(device)
                .setLocationInfo(location)
                .build();

        Future<TalkCloudLocationOuterClass.ReportDataResp> reportDataRespFuture = executorService.submit(
                ()-> GrpcConnectionController.getInstance().getLocationBlockingStub().reportGPSData(dataReq)
        );

        try {
            TalkCloudLocationOuterClass.ReportDataResp resp = reportDataRespFuture.get(2, TimeUnit.SECONDS);

            if (resp != null && resp.getRes().getCode() == 200) {
                LogUtil.d(System.currentTimeMillis()/1000 + " 发送成功");
                return true;
            } else {
                LogUtil.d(System.currentTimeMillis()/1000 + " 发送失败");
                return false;
            }
        } catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
            return false;
        }
    }
}