package com.jimi.jimitalk.bean;

import com.jimi.jimitalk.tools.LogUtil;
import com.jimi.jimitalk.tools.SPUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import talk_cloud.TalkCloudApp;
import talk_cloud.TalkCloudLocationOuterClass;
import talk_cloud.TalkCloudModel;

/**
 * @author Administrator
 * @date 2020/4/17
 */
public class UserBean implements Serializable {
    private String imei;
    private int uid;
    private String nickName;
    private int type;
    private int dispatcherId;
    private int lockGid = -1;

    private List<GroupBean> groups = new LinkedList<>();

    private TalkCloudLocationOuterClass.Location location;

    private GroupBean tempGroup = null;

    private static UserBean instance = new UserBean();

    public static UserBean getInstance() {
        if (instance == null) {
            synchronized (UserBean.class) {
                if (instance == null) {
                    instance = new UserBean();
                }
            }
        }

        return instance;
    }

    public static void clearUserBean() {
        if (instance != null) {
            instance = null;
        }
    }

    public void setUserBeanObj(TalkCloudApp.LoginRsp loginRsp) {
        TalkCloudModel.Member userInfo = loginRsp.getUserInfo();

        this.imei = userInfo.getIMei();
        this.uid = userInfo.getId();
        this.nickName = userInfo.getNickName();
        this.type = userInfo.getUserType();
        this.dispatcherId = userInfo.getAccountId();
        this.lockGid = userInfo.getLockGroupId();

        // Room changed while network is unavailable, sync
        if (SPUtil.isLockGidValid()) {
            if (SPUtil.getLockGid() != this.lockGid) {
                boolean isLocalLockGidExisted = false;

                for (GroupBean group : this.groups) {
                    if (group.getGroupId() == SPUtil.getLockGid()) {
                        isLocalLockGidExisted = true;
                        break;
                    }
                }

                if (isLocalLockGidExisted) {
                    this.lockGid = SPUtil.getLockGid();
                } else {
                    SPUtil.setLockGid(this.lockGid);
                }
            }
        }

        List<GroupBean> groupBeanList = new ArrayList<>();
        for (TalkCloudModel.GroupInfo groupInfo : loginRsp.getGroupListList()) {
            LogUtil.e(groupInfo.toString());
            if (1 == groupInfo.getStatus()) {
                GroupBean groupBean = new GroupBean();
                groupBean.setUserGroupBeanObj(groupInfo);

                groupBeanList.add(groupBean);
            }
        }

        setGroups(groupBeanList);
    }

    public String getImei() {
        return imei;
    }

    public int getUid() {
        return uid;
    }

    public String getNickName() {
        return nickName;
    }

    public int getType() {
        return type;
    }

    public int getDispatcherId() {
        return dispatcherId;
    }

    public int getLockGid() {
        return lockGid;
    }

    public List<GroupBean> getGroups() {
        return groups;
    }

    public TalkCloudLocationOuterClass.Location getLocation() {
        return location;
    }

    public GroupBean getTempGroup() {
        return tempGroup;
    }

    public synchronized void setLockGid(int lockGid) {
        this.lockGid = lockGid;

        for (GroupBean group : this.groups) {
            if (this.lockGid == group.getGroupId()) {
                group.setWeights(1);
                break;
            }
        }

        SPUtil.setLockGid(this.lockGid);
    }

    public synchronized void setTempGroup(GroupBean tempGroup) {
        this.tempGroup = tempGroup;
    }

    public void setGroups(List<GroupBean> groups) {
        this.groups = groups;
    }

    public synchronized void setLocation(TalkCloudLocationOuterClass.Location location) {
        this.location = location;
    }

    public synchronized boolean isTempGroupExisted() {
        return null != tempGroup;
    }

    public synchronized boolean isLockGidExisted() {
        boolean flag = false;

        for (GroupBean group : this.groups) {
            if (group.getGroupId() == this.lockGid) {
                flag = true;
                break;
            }
        }

        return flag;
    }
}
