package com.jimi.jimitalk.bean;

import com.jimi.jimitalk.tools.AppTool;
import com.jimi.jimitalk.tools.DBUtil;
import com.jimi.jimitalk.tools.LogUtil;
import com.jimi.jimitalk.tools.ThreadUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import talk_cloud.TalkCloudModel.DeviceInfo;
import talk_cloud.TalkCloudModel.GroupInfo;

public class GroupBean implements Serializable {
    private String groupName;
    private int groupId;
    private int groupOwnerId;
    private int weights = 0;
    private int type;          // Temp(2) or Normal(1)

    private List<FriendBean> dispatchersList = new ArrayList<>();
    private List<FriendBean> managersList = new ArrayList<>();
    private List<FriendBean> membersList = new ArrayList<>();
    private List<TalkMessage> talkHistoryList = new ArrayList<>();

    public static final int ONLINE_AND_JANUS_ON = 3;

    public static final int ONLINE = 2;

    public static final int OFFLINE = 1;

    public static final int GROUP_ROLE_OWNER = 3;

    public static final int GROUP_ROLE_MANAGER = 2;

    public static final int GROUP_ROLE_NORMAL = 1;

    public static final int USER_TYPE_DISPATCHER = 2;
    public static final int HISTORY_TALK_MESSAGE_STORE_LIMIT = 10;

    public static final int USER_TYPE_NORMAL = 1;

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getGroupId() {
        return groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    } //fixme

    public int getGroupOwnerId() {
        return groupOwnerId;
    }

    public List<TalkMessage> getTalkHistoryList() {
        return talkHistoryList;
    }

    public void setTalkHistoryList(List<TalkMessage> talkHistoryList) {
        this.talkHistoryList = talkHistoryList;
    }

    public List<FriendBean> getDispatchersList() {
        return dispatchersList;
    }

    public void setDispatchersList(List<FriendBean> dispatchersList) {
        this.dispatchersList = dispatchersList;
    }

    public List<FriendBean> getManagersList() {
        return managersList;
    }

    public void setManagersList(List<FriendBean> managersList) {
        this.managersList = managersList;
    }

    public List<FriendBean> getMembersList() {
        return membersList;
    }

    public void setMembersList(List<FriendBean> membersList) {
        this.membersList = membersList;
    }

    public int getTotalMembersCount() {
        return membersList.size();
    }

    public int getOnlineMembersCountLocal() {
        int count = 0;

        for (FriendBean friendBean : membersList) {
            if (friendBean.getOnline() == ONLINE || friendBean.getOnline() == 3) {
                count++;
            }
        }

        return count;
    }

    // JANUS连接到该数组的成员数
    public int getJanusOnlineMembersCountLocal() {
        int count = 0;

        for (FriendBean friendBean : membersList) {
            if (friendBean.getOnline() == ONLINE_AND_JANUS_ON) {
                count++;
            }

            // Dispatcher online code always 1 or 2, 2 indicate online both janus and grpc. fixme
            // Dispatcher is group owner only.
            if (friendBean.getGroupRole() == GROUP_ROLE_OWNER && friendBean.getOnline() == ONLINE) {
                count++;
            }
        }

        return count;
    }

    public synchronized void setUserGroupBeanObj(GroupInfo groupInfo) {
        this.groupId = groupInfo.getGid();
        this.groupName = groupInfo.getGroupName();
        this.groupOwnerId = groupInfo.getGroupOwner();
        this.type = groupInfo.getStatus();
        this.membersList.clear();
        this.dispatchersList.clear();
        this.managersList.clear();

        for (DeviceInfo deviceInfo : groupInfo.getUserListList()) {
            FriendBean friendBean = new FriendBean();
            friendBean.setFriendBeanObjByDeviceInfo(deviceInfo);

            if (friendBean.getUserType() == USER_TYPE_DISPATCHER) {
                dispatchersList.add(friendBean);
                continue;
            }

            if (friendBean.getGroupRole() == GROUP_ROLE_MANAGER || friendBean.getGroupRole() == GROUP_ROLE_OWNER) {
                managersList.add(friendBean);
                continue;
            }

            this.membersList.add(friendBean);
        }

        // In order to sort view list as dispatchers->managers->normals todo
        this.membersList.addAll(0, managersList);
        this.membersList.addAll(0, dispatchersList);

        this.talkHistoryList.clear();
//        this.talkHistoryList.addAll(SPUtil.getPttMessages(this.groupId));
        this.talkHistoryList.addAll(DBUtil.ChatDBManager.getInstance().getPttRecordByGroupId(this.groupId));
        Collections.sort(this.talkHistoryList, new Comparator<TalkMessage>() {
            @Override
            public int compare(TalkMessage o1, TalkMessage o2) {
                return (int)(o2.getTimestamp() - o1.getTimestamp());
            }
        });

        LogUtil.d("history size=" + this.talkHistoryList.size());
        for (TalkMessage talkMessage : this.talkHistoryList) {
            LogUtil.d(talkMessage.toString());
        }

        try {
            if (UserBean.getInstance().getLockGid() == groupInfo.getGid()) {
                this.weights = 1;
            } else {
                this.weights = 0;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void appendTalkHistory(TalkMessage talkMessage) {
        this.talkHistoryList.add(0, talkMessage);

        if (this.talkHistoryList.size() > HISTORY_TALK_MESSAGE_STORE_LIMIT) {
            this.talkHistoryList.remove(HISTORY_TALK_MESSAGE_STORE_LIMIT);
        }

        ThreadUtils.getInstance().getNewSingleThreadExecutor().execute(() ->
            DBUtil.ChatDBManager.getInstance().addPttRecord(talkMessage)
        );

        AppTool.sendBroadcast("jimi", "update_ptt_record", this.groupId+"");
    }

    public int getWeights() {
        return weights;
    }

    public void setWeights(int weights) {
        this.weights = weights;
    }

    public int getType() {
        return type;
    }
}
