package com.jimi.jimitalk.bean;

import java.io.Serializable;

import talk_cloud.TalkCloudApp;
import talk_cloud.TalkCloudModel.DeviceInfo;

public class FriendBean implements Serializable {
    private String friendName;
    private int friendId;
    private int online;        //1 offline 2 online 3 online & janus on
    private int groupRole;     //3 owner 2 manager 1 normal
    private int userType;      //2 dispatcher 1 normal
    private String deviceType; //JW10/T28

    public String getFriendName() {
        return friendName;
    }

    public void setFriendName(String friendName) {
        this.friendName = friendName;
    }

    public int getFriendId() {
        return friendId;
    }

    public void setFriendId(int friendId) {
        this.friendId = friendId;
    }

    public int getOnline() {
        return online;
    }

    public void setOnline(int online) {
        this.online = online;
    }

    public int getGroupRole() {
        return groupRole;
    }

    public void setGroupRole(int groupRole) {
        this.groupRole = groupRole;
    }

    public void setFriendBeanObjByDeviceInfo(DeviceInfo deviceInfo) {
        this.friendName = deviceInfo.getNickName();
        this.friendId = deviceInfo.getId();
        this.groupRole = deviceInfo.getGrpRole();
        this.online = deviceInfo.getOnline();
        this.userType = deviceInfo.getUserType();
        this.deviceType = deviceInfo.getDeviceType();
    }

    public void setFriendBeanObjByFriendRecord(TalkCloudApp.FriendRecord friendRecord) {
        this.friendName = friendRecord.getName();
        this.friendId = friendRecord.getUid();
    }

    public int getUserType() {
        return userType;
    }

    public void setUserType(int userType) {
        this.userType = userType;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    @Override
    public String toString() {
        return "{" +
                "friendName='" + friendName + '\'' +
                ", friendId=" + friendId + '\'' +
                ", online=" + online + '\'' +
                ", groupRole=" + groupRole + '\'' +
                ", userType=" + userType + '\'' +
                ", deviceType='" + deviceType + '\'' +
                '}';
    }
}
