package com.jimi.jimitalk.activity;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.MediaPlayer;
import android.media.MediaScannerConnection;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.support.annotation.RequiresApi;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Chronometer;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.jimi.jimitalk.R;
import com.jimi.jimitalk.bean.UserBean;
import com.jimi.jimitalk.ptt.api.IJanusSessionMessageCallbacks;
import com.jimi.jimitalk.ptt.api.JanusSessionController;
import com.jimi.jimitalk.ptt.api.MyControlCallBack;
import com.jimi.jimitalk.ptt.api.VideoCallController;
import com.jimi.jimitalk.ptt.webrtc.ProxyVideoSink;
import com.jimi.jimitalk.tools.AppTool;
import com.jimi.jimitalk.tools.FileCompress;
import com.jimi.jimitalk.tools.JimipttConfig;
import com.jimi.jimitalk.tools.LogUtil;
import com.jimi.jimitalk.tools.NetworkUtils;
import com.jimi.jimitalk.tools.ToastUtil;
import com.jimi.jimitalk.tools.UploadFileUtils;
import com.jimi.jimitalk.tools.recorder.RTCAudioRecordThread;
import com.jimi.jimitalk.tools.recorder.ScreenRecorder;

import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.AudioTrack;
import org.webrtc.MediaStream;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceViewRenderer;
import org.webrtc.VideoTrack;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class VideoCallActivity extends BaseActivity
        implements
        MyControlCallBack, IJanusSessionMessageCallbacks, RTCAudioRecordThread.RTCAudioRecordCallback, ScreenRecorder.ScreenRecorderCallback {
    private LinearLayout layoutHangup;
    private LinearLayout layoutCancel;
    private LinearLayout layoutAccept;

    private LinearLayout layoutHead;

    private TextView tvName;
    private Chronometer tvTime;
    private TextView tvHangup;

    private SurfaceViewRenderer local_view;
    private SurfaceViewRenderer remote_view;
    private ProxyVideoSink localRender;
    private ProxyVideoSink remoteRender;

    private boolean isSwappedFeeds;

    private boolean isCaller;
    private boolean isVideo;
    private String remoteName;
    private int remoteId;

    private boolean isConnected = false;

    private CountDownTimer timer;
    private MediaPlayer mediaPlayer;

    private LinearLayout mLlBtnSwitchCamera;

    private ScreenRecorder mScreenRecorder;
    private LinearLayout mLlBtnPrtSc;
    private LinearLayout mLlBtnRecMedia;
    private boolean isMediaRecording = false;

    private long lastBtnPrtScPressed = System.currentTimeMillis();
    private long lastBtnRecMediaPressed = System.currentTimeMillis();

    RTCAudioRecordThread rtcAudioRecordThread = new RTCAudioRecordThread(this);

    BroadcastReceiver receiver;

    private final int REC_REQUEST_CODE = 1000;
    private final int SHOT_REQUEST_CODE = 1001;

    private void bindBroadcastReceiver() {
        final String SYS_NET_CONNECTION_STATE_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";
        final String JIMI = "jimi";

        receiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();

                //网络状态
                if (SYS_NET_CONNECTION_STATE_CHANGE.equals(action)) {
                    //网络状态
                    if (!NetworkUtils.isNetWorkAvailable(JimipttConfig.getAppContext())) {
                        finish();
                    }
                }

                if (JIMI.equals(action)) {
                    try {
                        JSONObject content = new JSONObject(intent.getStringExtra("content"));
                        String key = content.getString("key");
                        String value = content.getString("value");

                        if (key.equals("temp_group")) {
                            if (value.equals("created")) {
                                if (VideoCallController.getInstance().isConnected()) {
                                    VideoCallController.getInstance().hangup();
                                } else {
                                    if (NetworkUtils.isNetWorkAvailable(JimipttConfig.getAppContext())) {
                                        if (isCaller) {
                                            VideoCallController.getInstance().sendUserCall(remoteId, 2, isVideo, 3);
                                        } else {
                                            VideoCallController.getInstance().sendUserCall(remoteId, 1, isVideo, 1);
                                        }
                                    }

                                    finish();
                                }
                            }
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        };

        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(SYS_NET_CONNECTION_STATE_CHANGE);
        intentFilter.addAction(JIMI);
        registerReceiver(receiver, intentFilter);
    }

    private void unbindBroadcastReceiver() {
        if (receiver != null) {
            unregisterReceiver(receiver);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        System.setProperty("java.net.preferIPv6Addresses", "false");
        System.setProperty("java.net.preferIPv4Stack", "true");

        getWindow().addFlags(
                WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED |
                WindowManager.LayoutParams.FLAG_FULLSCREEN |
                WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON |
                WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);

        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.activity_video_call);

        AppTool.sendBroadcast("jimi", "videoCall", "video_activity_created");

        VideoCallController.getInstance().registerMyControlCallBack(this);
        JanusSessionController.getInstance().registerMessageCallbacks(this);

        Bundle bundle = this.getIntent().getExtras();
        assert bundle != null;
        isCaller = bundle.getBoolean("isCaller");
        isVideo = bundle.getBoolean("isVideo");
        remoteName = bundle.getString("remoteName");
        remoteId = bundle.getInt("remoteId");
        LogUtil.d("isCaller=" + isCaller + " isVideo=" + isVideo + " remoteName=" + remoteName + " remoteId=" + remoteId);

        local_view = findViewById(R.id.local_view_render);
        remote_view = findViewById(R.id.remote_view_render);

        layoutHead = findViewById(R.id.audio_call_layout_head);

        layoutHangup = findViewById(R.id.audio_call_hangup);
        layoutHangup.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (isConnected) {
                    if (NetworkUtils.isNetWorkAvailable(JimipttConfig.getAppContext())) {
                        VideoCallController.getInstance().hangup();
                    }
                } else {
                    VideoCallController.getInstance().sendUserCall(remoteId, 1, isVideo, 1);
                }
                finish();
            }
        });

        layoutCancel = findViewById(R.id.audio_call_cancel);
        layoutCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (NetworkUtils.isNetWorkAvailable(JimipttConfig.getAppContext())) {
                    VideoCallController.getInstance().sendUserCall(remoteId, 2, isVideo, 3);
                }

                finish();
            }
        });

        layoutAccept = findViewById(R.id.audio_call_accept);
        layoutAccept.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                layoutHangup.setVisibility(View.VISIBLE);
                layoutCancel.setVisibility(View.GONE);
                layoutAccept.setVisibility(View.GONE);

                VideoCallController.getInstance().sendUserCall(remoteId, 1, isVideo, 2);
            }
        });

        mLlBtnSwitchCamera = findViewById(R.id.audio_call_cutover);
        mLlBtnSwitchCamera.setVisibility(View.GONE);
        mLlBtnSwitchCamera.setOnClickListener(view -> {
            VideoCallController.getInstance().switchCamera();
        });

        mLlBtnPrtSc = findViewById(R.id.print_screen);
        mLlBtnPrtSc.setVisibility(View.GONE);
        mLlBtnPrtSc.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                long curTime = System.currentTimeMillis();
                if ((curTime - lastBtnPrtScPressed) < 1000) {
                    ToastUtil.show("Frequent operations", 0);
                    return;
                }
                screenShot();
                lastBtnPrtScPressed = curTime;
            }
        });

        mLlBtnRecMedia = findViewById(R.id.record_media);
        mLlBtnRecMedia.setVisibility(View.GONE);
        mLlBtnRecMedia.setOnClickListener(new View.OnClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.O)
            @Override
            public void onClick(View v) {
                long curTime = System.currentTimeMillis();
                if ((curTime - lastBtnRecMediaPressed) < 3000) {
                    ToastUtil.show("Frequent operations", 0);
                    return;
                }

                if (isMediaRecording) {
                    if (isVideo) {
                        ToastUtil.show("Stop video recording", 0);
                        stopScreenRecording();
                    } else {
                        ToastUtil.show("Stop audio recording", 0);
                        rtcAudioRecordThread.exit();
                    }
                    isMediaRecording = false;
                } else {
                    if (isVideo) {
                        ToastUtil.show("Start video recording", 0);
                        startScreenRecording();
                    } else {
                        ToastUtil.show("Start audio recording", 0);
                        if (!rtcAudioRecordThread.isStarted()) {
                            rtcAudioRecordThread.start();
                        }
                    }
                    isMediaRecording = true;
                }
                lastBtnRecMediaPressed = curTime;
            }
        });

        tvName = findViewById(R.id.audio_call_name);
        tvTime = findViewById(R.id.audio_call_time);
        tvTime.setOnChronometerTickListener(chronometer ->  {
                LogUtil.d("Chronometer ticking");
                long elapsedMillis = SystemClock.elapsedRealtime() - chronometer.getBase();
                if(elapsedMillis > 3600000L && elapsedMillis < 36000000L){
                    chronometer.setFormat("0%s");
                }else{
                    chronometer.setFormat("00:%s");
                }
        });
        tvHangup = findViewById(R.id.audio_call_cancel_text);

        // 本地图像初始化
        local_view.init(JimipttConfig.getRootEglbase().getEglBaseContext(), null);
        local_view.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT);
        local_view.setEnableHardwareScaler(true);
        local_view.setMirror(true);
        /**
        public void setZOrderOnTop (boolean onTop)

        Added in API level 5

        Control whether the surface view's surface is placed on top of its window. Normally it is
        placed behind the window, to allow it to (for the most part) appear to composite with the
        views in the hierarchy. By setting this, you cause it to be placed above the window.
        This means that none of the contents of the window this SurfaceView is in will be visible
        on top of its surface.

        Note that this must be set before the surface view's containing window is attached to the window manager.

        Calling this overrides any previous call to setZOrderMediaOverlay(boolean).
         */
        local_view.setZOrderOnTop(true);
        localRender = new ProxyVideoSink();
        // 远端图像初始化
        remote_view.init(JimipttConfig.getRootEglbase().getEglBaseContext(), null);
        remote_view.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_BALANCED);
        remote_view.setMirror(true);
        remote_view.setEnableHardwareScaler(true);
        remoteRender = new ProxyVideoSink();
        setSwappedFeeds(false);

        local_view.setOnClickListener(v -> {
            setSwappedFeeds(!isSwappedFeeds);
        });

        if(isVideo){
            layoutHead.setVisibility(View.VISIBLE);
            local_view.setVisibility(View.VISIBLE);
            remote_view.setVisibility(View.VISIBLE);
            if (!isCaller) {
                tvName.setText(new StringBuffer(remoteName + " send a video invitation"));
            }else {
                tvName.setText(remoteName);
            }
        }else{
            layoutHead.setVisibility(View.VISIBLE);
            local_view.setVisibility(View.GONE);
            remote_view.setVisibility(View.GONE);
            if (!isCaller) {
                tvName.setText(new StringBuffer(remoteName + " send a voice invitation"));
            }else {
                tvName.setText(remoteName);
            }
        }

        //判断主呼叫和被呼叫
        if(isCaller) {
            layoutHangup.setVisibility(View.GONE);
            layoutCancel.setVisibility(View.VISIBLE);
            layoutAccept.setVisibility(View.GONE);

            // 发送 user_call信令 先协商是否，成功之后 TODO
            VideoCallController.getInstance().sendUserCall(remoteId,0, isVideo,0);
        }else {
            layoutHangup.setVisibility(View.VISIBLE);
            layoutCancel.setVisibility(View.GONE);
            layoutAccept.setVisibility(View.VISIBLE);
        }

        timer = new CountDownTimer(30000 + 500,1000) {
            @Override
            public void onTick(long millisUntilFinished) {
                LogUtil.d("timer ticking " + millisUntilFinished / 1000 + "s");
            }

            @Override
            public void onFinish() {
                LogUtil.d("timer stop counting, hangup auto");
                VideoCallController.getInstance().hangup();
            }
        };
        timer.start();

        mediaPlayer = MediaPlayer.create(getApplicationContext(), R.raw.call_new);
        mediaPlayer.start();
        mediaPlayer.setLooping(true);

        bindBroadcastReceiver();
    }

    private void startScreenRecording() {
        MediaProjectionManager mediaProjectionManager = (MediaProjectionManager) getSystemService(Context.MEDIA_PROJECTION_SERVICE);
        Intent permissionIntent = mediaProjectionManager.createScreenCaptureIntent();
        startActivityForResult(permissionIntent, REC_REQUEST_CODE);
    }

    private void stopScreenRecording() {
        if(mScreenRecorder != null) {
            mScreenRecorder.quit();
            mScreenRecorder = null;
        }
    }

    private void screenShot() {
        MediaProjectionManager mediaProjectionManager = (MediaProjectionManager) getSystemService(Context.MEDIA_PROJECTION_SERVICE);
        Intent permissionIntent = mediaProjectionManager.createScreenCaptureIntent();
        startActivityForResult(permissionIntent, SHOT_REQUEST_CODE);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if(requestCode == REC_REQUEST_CODE) {
            if (resultCode == RESULT_OK) {
                if (JimipttConfig.getMediaProjection() == null) {
                    MediaProjection mediaProjection = ((MediaProjectionManager) getSystemService(Context.MEDIA_PROJECTION_SERVICE)).getMediaProjection(resultCode, data);
                    JimipttConfig.setMediaProjection(mediaProjection);
                }

                // Get display metrics
                WindowManager windowManager = (WindowManager)getSystemService(Context.WINDOW_SERVICE);
                DisplayMetrics metrics = new DisplayMetrics();
                windowManager.getDefaultDisplay().getMetrics(metrics);
                int screenWidth = metrics.widthPixels;
                int screenHeight = metrics.heightPixels;
                int screenDensity = metrics.densityDpi;

                LogUtil.e("width=" + screenWidth + " height=" + screenHeight);

                // Get current time
                @SuppressLint("SimpleDateFormat") SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                Date curDate = new Date(System.currentTimeMillis());
                String curTime = formatter.format(curDate).replace(" ", "");

                File videoFile = new File(Environment.getExternalStorageDirectory() + File.separator + curTime + ".mp4");
                if (JimipttConfig.getMediaProjection() != null) {
                    mScreenRecorder = new ScreenRecorder(
                            screenWidth,
                            screenHeight,
                            2000000,
                            1,
                            JimipttConfig.getMediaProjection(), videoFile.getAbsolutePath(),
                            this);
                    mScreenRecorder.start();
                } else {
                    LogUtil.e("Invalid media projection");
                }
            }
        }

        if (requestCode == SHOT_REQUEST_CODE) {
            if (resultCode == RESULT_OK) {
                if (JimipttConfig.getMediaProjection() == null) {
                    MediaProjection mediaProjection = ((MediaProjectionManager) getSystemService(Context.MEDIA_PROJECTION_SERVICE)).getMediaProjection(resultCode, data);
                    JimipttConfig.setMediaProjection(mediaProjection);
                }

                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        String filePath = AppTool.screenShot(JimipttConfig.getMediaProjection(), JimipttConfig.getAppContext());

                        LogUtil.e(filePath);
                        File screenShotFile = new File(filePath);
                        UploadFileUtils.UploadFile picture = new UploadFileUtils.UploadFile(
                                UserBean.getInstance().getUid(),
                                UserBean.getInstance().getLockGid(),
                                screenShotFile.getName(),
                                3,
                                screenShotFile);

                        int count = 3; // TODO If upload failed, repeat three times
                        boolean uploadRst;
                        do {
                            uploadRst = UploadFileUtils.uploadFile(picture);
                            --count;
                        } while (count != 0 && !uploadRst);
                    }
                }).start();
            }
        }
    }

    private void setSwappedFeeds(boolean isSwappedFeeds) {
        this.isSwappedFeeds = isSwappedFeeds;
        localRender.setTarget(isSwappedFeeds ? remote_view : local_view);
        remoteRender.setTarget(isSwappedFeeds ? local_view : remote_view);
    }

    @Override
    public void janusServer(int code, String msg) {
        LogUtil.d("code=" + code + " msg=" + msg);
    }

    @Override
    public void janusServerRecKeepalive(int code, JSONObject recKeepaliveMsg) {

    }

    @Override
    public void showMessage(JSONObject msg, JSONObject jsepLocal) {
        LogUtil.d("msg=" + msg + " jsepLocal=" + jsepLocal);

        try {
            if (msg.has("videocall")) {
                if (msg.has("result")) {
                    JSONObject jsonResult = msg.getJSONObject("result");

                    if (jsonResult.has("event") && jsonResult.getString("event").equals("incomingcall")) {
                        VideoCallController.getInstance().createPeerConnectionFactory(getApplicationContext(), true, isVideo);
                        VideoCallController.getInstance().accept(isVideo);
                    }

                    if (jsonResult.has("event") && jsonResult.getString("event").equals("accepted")) {
                        isConnected = true;

                        if (isVideo) {
                            runOnUiThread(this::setupLocalVideoRender);
                        }

                        Message message = Message.obtain();
                        message.what = 0;
                        handler.sendMessage(message);

                        Message stopTimer = Message.obtain();
                        stopTimer.what = 1;
                        handler.sendMessage(stopTimer);
                    }

                    if (jsonResult.has("event") && jsonResult.getString("event").equals("hangup")) {
                        finish();
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    VideoTrack videoTrack_local = null;
    VideoTrack videoTrack_remote = null;
    @Override
    public void onSetLocalStream(MediaStream stream) {
        localStream = stream;
    }

    MediaStream localStream;
    MediaStream remoteStream;
    @Override
    public void onAddRemoteStream(MediaStream stream) {
        remoteStream = stream;

        if (isVideo) {
            runOnUiThread(this::setupRemoteVideoRender);
        }
    }

    void setupLocalVideoRender() {
        /*Attempt to read from field 'java.util.List org.webrtc.MediaStream.audioTracks' on a null object reference*/
        if (localStream != null) {
            for (AudioTrack audioTrack : localStream.audioTracks) {
                audioTrack.setEnabled(true);
            }

            for (VideoTrack videoTrack : localStream.videoTracks) {
                videoTrack.setEnabled(true);
                /*java.lang.IllegalArgumentException: The VideoSink is not allowed to be null*/
                if (localRender != null) {
                    videoTrack.addSink(localRender);
                }
            }
        }
    }

    void setupRemoteVideoRender() {
        /*Attempt to read from field 'java.util.List org.webrtc.MediaStream.audioTracks' on a null object reference*/
        if (remoteStream != null) {
            for (AudioTrack audioTrack : remoteStream.audioTracks) {
                audioTrack.setEnabled(true);
            }

            for (VideoTrack videoTrack : remoteStream.videoTracks) {
                videoTrack.setEnabled(true);
                /*java.lang.IllegalArgumentException: The VideoSink is not allowed to be null*/
                if (remoteRender != null) {
                    videoTrack.addSink(remoteRender);
                }
            }
        }
    }

    private void removeAllViews() {
        layoutHangup.removeAllViews();
        layoutAccept.removeAllViews();
        layoutCancel.removeAllViews();
        layoutHead.removeAllViews();

        mLlBtnSwitchCamera.removeAllViews();
        mLlBtnPrtSc.removeAllViews();
        mLlBtnRecMedia.removeAllViews();

        if (videoTrack_remote != null && isVideo) {
            videoTrack_remote.dispose();
            videoTrack_remote = null;
        }

        if (videoTrack_local != null && isVideo) {
            videoTrack_local.dispose();
            videoTrack_local = null;
        }

        local_view.clearImage();
        local_view.release();
        local_view.setVisibility(View.GONE);
        remote_view.clearImage();
        remote_view.release();
        remote_view.setVisibility(View.GONE);

        localRender = null;
        remoteRender = null;

        setContentView(R.layout.empty_layout);
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    /*Forbid physic back keycode*/
    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == KeyEvent.KEYCODE_BACK ) {
            //do something.
            return true;
        } else {
            return super.dispatchKeyEvent(event);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        if (isMediaRecording) {
            if (isVideo) {
                stopScreenRecording();
            } else {
                rtcAudioRecordThread.exit();
            }
            isMediaRecording = false;
        }

        removeAllViews();

        if (isConnected) {
            VideoCallController.getInstance().closeRtc();
        }

        JanusSessionController.getInstance().unregisterMessageCallbacks(this);
        VideoCallController.getInstance().unregisterMyControlCallBack(this);

        if (mediaPlayer != null) {
            mediaPlayer.release();
            mediaPlayer = null;
        }

        if (timer != null) {
            timer.cancel();
            timer = null;
        }

        tvTime.stop();

        unbindBroadcastReceiver();

        handler.removeCallbacksAndMessages(null);

        LogUtil.d("finished");
    }

    private Handler handler = new Handler( msg -> {
        switch (msg.what) {
            case 0:
                layoutHangup.setVisibility(View.VISIBLE);
                layoutCancel.setVisibility(View.GONE);
                layoutAccept.setVisibility(View.GONE);

                if (isVideo) {
                    layoutHead.setVisibility(View.GONE);
                    mLlBtnSwitchCamera.setVisibility(View.VISIBLE);
                }
                tvTime.setVisibility(View.VISIBLE);
                tvTime.setBase(SystemClock.elapsedRealtime());
                tvTime.start();
                tvName.setText(remoteName);

                mLlBtnRecMedia.setVisibility(View.VISIBLE);
                if (isVideo) {
                    mLlBtnPrtSc.setVisibility(View.VISIBLE);
                }

                break;
            case 1:
                /*
                java.lang.NullPointerException: Attempt to invoke virtual method
                'boolean android.media.MediaPlayer.isPlaying()' on a null object reference FIXME
                */
                if (mediaPlayer!= null && (mediaPlayer.isPlaying() || mediaPlayer.isLooping())) {
                    mediaPlayer.stop();
                }

                if (timer != null) {
                    timer.cancel();
                    timer = null;
                }
                break;
            case 2:
                Toast.makeText(JimipttConfig.getAppContext(), "remote reject", Toast.LENGTH_SHORT).show();
                finish();
                break;
            case 3:
                Toast.makeText(JimipttConfig.getAppContext(), "remote is busy", Toast.LENGTH_SHORT).show();
                finish();
                break;
        }
        return false;
    });

    @Override
    public void onMessage(JSONObject object) {
        try {
            if (object.getString("janus").equals("user_call")) {
                JSONObject janusExt = object.getJSONObject("janus_ext");
                String plugin = janusExt.getString("name");

                if (plugin.equals("videocall")) {
                    int type = janusExt.getInt("type");

                    JSONObject remoteUserInfo = object.getJSONObject("user_info");
                    int remoteId = remoteUserInfo.getInt("user_id");
                    if(1 == type){
                        //reply
                        int isAccept = janusExt.getInt("isAccept");
                        if (1 == isAccept) {
                            // Reject
                            handler.sendEmptyMessageDelayed(2, 3000);
                        }else if (2 == isAccept) {
                            // Accept
                            VideoCallController.getInstance().createPeerConnectionFactory(getApplicationContext(), true, isVideo);
                            VideoCallController.getInstance().call(remoteId+"", isVideo);
                        }else if (4 == isAccept) {
                            // Remote is busy
                            handler.sendEmptyMessageDelayed(3, 3000);
                        }
                    }else if(2 == type){
                        // cancel
                        if (remoteId == this.remoteId) {
                            finish();
                        }
                    }
                }
            }
        } catch (JSONException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void onRecordVoiceSuccess(String filePath) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                File file = new File(filePath);
                UploadFileUtils.UploadFile uploadFile = new UploadFileUtils.UploadFile(
                        UserBean.getInstance().getUid(),
                        UserBean.getInstance().getLockGid(),
                        file.getName(),
                        2,
                        file
                );

                int count = 3; // TODO If upload failed, repeat three times
                boolean uploadRst;
                do {
                    uploadRst = UploadFileUtils.uploadFile(uploadFile);
                    --count;
                } while (count != 0 && !uploadRst);
            }
        }).start();
    }

    @Override
    public void onScreenRecordSuccess(String filePath) {
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this);
        alertDialogBuilder.setMessage("Upload screen record file?");
        alertDialogBuilder.setPositiveButton("yes", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();

                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        File file = videoCompress(filePath);
                        if (file != null) {
                            // Upload compressed file
                            UploadFileUtils.UploadFile uploadFile = new UploadFileUtils.UploadFile(
                                    UserBean.getInstance().getUid(),
                                    UserBean.getInstance().getLockGid(),
                                    file.getName(),
                                    1,
                                    file
                            );

                            int count = 3; // TODO If upload failed, repeat three times
                            boolean uploadRst;
                            do {
                                uploadRst = UploadFileUtils.uploadFile(uploadFile);
                                --count;
                            } while (count != 0 && !uploadRst);
                        }
                    }
                }).start();
            }
        });

        alertDialogBuilder.setNegativeButton("no", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();

                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        videoCompress(filePath);
                    }
                }).start();
            }
        });
        final AlertDialog alertdialog = alertDialogBuilder.create();
        alertdialog.show();
    }

    private File videoCompress(String filePath) {
        File file = null;
        // Get display metrics
        WindowManager windowManager = (WindowManager)getSystemService(Context.WINDOW_SERVICE);
        DisplayMetrics metrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(metrics);
        int screenWidth = metrics.widthPixels;
        int screenHeight = metrics.heightPixels;

        File galleryDir = new File(AppTool.galleryPath);
        if (!galleryDir.exists()) {
            galleryDir.mkdir();
        }

        String path = FileCompress.videoCompress(
                getApplicationContext(),
                filePath,
                AppTool.galleryPath,
                screenWidth,
                screenHeight,
                0);

        if (path.isEmpty()) {
            LogUtil.e("Compress failed");
        } else {
            LogUtil.e("Compress succeeded, path=" + path);

            // Delete original uncompressed file
            File old = new File(filePath);
            if (old.exists()) {
                old.delete();
            }

            // 通知图库更新
            file = new File(path);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) { // 判断SDK版本是不是4.4或者高于4.4
                String[] paths = new String[]{file.getAbsolutePath()};
                MediaScannerConnection.scanFile(getApplicationContext(), paths, null, null);
            } else {
                final Intent intent;
                if (file.isDirectory()) {
                    intent = new Intent(Intent.ACTION_MEDIA_MOUNTED);
                    intent.setClassName("com.android.providers.media", "com.android.providers.media.MediaScannerReceiver");
                    intent.setData(Uri.fromFile(Environment.getExternalStorageDirectory()));
                } else {
                    intent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE);
                    intent.setData(Uri.fromFile(file));
                }
                getApplicationContext().sendBroadcast(intent);
            }
        }

        return file;
    }
}
