package com.jimi.jimitalk.activity;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Vibrator;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.jimi.jimitalk.R;
import com.jimi.jimitalk.bean.UserBean;
import com.jimi.jimitalk.ptt.api.JanusSessionController;
import com.jimi.jimitalk.ptt.api.PocRoomController;
import com.jimi.jimitalk.tools.JimipttConfig;
import com.jimi.jimitalk.tools.LogUtil;
import com.jimi.jimitalk.tools.NetworkUtils;
import com.jimi.jimitalk.tools.ToastUtil;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Administrator
 * @date 2020/1/7
 */
public class TempGroupActivity extends BaseActivity {
    private Button mBtnExit;
    private ImageView mIvMic;

    private TextView mTvPrompt;
    private String prompt;

    private ImageView mIvConnectState;

    private ImageView mIvGroupMember;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_temp_group);

        initData();

        initView();

//        EventBus.getDefault().register(this);

        bindBroadcastReceiver();

        LogUtil.e("临时组对讲界面创建");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        LogUtil.e("临时组对讲界面销毁");

        exitTempGroup();

//        if (EventBus.getDefault().isRegistered(this)) {
//            EventBus.getDefault().unregister(this);
//        }

        unbindBroadcastReceiver();
    }

    /*Forbid physic back keycode*/
    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == KeyEvent.KEYCODE_BACK ) {
            //do something.
            return true;
        } else {
            return super.dispatchKeyEvent(event);
        }
    }

    @Override
    public void startActivityForResult(Intent intent, int requestCode) {
        super.startActivityForResult(intent, requestCode);
    }

    private void initData() {
        if (UserBean.getInstance().isTempGroupExisted()) {
            if (PocRoomController.getInstance().isInOneRoom()) {
                PocRoomController.getInstance().changeRoom(UserBean.getInstance().getTempGroup().getGroupId());
            } else {
                PocRoomController.getInstance().joinRoom(UserBean.getInstance().getTempGroup().getGroupId());
            }
        }
    }

    private void exitTempGroup() {
        UserBean.getInstance().setTempGroup(null);

        // Back to locked normal group
        PocRoomController.getInstance().changeRoom(UserBean.getInstance().getLockGid());
    }

    @SuppressLint("ClickableViewAccessibility")
    private void initView() {
        mBtnExit = findViewById(R.id.temp_group_exit);
        mBtnExit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });

        mIvMic = findViewById(R.id.temp_group_talk_mic);
        mIvMic.setOnTouchListener((view, event) -> {
            if (!NetworkUtils.isNetWorkAvailable(JimipttConfig.getAppContext())) {
                ToastUtil.show(getResources().getString(R.string.network_disconnected), 0);
                return false;
            }

            if (!JanusSessionController.getInstance().isConnected()) {
                ToastUtil.show(getResources().getString(R.string.server_disconnected), 0);
                return false;
            }

            if (MotionEvent.ACTION_DOWN == event.getAction()) {
//                Glide.with(getApplicationContext()).load(R.drawable.talk_pre).into(mIvMic);
                mIvMic.setImageResource(R.drawable.talk_pre);
                //添加了震动
                Vibrator vibrator=(Vibrator)getSystemService(Service.VIBRATOR_SERVICE);
                vibrator.vibrate(new long[]{0, 20}, -1);

                if (UserBean.getInstance().isTempGroupExisted()) {
                    PocRoomController.getInstance().talk(UserBean.getInstance().getTempGroup().getGroupId());
                }
            }else if (MotionEvent.ACTION_UP == event.getAction()) {
//                Glide.with(getApplicationContext()).load(R.drawable.talk_nor).into(mIvMic);
                mIvMic.setImageResource(R.drawable.talk_nor);

                if (UserBean.getInstance().isTempGroupExisted()) {
                    PocRoomController.getInstance().untalk(UserBean.getInstance().getTempGroup().getGroupId());
                }
            }
            return false;
        });

        mTvPrompt = findViewById(R.id.temp_group_talk_prompt);

        mIvConnectState = findViewById(R.id.temp_group_talk_state);
        mIvConnectState.setImageResource(R.drawable.ic_state_gray_24dp);

//        mIvGroupMember = findViewById(R.id.temp_group_member);
//        mIvGroupMember.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                Intent tempGroupMember = new Intent(TempGroupActivity.this, TempGroupMemberActivity.class);
//                startActivityForResult(tempGroupMember, 1000);
//            }
//        });
    }

    private void promptChange(String content) {
        mTvPrompt.setText(content);
    }

    private void connectStateChange(int resId) {
        mIvConnectState.setImageResource(resId);
    }

//    @Subscribe(threadMode = ThreadMode.MAIN)
//    public void setEvent(EventBusCarrier event) {
//        if (event.getEventType().equals("talkholder")) {
//            prompt = event.getObject().toString() + " is talking";
//            promptChange(prompt);
//            connectStateChange(R.drawable.ic_state_red_24dp);
//        }
//
//        if (event.getEventType().equals("talkfreed")
//                || event.getEventType().equals("roomchanged")
//                || event.getEventType().equals("joined")) {
//            prompt = getResources().getString(R.string.idle);
//            promptChange(prompt);
//            connectStateChange(R.drawable.ic_state_green_24dp);
//        }
//
//        if (event.getEventType().equals("pocroom")) {
//            String state = event.getObject().toString();
//            if (state.equals("disconnected")) {
//                connectStateChange(R.drawable.ic_state_gray_24dp);
//                prompt = getResources().getString(R.string.reconnecting);
//                promptChange(prompt);
//            }
//
//            if (state.equals("connected")) {
//                connectStateChange(R.drawable.ic_state_green_24dp);
//                prompt = getResources().getString(R.string.idle);
//                promptChange(prompt);
//            }
//        }
//
//        if (event.getEventType().equals("temp_group")) {
//            //close temp group activity
//            if (event.getObject().toString().equals("destroyed")) {
//                finish();
//            }
//        }
//    }

    BroadcastReceiver receiver;
    private void bindBroadcastReceiver() {
        final String SYS_NET_CONNECTION_STATE_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";
        final String JIMI = "jimi";

        receiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();

                if (JIMI.equals(action)) {
                    try {
                        JSONObject content = new JSONObject(intent.getStringExtra("content"));
                        String key = content.getString("key");
                        String value = content.getString("value");

                        if (key.equals("temp_group")) {
                            if (value.equals("destroyed")) {
                                //close temp group activity
                                finish();
                            }
                        }

                        if (key.equals("pocroom")) {
                            if (value.equals("disconnected")) {
                                connectStateChange(R.drawable.ic_state_gray_24dp);
                                prompt = getResources().getString(R.string.reconnecting);
                                promptChange(prompt);
                            }

                            if (value.equals("connected")) {
                                connectStateChange(R.drawable.ic_state_green_24dp);
                                prompt = getResources().getString(R.string.idle);
                                promptChange(prompt);
                            }
                        }

                        if (key.equals("talkfreed") || key.equals("roomchanged") || key.equals("joined")) {
                            prompt = getResources().getString(R.string.idle);
                            promptChange(prompt);
                            connectStateChange(R.drawable.ic_state_green_24dp);
                        }

                        if (key.equals("talkholder")) {
                            prompt = value + " is talking";
                            promptChange(prompt);
                            connectStateChange(R.drawable.ic_state_red_24dp);
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        };

        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(SYS_NET_CONNECTION_STATE_CHANGE);
        intentFilter.addAction(JIMI);
        registerReceiver(receiver, intentFilter);
    }

    private void unbindBroadcastReceiver() {
        if (receiver != null) {
            unregisterReceiver(receiver);
        }
    }
}
