/*
 * Decompiled with CFR 0.152.
 */
package net.grandcentrix.tray.provider;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.grandcentrix.tray.core.OnTrayPreferenceChangeListener;
import net.grandcentrix.tray.core.TrayException;
import net.grandcentrix.tray.core.TrayItem;
import net.grandcentrix.tray.core.TrayLog;
import net.grandcentrix.tray.core.TrayRuntimeException;
import net.grandcentrix.tray.core.TrayStorage;
import net.grandcentrix.tray.provider.TrayProviderHelper;
import net.grandcentrix.tray.provider.TrayUri;

public class ContentProviderStorage
extends TrayStorage {
    public static final String VERSION = "version";
    @VisibleForTesting
    Map<OnTrayPreferenceChangeListener, Handler> mListeners = new ConcurrentHashMap<OnTrayPreferenceChangeListener, Handler>();
    @VisibleForTesting
    TrayContentObserver mObserver;
    @VisibleForTesting
    HandlerThread mObserverThread;
    private final Context mContext;
    private final TrayProviderHelper mProviderHelper;
    private volatile boolean mRegisteredContentObserver = false;
    private final TrayUri mTrayUri;

    public ContentProviderStorage(@NonNull Context context, @NonNull String module, @NonNull TrayStorage.Type type) {
        super(module, type);
        this.mContext = context.getApplicationContext();
        this.mTrayUri = new TrayUri(this.mContext);
        this.mProviderHelper = new TrayProviderHelper(this.mContext);
    }

    @Override
    public void annex(TrayStorage oldStorage) {
        for (TrayItem trayItem : oldStorage.getAll()) {
            this.put(trayItem);
        }
        oldStorage.wipe();
    }

    @Override
    public boolean clear() {
        Uri uri = this.mTrayUri.builder().setModule(this.getModuleName()).setType(this.getType()).build();
        return this.mProviderHelper.remove(uri);
    }

    @Override
    @Nullable
    public TrayItem get(@NonNull String key) {
        Uri uri = this.mTrayUri.builder().setType(this.getType()).setModule(this.getModuleName()).setKey(key).build();
        List<TrayItem> prefs = this.mProviderHelper.queryProviderSafe(uri);
        int size = prefs.size();
        if (size > 1) {
            TrayLog.w("found more than one item for key '" + key + "' in module " + this.getModuleName() + ". This can be caused by using the same name for a device and user specific preference.");
            for (int i = 0; i < prefs.size(); ++i) {
                TrayItem pref = prefs.get(i);
                TrayLog.d("item #" + i + " " + pref);
            }
        }
        return size > 0 ? prefs.get(0) : null;
    }

    @Override
    @NonNull
    public Collection<TrayItem> getAll() {
        Uri uri = this.mTrayUri.builder().setType(this.getType()).setModule(this.getModuleName()).build();
        return this.mProviderHelper.queryProviderSafe(uri);
    }

    public Context getContext() {
        return this.mContext;
    }

    @Override
    public int getVersion() throws TrayException {
        Uri internalUri = this.mTrayUri.builder().setInternal(true).setType(this.getType()).setModule(this.getModuleName()).setKey(VERSION).build();
        List<TrayItem> trayItems = this.mProviderHelper.queryProvider(internalUri);
        if (trayItems.size() == 0) {
            return 0;
        }
        return Integer.valueOf(trayItems.get(0).value());
    }

    @Override
    public boolean put(TrayItem item) {
        return this.put(item.key(), item.migratedKey(), item.value());
    }

    @Override
    public boolean put(@NonNull String key, @Nullable Object data) {
        return this.put(key, null, data);
    }

    @Override
    public boolean put(@NonNull String key, @Nullable String migrationKey, @Nullable Object data) {
        if (this.getType() == TrayStorage.Type.UNDEFINED) {
            throw new TrayRuntimeException("writing data into a storage with type UNDEFINED is forbidden. Only Read and delete is allowed.");
        }
        String value = data == null ? null : String.valueOf(data);
        Uri uri = this.mTrayUri.builder().setType(this.getType()).setModule(this.getModuleName()).setKey(key).build();
        return this.mProviderHelper.persist(uri, value, migrationKey);
    }

    @Override
    @TargetApi(value=16)
    public synchronized void registerOnTrayPreferenceChangeListener(@NonNull OnTrayPreferenceChangeListener listener) {
        block3: {
            if (listener == null) {
                return;
            }
            Handler handler = null;
            Looper looper = Looper.myLooper();
            if (looper != null) {
                handler = new Handler(looper);
            }
            this.mListeners.put(listener, handler);
            Set<OnTrayPreferenceChangeListener> listeners = this.mListeners.keySet();
            if (listeners.size() != 1) break block3;
            this.mObserverThread = new HandlerThread("observer"){

                protected void onLooperPrepared() {
                    super.onLooperPrepared();
                    ContentProviderStorage.this.mObserver = new TrayContentObserver(new Handler(this.getLooper()));
                    Uri observingUri = ContentProviderStorage.this.mTrayUri.builder().setType(ContentProviderStorage.this.getType()).setModule(ContentProviderStorage.this.getModuleName()).build();
                    ContentProviderStorage.this.mContext.getContentResolver().registerContentObserver(observingUri, true, (ContentObserver)ContentProviderStorage.this.mObserver);
                    ContentProviderStorage.this.mRegisteredContentObserver = true;
                }
            };
            this.mObserverThread.start();
            while (!this.mRegisteredContentObserver) {
            }
            this.mRegisteredContentObserver = false;
        }
    }

    @Override
    public boolean remove(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("null is not valid. use clear or wipe to delete all preferences");
        }
        Uri uri = this.mTrayUri.builder().setType(this.getType()).setModule(this.getModuleName()).setKey(key).build();
        return this.mProviderHelper.removeAndCount(uri) > 0;
    }

    @Override
    public boolean setVersion(int version) {
        if (this.getType() == TrayStorage.Type.UNDEFINED) {
            throw new TrayRuntimeException("writing data into a storage with type UNDEFINED is forbidden. Only Read and delete is allowed.");
        }
        Uri uri = this.mTrayUri.builder().setInternal(true).setType(this.getType()).setModule(this.getModuleName()).setKey(VERSION).build();
        return this.mProviderHelper.persist(uri, String.valueOf(version));
    }

    @Override
    public void unregisterOnTrayPreferenceChangeListener(@NonNull OnTrayPreferenceChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.size() == 0) {
            this.mContext.getContentResolver().unregisterContentObserver((ContentObserver)this.mObserver);
            this.mObserver = null;
            this.mObserverThread.quit();
            this.mObserverThread = null;
        }
    }

    @Override
    public boolean wipe() {
        boolean cleared = this.clear();
        if (!cleared) {
            return false;
        }
        Uri uri = this.mTrayUri.builder().setInternal(true).setType(this.getType()).setModule(this.getModuleName()).build();
        return this.mProviderHelper.remove(uri);
    }

    @VisibleForTesting
    class TrayContentObserver
    extends ContentObserver {
        public TrayContentObserver(Handler handler) {
            super(handler);
        }

        public void onChange(boolean selfChange) {
            this.onChange(selfChange, null);
        }

        public void onChange(boolean selfChange, Uri uri) {
            if (uri == null) {
                uri = ContentProviderStorage.this.mTrayUri.builder().setModule(ContentProviderStorage.this.getModuleName()).build();
            }
            final List<TrayItem> trayItems = ContentProviderStorage.this.mProviderHelper.queryProviderSafe(uri);
            HashSet<Map.Entry<OnTrayPreferenceChangeListener, Handler>> entries = new HashSet<Map.Entry<OnTrayPreferenceChangeListener, Handler>>(ContentProviderStorage.this.mListeners.entrySet());
            for (Map.Entry entry : entries) {
                final OnTrayPreferenceChangeListener listener = (OnTrayPreferenceChangeListener)entry.getKey();
                Handler handler = (Handler)entry.getValue();
                if (handler != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onTrayPreferenceChanged(trayItems);
                        }
                    });
                    continue;
                }
                listener.onTrayPreferenceChanged(trayItems);
            }
        }
    }
}

