/*
 * Decompiled with CFR 0.152.
 */
package com.jiechic.library.android.snappy;

import com.jiechic.library.android.snappy.SnappyNative;
import java.io.File;

public class SnappyLoader {
    private static boolean isLoaded = false;
    private static volatile SnappyNative snappyApi = null;
    private static File nativeLibFile = null;

    static void cleanUpExtractedNativeLib() {
        if (nativeLibFile != null && nativeLibFile.exists()) {
            boolean deleted = nativeLibFile.delete();
            if (!deleted) {
                // empty if block
            }
            snappyApi = null;
        }
    }

    static synchronized void setSnappyApi(SnappyNative nativeCode) {
        snappyApi = nativeCode;
    }

    static synchronized SnappyNative loadSnappyApi() {
        if (snappyApi != null) {
            return snappyApi;
        }
        SnappyLoader.loadNativeLibrary();
        SnappyLoader.setSnappyApi(new SnappyNative());
        return snappyApi;
    }

    private static synchronized void loadNativeLibrary() {
        if (!isLoaded) {
            System.loadLibrary("snappy-android");
            isLoaded = true;
        }
    }
}

