/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.model.sqlite.BookmarkTable;
import com.folioreader.ui.adapter.BookmarkAdapter;
import com.folioreader.util.AppUtil;
import java.io.Serializable;
import java.util.HashMap;

public class BookmarkFragment
extends Fragment
implements BookmarkAdapter.BookmarkAdapterCallback {
    private static final String BOOKMARK_ITEM = "bookmark_item";
    private String mBookId;
    private View mRootView;
    private BookmarkAdapter adapter;

    public static BookmarkFragment newInstance(String bookId, String epubTitle) {
        BookmarkFragment bookmarkFragment = new BookmarkFragment();
        Bundle args = new Bundle();
        args.putString("com.folioreader.extra.BOOK_ID", bookId);
        args.putString("book_title", epubTitle);
        bookmarkFragment.setArguments(args);
        return bookmarkFragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.fragment_bookmark_list, container, false);
        return this.mRootView;
    }

    @Override
    public void onItemClick(HashMap bookmark) {
        Intent intent = new Intent();
        Log.i((String)"BookmarkFragment", (String)("bookmark is clicked: " + bookmark.toString()));
        intent.putExtra(BOOKMARK_ITEM, (Serializable)bookmark);
        intent.putExtra("type", "bookmark_selected");
        this.getActivity().setResult(-1, intent);
        this.getActivity().finish();
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        Log.i((String)"Bookmark fragment", (String)"onViewCreated: inside onViewCreated ");
        super.onViewCreated(view, savedInstanceState);
        RecyclerView bookmarksView = (RecyclerView)this.mRootView.findViewById(R.id.rv_bookmarks);
        Config config = AppUtil.getSavedConfig((Context)this.getActivity());
        this.mBookId = this.getArguments().getString("com.folioreader.extra.BOOK_ID");
        Log.i((String)"Bookmark fragment", (String)("onViewCreated: mbookID " + this.mBookId));
        if (config.isNightMode()) {
            this.mRootView.findViewById(R.id.rv_bookmarks).setBackgroundColor(ContextCompat.getColor((Context)this.getActivity(), (int)R.color.black));
        }
        bookmarksView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        bookmarksView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this.getActivity(), 1));
        this.adapter = new BookmarkAdapter((Context)this.getActivity(), BookmarkTable.getBookmarksForID(this.mBookId, (Context)this.getActivity()), this, config);
        bookmarksView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    @Override
    public void deleteBookmark(String date, String name) {
        Log.i((String)"BookmarkFragment", (String)"deleteBookmark: ");
        BookmarkTable.deleteBookmark(date, name, (Context)this.getActivity());
    }
}

