/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.ui.view.UnderlinedTextView;
import java.util.ArrayList;
import java.util.HashMap;

public class BookmarkAdapter
extends RecyclerView.Adapter<BookmarkHolder> {
    private ArrayList<HashMap> bookmarks;
    private BookmarkAdapterCallback callback;
    private Context context;
    private Config config;

    public BookmarkAdapter(Context context, ArrayList<HashMap> bookmarks, BookmarkAdapterCallback callback, Config config) {
        this.context = context;
        this.bookmarks = bookmarks;
        this.callback = callback;
        this.config = config;
    }

    public BookmarkHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new BookmarkHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.row_bookmark, parent, false));
    }

    public void onBindViewHolder(final BookmarkHolder holder, final int position) {
        holder.container.postDelayed(new Runnable(){

            @Override
            public void run() {
                ((AppCompatActivity)BookmarkAdapter.this.context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        holder.container.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
                    }
                });
            }
        }, 10L);
        holder.content.setText(this.bookmarks.get(position).get("name").toString());
        holder.date.setText((CharSequence)this.bookmarks.get(position).get("date").toString());
        holder.container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BookmarkAdapter.this.callback.onItemClick(BookmarkAdapter.this.getItem(position));
            }
        });
        holder.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BookmarkAdapter.this.callback.deleteBookmark(((HashMap)BookmarkAdapter.this.bookmarks.get(position)).get("date").toString(), ((HashMap)BookmarkAdapter.this.bookmarks.get(position)).get("name").toString());
                BookmarkAdapter.this.bookmarks.remove(position);
                BookmarkAdapter.this.notifyDataSetChanged();
            }
        });
        holder.container.postDelayed(new Runnable(){

            @Override
            public void run() {
                final int height = holder.container.getHeight();
                ((AppCompatActivity)BookmarkAdapter.this.context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ViewGroup.LayoutParams params = holder.swipeLinearLayout.getLayoutParams();
                        params.height = height;
                        holder.swipeLinearLayout.setLayoutParams(params);
                    }
                });
            }
        }, 30L);
        if (this.config.isNightMode()) {
            holder.container.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.black));
            holder.date.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
            holder.content.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
        } else {
            holder.container.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
            holder.date.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.black));
            holder.content.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.black));
        }
    }

    public int getItemCount() {
        Log.i((String)"bookmarkAdapter", (String)("getItemCount: bookmarks.size = " + this.bookmarks.size()));
        return this.bookmarks.size();
    }

    private HashMap getItem(int position) {
        return this.bookmarks.get(position);
    }

    public static interface BookmarkAdapterCallback {
        public void onItemClick(HashMap var1);

        public void deleteBookmark(String var1, String var2);
    }

    static class BookmarkHolder
    extends RecyclerView.ViewHolder {
        private UnderlinedTextView content;
        private ImageView delete;
        private TextView date;
        private RelativeLayout container;
        private LinearLayout swipeLinearLayout;

        BookmarkHolder(View itemView) {
            super(itemView);
            this.container = (RelativeLayout)itemView.findViewById(R.id.bookmark_container);
            this.swipeLinearLayout = (LinearLayout)itemView.findViewById(R.id.bookmark_swipe_linear_layout);
            this.content = (UnderlinedTextView)itemView.findViewById(R.id.utv_bookmark_content);
            this.delete = (ImageView)itemView.findViewById(R.id.iv_bookmark_delete);
            this.date = (TextView)itemView.findViewById(R.id.tv_bookmark_date);
        }
    }
}

