/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.util;

import android.os.Environment;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0007J\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0007R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/folioreader/util/FontFinder;", "", "()V", "sysFonts", "", "", "Ljava/io/File;", "getFontFile", "key", "getSystemFonts", "getUserFonts", "isSystemFont", "", "folioreader_release"})
public final class FontFinder {
    private static Map<String, ? extends File> sysFonts;
    public static final FontFinder INSTANCE;

    @JvmStatic
    @NotNull
    public static final Map<String, File> getSystemFonts() {
        if (sysFonts != null) {
            Map<String, File> map = sysFonts;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            return map;
        }
        HashMap fonts = new HashMap();
        File sysFontDir = new File("/system/fonts/");
        String fontSuffix = ".ttf";
        File[] fileArray = sysFontDir.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            String fontName;
            File fontFile;
            File file = fontFile = fileArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"fontFile");
            Intrinsics.checkExpressionValueIsNotNull((Object)file.getName(), (String)"fontFile.name");
            if (!StringsKt.endsWith$default((String)fontName, (String)fontSuffix, (boolean)false, (int)2, null)) continue;
            String key = ((Object)fontName.subSequence(0, StringsKt.lastIndexOf$default((CharSequence)fontName, (String)fontSuffix, (int)0, (boolean)false, (int)6, null))).toString();
            ((Map)fonts).put(key, fontFile);
        }
        sysFonts = fonts;
        return fonts;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, File> getUserFonts() {
        HashMap fonts = new HashMap();
        File[] fontDirs = new File[]{new File(Environment.getExternalStorageDirectory(), "Fonts/")};
        String fontSuffix = ".ttf";
        File[] $this$forEach$iv = fontDirs;
        boolean $i$f$forEach = false;
        File[] fileArray = $this$forEach$iv;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File fontDir = element$iv = fileArray[i];
            boolean bl = false;
            if (!fontDir.exists() || !fontDir.isDirectory()) continue;
            Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)fontDir)), (Function1)((Function1)new Function1<File, Boolean>(fontSuffix, fonts){
                final /* synthetic */ String $fontSuffix$inlined;
                final /* synthetic */ HashMap $fonts$inlined;
                {
                    this.$fontSuffix$inlined = string2;
                    this.$fonts$inlined = hashMap;
                    super(1);
                }

                public final boolean invoke(@NotNull File f) {
                    Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
                    String string2 = f.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"f.name");
                    return StringsKt.endsWith$default((String)string2, (String)this.$fontSuffix$inlined, (boolean)false, (int)2, null);
                }
            }));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String fontName;
                File fontFile = (File)element$iv2;
                boolean bl2 = false;
                String string2 = fontName = fontFile.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fontName");
                String key = ((Object)fontName.subSequence(0, StringsKt.lastIndexOf$default((CharSequence)string2, (String)fontSuffix, (int)0, (boolean)false, (int)6, null))).toString();
                ((Map)fonts).put(key, fontFile);
            }
        }
        return fonts;
    }

    @JvmStatic
    @Nullable
    public static final File getFontFile(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Map<String, File> system = FontFinder.getSystemFonts();
        Map<String, File> user = FontFinder.getUserFonts();
        return system.containsKey(key) ? system.get(key) : (user.containsKey(key) ? user.get(key) : null);
    }

    @JvmStatic
    public static final boolean isSystemFont(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return FontFinder.getSystemFonts().containsKey(key);
    }

    private FontFinder() {
    }

    static {
        FontFinder fontFinder;
        INSTANCE = fontFinder = new FontFinder();
    }
}

