/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.view;

import android.app.SearchManager;
import android.content.ComponentName;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.appcompat.widget.SearchView;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.util.UiUtil;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u000eR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/folioreader/ui/view/FolioSearchView;", "Landroidx/appcompat/widget/SearchView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "searchAutoComplete", "Landroidx/appcompat/widget/SearchView$SearchAutoComplete;", "adjustLayout", "", "applyTheme", "config", "Lcom/folioreader/Config;", "init", "componentName", "Landroid/content/ComponentName;", "setDayMode", "setNightMode", "Companion", "folioreader_release"})
public final class FolioSearchView
extends SearchView {
    private SearchView.SearchAutoComplete searchAutoComplete;
    @JvmField
    @NotNull
    public static final String LOG_TAG;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    public final void init(@NotNull ComponentName componentName, @NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Log.v((String)LOG_TAG, (String)"-> init");
        Object object = this.getContext().getSystemService("search");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.SearchManager");
        }
        SearchManager searchManager = (SearchManager)object;
        this.setSearchableInfo(searchManager.getSearchableInfo(componentName));
        this.setIconifiedByDefault(false);
        this.adjustLayout();
        this.applyTheme(config);
    }

    private final void adjustLayout() {
        Log.v((String)LOG_TAG, (String)"-> adjustLayout");
        View view = this.findViewById(R.id.search_mag_icon);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.search_mag_icon)");
        View searchMagIcon = view;
        searchMagIcon.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
        View view2 = this.findViewById(R.id.search_edit_frame);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.search_edit_frame)");
        View searchEditFrame = view2;
        if (searchEditFrame.getLayoutParams() == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ((ViewGroup.MarginLayoutParams)searchEditFrame.getLayoutParams()).leftMargin = 0;
    }

    private final void applyTheme(Config config) {
        Log.v((String)LOG_TAG, (String)"-> applyTheme");
        View view = this.findViewById(R.id.search_close_btn);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.search_close_btn)");
        ImageView searchCloseButton = (ImageView)view;
        UiUtil.setColorIntToDrawable(config.getCurrentThemeColor(), searchCloseButton.getDrawable());
        View view2 = this.findViewById(R.id.search_src_text);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.search_src_text)");
        SearchView.SearchAutoComplete searchAutoComplete = this.searchAutoComplete = (SearchView.SearchAutoComplete)view2;
        if (searchAutoComplete == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchAutoComplete");
        }
        UiUtil.setEditTextCursorColor((EditText)searchAutoComplete, config.getCurrentThemeColor());
        SearchView.SearchAutoComplete searchAutoComplete2 = this.searchAutoComplete;
        if (searchAutoComplete2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchAutoComplete");
        }
        UiUtil.setEditTextHandleColor((EditText)searchAutoComplete2, config.getCurrentThemeColor());
        SearchView.SearchAutoComplete searchAutoComplete3 = this.searchAutoComplete;
        if (searchAutoComplete3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchAutoComplete");
        }
        searchAutoComplete3.setHighlightColor(ColorUtils.setAlphaComponent((int)config.getCurrentThemeColor(), (int)85));
        if (config.isNightMode()) {
            SearchView.SearchAutoComplete searchAutoComplete4 = this.searchAutoComplete;
            if (searchAutoComplete4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchAutoComplete");
            }
            searchAutoComplete4.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.night_title_text_color));
            SearchView.SearchAutoComplete searchAutoComplete5 = this.searchAutoComplete;
            if (searchAutoComplete5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchAutoComplete");
            }
            searchAutoComplete5.setHintTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.night_text_color));
        } else {
            SearchView.SearchAutoComplete searchAutoComplete6 = this.searchAutoComplete;
            if (searchAutoComplete6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchAutoComplete");
            }
            searchAutoComplete6.setHintTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.edit_text_hint_color));
        }
    }

    public final void setDayMode() {
        SearchView.SearchAutoComplete searchAutoComplete = this.searchAutoComplete;
        if (searchAutoComplete == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchAutoComplete");
        }
        searchAutoComplete.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.black));
    }

    public final void setNightMode() {
        SearchView.SearchAutoComplete searchAutoComplete = this.searchAutoComplete;
        if (searchAutoComplete == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchAutoComplete");
        }
        searchAutoComplete.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.white));
    }

    public FolioSearchView(@Nullable Context context) {
        super(context);
    }

    public FolioSearchView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public FolioSearchView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    static {
        Companion = new Companion(null);
        String string2 = FolioSearchView.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FolioSearchView::class.java.simpleName");
        LOG_TAG = string2;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/folioreader/ui/view/FolioSearchView$Companion;", "", "()V", "LOG_TAG", "", "folioreader_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

