/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.base;

import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.folioreader.model.dictionary.Dictionary;
import com.folioreader.network.TLSSocketFactory;
import com.folioreader.ui.base.DictionaryCallBack;
import com.folioreader.util.AppUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class DictionaryTask
extends AsyncTask<String, Void, Dictionary> {
    private static final String TAG = "DictionaryTask";
    private DictionaryCallBack callBack;

    public DictionaryTask(DictionaryCallBack callBack) {
        this.callBack = callBack;
    }

    protected Dictionary doInBackground(String ... strings) {
        String strUrl = strings[0];
        try {
            String line;
            Log.v((String)TAG, (String)("-> doInBackground -> url -> " + strUrl));
            URL url = new URL(strUrl);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
            if (Build.VERSION.SDK_INT <= 20) {
                httpsURLConnection.setSSLSocketFactory(new TLSSocketFactory());
            }
            InputStream inputStream = httpsURLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, AppUtil.charsetNameForURLConnection(httpsURLConnection)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
            return (Dictionary)objectMapper.readValue(stringBuilder.toString(), Dictionary.class);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"DictionaryTask failed", (Throwable)e);
            return null;
        }
    }

    protected void onPostExecute(Dictionary dictionary) {
        super.onPostExecute((Object)dictionary);
        if (dictionary != null) {
            this.callBack.onDictionaryDataReceived(dictionary);
        } else {
            this.callBack.onError();
        }
        this.cancel(true);
    }
}

