/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.model.TOCLinkWrapper;
import com.folioreader.ui.adapter.TOCAdapter;
import com.folioreader.util.AppUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;

public class TableOfContentFragment
extends Fragment
implements TOCAdapter.TOCCallback {
    private TOCAdapter mTOCAdapter;
    private RecyclerView mTableOfContentsRecyclerView;
    private TextView errorView;
    private Config mConfig;
    private String mBookTitle;
    private Publication publication;

    public static TableOfContentFragment newInstance(Publication publication, String selectedChapterHref, String bookTitle) {
        TableOfContentFragment tableOfContentFragment = new TableOfContentFragment();
        Bundle args = new Bundle();
        args.putSerializable("PUBLICATION", (Serializable)publication);
        args.putString("selected_chapter_position", selectedChapterHref);
        args.putString("book_title", bookTitle);
        tableOfContentFragment.setArguments(args);
        return tableOfContentFragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.publication = (Publication)this.getArguments().getSerializable("PUBLICATION");
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View mRootView = inflater.inflate(R.layout.fragment_contents, container, false);
        this.mConfig = AppUtil.getSavedConfig((Context)this.getActivity());
        this.mBookTitle = this.getArguments().getString("book_title");
        if (this.mConfig.isNightMode()) {
            mRootView.findViewById(R.id.recycler_view_menu).setBackgroundColor(ContextCompat.getColor((Context)this.getActivity(), (int)R.color.black));
        }
        return mRootView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mTableOfContentsRecyclerView = (RecyclerView)view.findViewById(R.id.recycler_view_menu);
        this.errorView = (TextView)view.findViewById(R.id.tv_error);
        this.configRecyclerViews();
        this.initAdapter();
    }

    public void configRecyclerViews() {
        this.mTableOfContentsRecyclerView.setHasFixedSize(true);
        this.mTableOfContentsRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity(), 1, false));
        this.mTableOfContentsRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this.getActivity(), 1));
    }

    private void initAdapter() {
        if (this.publication != null) {
            if (!this.publication.getTableOfContents().isEmpty()) {
                ArrayList<TOCLinkWrapper> tocLinkWrappers = new ArrayList<TOCLinkWrapper>();
                for (Link tocLink : this.publication.getTableOfContents()) {
                    TOCLinkWrapper tocLinkWrapper = TableOfContentFragment.createTocLinkWrapper(tocLink, 0);
                    tocLinkWrappers.add(tocLinkWrapper);
                }
                this.onLoadTOC(tocLinkWrappers);
            } else {
                this.onLoadTOC(TableOfContentFragment.createTOCFromSpine(this.publication.getReadingOrder()));
            }
        } else {
            this.onError();
        }
    }

    private static TOCLinkWrapper createTocLinkWrapper(Link tocLink, int indentation) {
        TOCLinkWrapper tocLinkWrapper = new TOCLinkWrapper(tocLink, indentation);
        for (Link tocLink1 : tocLink.getChildren()) {
            TOCLinkWrapper tocLinkWrapper1 = TableOfContentFragment.createTocLinkWrapper(tocLink1, indentation + 1);
            if (tocLinkWrapper1.getIndentation() == 3) continue;
            tocLinkWrapper.addChild(tocLinkWrapper1);
        }
        return tocLinkWrapper;
    }

    private static ArrayList<TOCLinkWrapper> createTOCFromSpine(List<Link> spine) {
        ArrayList<TOCLinkWrapper> tocLinkWrappers = new ArrayList<TOCLinkWrapper>();
        for (Link link : spine) {
            Link tocLink = new Link();
            tocLink.setTitle(link.getTitle());
            tocLink.setHref(link.getHref());
            tocLinkWrappers.add(new TOCLinkWrapper(tocLink, 0));
        }
        return tocLinkWrappers;
    }

    public void onLoadTOC(ArrayList<TOCLinkWrapper> tocLinkWrapperList) {
        this.mTOCAdapter = new TOCAdapter((Context)this.getActivity(), tocLinkWrapperList, this.getArguments().getString("selected_chapter_position"), this.mConfig);
        this.mTOCAdapter.setCallback(this);
        this.mTableOfContentsRecyclerView.setAdapter((RecyclerView.Adapter)this.mTOCAdapter);
    }

    public void onError() {
        this.errorView.setVisibility(0);
        this.mTableOfContentsRecyclerView.setVisibility(8);
        this.errorView.setText((CharSequence)"Table of content \n not found");
    }

    @Override
    public void onTocClicked(int position) {
        TOCLinkWrapper tocLinkWrapper = (TOCLinkWrapper)this.mTOCAdapter.getItemAt(position);
        Intent intent = new Intent();
        intent.putExtra("selected_chapter_position", tocLinkWrapper.getTocLink().getHref());
        intent.putExtra("book_title", tocLinkWrapper.getTocLink().getTitle());
        intent.putExtra("type", "chapter_selected");
        this.getActivity().setResult(-1, intent);
        this.getActivity().finish();
    }

    @Override
    public void onExpanded(int position) {
        TOCLinkWrapper tocLinkWrapper = (TOCLinkWrapper)this.mTOCAdapter.getItemAt(position);
        if (tocLinkWrapper.getChildren() != null && tocLinkWrapper.getChildren().size() > 0) {
            this.mTOCAdapter.toggleGroup(position);
        }
    }
}

