/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.util;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;

public class ScreenUtils {
    private Context ctx;
    private DisplayMetrics metrics;

    public ScreenUtils(Context ctx) {
        this.ctx = ctx;
        WindowManager wm = (WindowManager)ctx.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        this.metrics = new DisplayMetrics();
        display.getMetrics(this.metrics);
    }

    public int getHeight() {
        return this.metrics.heightPixels;
    }

    public int getWidth() {
        return this.metrics.widthPixels;
    }

    public int getRealHeight() {
        return this.metrics.heightPixels / this.metrics.densityDpi;
    }

    public int getRealWidth() {
        return this.metrics.widthPixels / this.metrics.densityDpi;
    }

    public int getDensity() {
        return this.metrics.densityDpi;
    }

    public int getScale(int picWidth) {
        Display display = ((WindowManager)this.ctx.getSystemService("window")).getDefaultDisplay();
        int width = display.getWidth();
        Double val = new Double(width) / new Double(picWidth);
        val = val * 100.0;
        return val.intValue();
    }
}

