/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.folioreader.Config;
import com.folioreader.R;
import com.folioreader.model.TOCLinkWrapper;
import com.folioreader.util.MultiLevelExpIndListAdapter;
import java.util.ArrayList;

public class TOCAdapter
extends MultiLevelExpIndListAdapter {
    private static final int LEVEL_ONE_PADDING_PIXEL = 15;
    private TOCCallback callback;
    private final Context mContext;
    private String selectedHref;
    private Config mConfig;

    public TOCAdapter(Context context, ArrayList<TOCLinkWrapper> tocLinkWrappers, String selectedHref, Config config) {
        super(tocLinkWrappers);
        this.mContext = context;
        this.selectedHref = selectedHref;
        this.mConfig = config;
    }

    public void setCallback(TOCCallback callback) {
        this.callback = callback;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new TOCRowViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.row_table_of_contents, parent, false));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        TOCRowViewHolder viewHolder = (TOCRowViewHolder)holder;
        TOCLinkWrapper tocLinkWrapper = (TOCLinkWrapper)this.getItemAt(position);
        if (tocLinkWrapper.getChildren() == null || tocLinkWrapper.getChildren().isEmpty()) {
            viewHolder.children.setVisibility(4);
        } else {
            viewHolder.children.setVisibility(0);
        }
        viewHolder.sectionTitle.setText((CharSequence)tocLinkWrapper.getTocLink().getTitle());
        if (this.mConfig.isNightMode()) {
            if (tocLinkWrapper.isGroup()) {
                viewHolder.children.setImageResource(R.drawable.ic_plus_white_24dp);
            } else {
                viewHolder.children.setImageResource(R.drawable.ic_minus_white_24dp);
            }
        } else if (tocLinkWrapper.isGroup()) {
            viewHolder.children.setImageResource(R.drawable.ic_plus_black_24dp);
        } else {
            viewHolder.children.setImageResource(R.drawable.ic_minus_black_24dp);
        }
        int leftPadding = TOCAdapter.getPaddingPixels(this.mContext, 15) * tocLinkWrapper.getIndentation();
        viewHolder.view.setPadding(leftPadding, 0, 0, 0);
        if (tocLinkWrapper.getIndentation() == 0) {
            viewHolder.view.setBackgroundColor(-1);
            viewHolder.sectionTitle.setTextColor(-16777216);
        } else if (tocLinkWrapper.getIndentation() == 1) {
            viewHolder.view.setBackgroundColor(Color.parseColor((String)"#f7f7f7"));
            viewHolder.sectionTitle.setTextColor(-16777216);
        } else if (tocLinkWrapper.getIndentation() == 2) {
            viewHolder.view.setBackgroundColor(Color.parseColor((String)"#b3b3b3"));
            viewHolder.sectionTitle.setTextColor(-1);
        } else if (tocLinkWrapper.getIndentation() == 3) {
            viewHolder.view.setBackgroundColor(Color.parseColor((String)"#f7f7f7"));
            viewHolder.sectionTitle.setTextColor(-16777216);
        }
        if (tocLinkWrapper.getChildren() == null || tocLinkWrapper.getChildren().isEmpty()) {
            viewHolder.children.setVisibility(4);
        } else {
            viewHolder.children.setVisibility(0);
        }
        if (this.mConfig.isNightMode()) {
            viewHolder.container.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.black));
            viewHolder.children.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.black));
            viewHolder.sectionTitle.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.white));
        } else {
            viewHolder.container.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.white));
            viewHolder.children.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.white));
            viewHolder.sectionTitle.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.black));
        }
        if (tocLinkWrapper.getTocLink().getHref().equals(this.selectedHref)) {
            viewHolder.sectionTitle.setTextColor(this.mConfig.getCurrentThemeColor());
        }
    }

    private static int getPaddingPixels(Context context, int dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)dpValue * scale + 0.5f);
    }

    public static interface TOCCallback {
        public void onTocClicked(int var1);

        public void onExpanded(int var1);
    }

    public class TOCRowViewHolder
    extends RecyclerView.ViewHolder {
        public ImageView children;
        TextView sectionTitle;
        private LinearLayout container;
        private View view;

        TOCRowViewHolder(View itemView) {
            super(itemView);
            this.view = itemView;
            this.children = (ImageView)itemView.findViewById(R.id.children);
            this.container = (LinearLayout)itemView.findViewById(R.id.container);
            this.children.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TOCAdapter.this.callback != null) {
                        TOCAdapter.this.callback.onExpanded(TOCRowViewHolder.this.getAdapterPosition());
                    }
                }
            });
            this.sectionTitle = (TextView)itemView.findViewById(R.id.section_title);
            this.view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TOCAdapter.this.callback != null) {
                        TOCAdapter.this.callback.onTocClicked(TOCRowViewHolder.this.getAdapterPosition());
                    }
                }
            });
        }
    }
}

